/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.compressing;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.codecs.lucene90.compressing.FieldsIndex;
import org.apache.lucene.codecs.lucene90.compressing.FieldsIndexReader;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsWriter;
import org.apache.lucene.codecs.lucene90.compressing.StoredFieldsInts;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldDataInput;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;

public final class Lucene90CompressingStoredFieldsReader
extends StoredFieldsReader {
    private static final int PREFETCH_CACHE_SIZE = 16;
    private static final int PREFETCH_CACHE_MASK = 15;
    private final int version;
    private final FieldInfos fieldInfos;
    private final FieldsIndex indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private final long numChunks;
    private final long numDirtyChunks;
    private final long numDirtyDocs;
    private final long[] prefetchedBlockIDCache;
    private int prefetchedBlockIDCacheIndex;
    private boolean closed;

    private Lucene90CompressingStoredFieldsReader(Lucene90CompressingStoredFieldsReader reader, boolean merging) {
        this.version = reader.version;
        this.fieldInfos = reader.fieldInfos;
        this.fieldsStream = reader.fieldsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.maxPointer = reader.maxPointer;
        this.chunkSize = reader.chunkSize;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.numDocs = reader.numDocs;
        this.numChunks = reader.numChunks;
        this.numDirtyChunks = reader.numDirtyChunks;
        this.numDirtyDocs = reader.numDirtyDocs;
        this.prefetchedBlockIDCache = new long[16];
        Arrays.fill(this.prefetchedBlockIDCache, -1L);
        this.merging = merging;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene90CompressingStoredFieldsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context2, String formatName, CompressionMode compressionMode) throws IOException {
        this.compressionMode = compressionMode;
        String segment = si.name;
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.maxDoc();
        String fieldsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdt");
        ChecksumIndexInput metaIn = null;
        try {
            FieldsIndexReader fieldsIndexReader;
            this.fieldsStream = d.openInput(fieldsStreamFN, context2.withHints(FileTypeHint.DATA, DataAccessHint.RANDOM));
            this.version = CodecUtil.checkIndexHeader(this.fieldsStream, formatName, 1, 1, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength(formatName, segmentSuffix) == this.fieldsStream.getFilePointer());
            String metaStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdm");
            metaIn = d.openChecksumInput(metaStreamFN);
            CodecUtil.checkIndexHeader(metaIn, "Lucene90FieldsIndexMeta", 0, this.version, si.getId(), segmentSuffix);
            this.chunkSize = metaIn.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.prefetchedBlockIDCache = new long[16];
            Arrays.fill(this.prefetchedBlockIDCache, -1L);
            this.merging = false;
            this.state = new BlockState();
            CodecUtil.retrieveChecksum(this.fieldsStream);
            long maxPointer = -1L;
            FieldsIndexReader indexReader = null;
            indexReader = fieldsIndexReader = new FieldsIndexReader(d, si.name, segmentSuffix, "fdx", "Lucene90FieldsIndex", si.getId(), metaIn, context2);
            this.maxPointer = maxPointer = fieldsIndexReader.getMaxPointer();
            this.indexReader = indexReader;
            this.numChunks = metaIn.readVLong();
            this.numDirtyChunks = metaIn.readVLong();
            this.numDirtyDocs = metaIn.readVLong();
            if (this.numChunks < this.numDirtyChunks) {
                throw new CorruptIndexException("Cannot have more dirty chunks than chunks: numChunks=" + this.numChunks + ", numDirtyChunks=" + this.numDirtyChunks, metaIn);
            }
            if (this.numDirtyChunks == 0L != (this.numDirtyDocs == 0L)) {
                throw new CorruptIndexException("Cannot have dirty chunks without dirty docs or vice-versa: numDirtyChunks=" + this.numDirtyChunks + ", numDirtyDocs=" + this.numDirtyDocs, metaIn);
            }
            if (this.numDirtyDocs < this.numDirtyChunks) {
                throw new CorruptIndexException("Cannot have more dirty chunks than documents within dirty chunks: numDirtyChunks=" + this.numDirtyChunks + ", numDirtyDocs=" + this.numDirtyDocs, metaIn);
            }
            CodecUtil.checkFooter(metaIn, null);
            metaIn.close();
            return;
        }
        catch (Throwable t) {
            try {
                if (metaIn == null) throw t;
                CodecUtil.checkFooter(metaIn, t);
                throw new AssertionError((Object)"unreachable");
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this, metaIn);
                throw throwable;
            }
        }
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.indexReader, this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput in, StoredFieldVisitor visitor, FieldInfo info, int bits) throws IOException {
        switch (bits & Lucene90CompressingStoredFieldsWriter.TYPE_MASK) {
            case 1: {
                int length = in.readVInt();
                visitor.binaryField(info, new StoredFieldDataInput(in, length));
                break;
            }
            case 0: {
                visitor.stringField(info, in.readString());
                break;
            }
            case 2: {
                visitor.intField(info, in.readZInt());
                break;
            }
            case 3: {
                visitor.floatField(info, Lucene90CompressingStoredFieldsReader.readZFloat(in));
                break;
            }
            case 4: {
                visitor.longField(info, Lucene90CompressingStoredFieldsReader.readTLong(in));
                break;
            }
            case 5: {
                visitor.doubleField(info, Lucene90CompressingStoredFieldsReader.readZDouble(in));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    private static void skipField(DataInput in, int bits) throws IOException {
        switch (bits & Lucene90CompressingStoredFieldsWriter.TYPE_MASK) {
            case 0: 
            case 1: {
                int length = in.readVInt();
                in.skipBytes(length);
                break;
            }
            case 2: {
                in.readZInt();
                break;
            }
            case 3: {
                Lucene90CompressingStoredFieldsReader.readZFloat(in);
                break;
            }
            case 4: {
                Lucene90CompressingStoredFieldsReader.readTLong(in);
                break;
            }
            case 5: {
                Lucene90CompressingStoredFieldsReader.readZDouble(in);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    static float readZFloat(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        int bits = b << 24 | (in.readShort() & 0xFFFF) << 8 | in.readByte() & 0xFF;
        return Float.intBitsToFloat(bits);
    }

    static double readZDouble(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Double.longBitsToDouble(in.readLong());
        }
        if (b == 254) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        long bits = (long)b << 56 | ((long)in.readInt() & 0xFFFFFFFFL) << 24 | ((long)in.readShort() & 0xFFFFL) << 8 | (long)in.readByte() & 0xFFL;
        return Double.longBitsToDouble(bits);
    }

    static long readTLong(DataInput in) throws IOException {
        int header = in.readByte() & 0xFF;
        long bits = header & 0x1F;
        if ((header & 0x20) != 0) {
            bits |= in.readVLong() << 5;
        }
        long l = BitUtil.zigZagDecode(bits);
        switch (header & 0xC0) {
            case 64: {
                l *= 1000L;
                break;
            }
            case 128: {
                l *= 3600000L;
                break;
            }
            case 192: {
                l *= 86400000L;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l;
    }

    @Override
    public void prefetch(int docID) throws IOException {
        long blockID = this.indexReader.getBlockID(docID);
        for (long prefetchedBlockID : this.prefetchedBlockIDCache) {
            if (prefetchedBlockID != blockID) continue;
            return;
        }
        long blockStartPointer = this.indexReader.getBlockStartPointer(blockID);
        long blockLength = this.indexReader.getBlockLength(blockID);
        this.fieldsStream.prefetch(blockStartPointer, blockLength);
        this.prefetchedBlockIDCache[this.prefetchedBlockIDCacheIndex++ & 0xF] = blockID;
    }

    SerializedDocument serializedDocument(int docID) throws IOException {
        if (!this.state.contains(docID)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
            this.state.reset(docID);
        }
        assert (this.state.contains(docID));
        return this.state.document(docID);
    }

    boolean isLoaded(int docID) {
        if (!this.merging) {
            throw new IllegalStateException("isLoaded should only ever get called on a merge instance");
        }
        if (this.version != 1) {
            throw new IllegalStateException("isLoaded should only ever get called when the reader is on the current version");
        }
        return this.state.contains(docID);
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        SerializedDocument doc = this.serializedDocument(docID);
        block5: for (int fieldIDX = 0; fieldIDX < doc.numStoredFields; ++fieldIDX) {
            long infoAndBits = doc.in.readVLong();
            int fieldNumber = (int)(infoAndBits >>> Lucene90CompressingStoredFieldsWriter.TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            int bits = (int)(infoAndBits & (long)Lucene90CompressingStoredFieldsWriter.TYPE_MASK);
            assert (bits <= 5) : "bits=" + Integer.toHexString(bits);
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    Lucene90CompressingStoredFieldsReader.readField(doc.in, visitor, fieldInfo, bits);
                    continue block5;
                }
                case NO: {
                    if (fieldIDX == doc.numStoredFields - 1) {
                        return;
                    }
                    Lucene90CompressingStoredFieldsReader.skipField(doc.in, bits);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    @Override
    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new Lucene90CompressingStoredFieldsReader(this, false);
    }

    @Override
    public StoredFieldsReader getMergeInstance() {
        this.ensureOpen();
        return new Lucene90CompressingStoredFieldsReader(this, true);
    }

    int getVersion() {
        return this.version;
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    FieldsIndex getIndexReader() {
        return this.indexReader;
    }

    long getMaxPointer() {
        return this.maxPointer;
    }

    IndexInput getFieldsStream() {
        return this.fieldsStream;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    long getNumDirtyDocs() {
        if (this.version != 1) {
            throw new IllegalStateException("getNumDirtyDocs should only ever get called when the reader is on the current version");
        }
        assert (this.numDirtyDocs >= 0L);
        return this.numDirtyDocs;
    }

    long getNumDirtyChunks() {
        if (this.version != 1) {
            throw new IllegalStateException("getNumDirtyChunks should only ever get called when the reader is on the current version");
        }
        assert (this.numDirtyChunks >= 0L);
        return this.numDirtyChunks;
    }

    long getNumChunks() {
        if (this.version != 1) {
            throw new IllegalStateException("getNumChunks should only ever get called when the reader is on the current version");
        }
        assert (this.numChunks >= 0L);
        return this.numChunks;
    }

    int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.indexReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.fieldsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + String.valueOf(this.compressionMode) + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private long[] offsets = LongsRef.EMPTY_LONGS;
        private long[] numStoredFields = LongsRef.EMPTY_LONGS;
        private long startPointer;
        private final BytesRef spare;
        private final BytesRef bytes;

        BlockState() {
            if (Lucene90CompressingStoredFieldsReader.this.merging) {
                this.spare = new BytesRef();
                this.bytes = new BytesRef();
            } else {
                this.bytes = null;
                this.spare = null;
            }
        }

        boolean contains(int docID) {
            return docID >= this.docBase && docID < this.docBase + this.chunkDocs;
        }

        void reset(int docID) throws IOException {
            boolean success = false;
            try {
                this.doReset(docID);
                success = true;
            }
            finally {
                if (!success) {
                    this.chunkDocs = 0;
                }
            }
        }

        private void doReset(int docID) throws IOException {
            this.docBase = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int token = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = token >>> 2;
            if (!this.contains(docID) || this.docBase + this.chunkDocs > Lucene90CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + Lucene90CompressingStoredFieldsReader.this.numDocs, Lucene90CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (token & 1) != 0;
            this.offsets = ArrayUtil.growNoCopy(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.growNoCopy(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int i;
                StoredFieldsInts.readInts(Lucene90CompressingStoredFieldsReader.this.fieldsStream, this.chunkDocs, this.numStoredFields, 0);
                StoredFieldsInts.readInts(Lucene90CompressingStoredFieldsReader.this.fieldsStream, this.chunkDocs, this.offsets, 1);
                for (i = 0; i < this.chunkDocs; ++i) {
                    int n = i + 1;
                    this.offsets[n] = this.offsets[n] + this.offsets[i];
                }
                for (i = 0; i < this.chunkDocs; ++i) {
                    long storedFields;
                    long len = this.offsets[i + 1] - this.offsets[i];
                    if (len == 0L == ((storedFields = this.numStoredFields[i]) == 0L)) continue;
                    throw new CorruptIndexException("length=" + len + ", numStoredFields=" + storedFields, Lucene90CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = Lucene90CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (Lucene90CompressingStoredFieldsReader.this.merging) {
                int totalLength = Math.toIntExact(this.offsets[this.chunkDocs]);
                if (this.sliced) {
                    int toDecompress;
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (int decompressed = 0; decompressed < totalLength; decompressed += toDecompress) {
                        toDecompress = Math.min(totalLength - decompressed, Lucene90CompressingStoredFieldsReader.this.chunkSize);
                        Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, this.spare);
                        this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, totalLength, 0, totalLength, this.bytes);
                }
                if (this.bytes.length != totalLength) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + totalLength + ", got " + this.bytes.length, Lucene90CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int docID) throws IOException {
            DataInput documentInput;
            if (!this.contains(docID)) {
                throw new IllegalArgumentException();
            }
            int index = docID - this.docBase;
            int offset = Math.toIntExact(this.offsets[index]);
            final int length = Math.toIntExact(this.offsets[index + 1]) - offset;
            int totalLength = Math.toIntExact(this.offsets[this.chunkDocs]);
            int numStoredFields = Math.toIntExact(this.numStoredFields[index]);
            final BytesRef bytes = Lucene90CompressingStoredFieldsReader.this.merging ? this.bytes : new BytesRef();
            if (length == 0) {
                documentInput = new ByteArrayDataInput();
            } else if (Lucene90CompressingStoredFieldsReader.this.merging) {
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset + offset, length);
            } else if (this.sliced) {
                Lucene90CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, Lucene90CompressingStoredFieldsReader.this.chunkSize, offset, Math.min(length, Lucene90CompressingStoredFieldsReader.this.chunkSize - offset), bytes);
                documentInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= length);
                        if (this.decompressed == length) {
                            throw new EOFException();
                        }
                        int toDecompress = Math.min(length - this.decompressed, Lucene90CompressingStoredFieldsReader.this.chunkSize);
                        Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, bytes);
                        this.decompressed += toDecompress;
                    }

                    @Override
                    public byte readByte() throws IOException {
                        if (bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --bytes.length;
                        return bytes.bytes[bytes.offset++];
                    }

                    @Override
                    public void readBytes(byte[] b, int offset, int len) throws IOException {
                        while (len > bytes.length) {
                            System.arraycopy(bytes.bytes, bytes.offset, b, offset, bytes.length);
                            len -= bytes.length;
                            offset += bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(bytes.bytes, bytes.offset, b, offset, len);
                        bytes.offset += len;
                        bytes.length -= len;
                    }

                    @Override
                    public void skipBytes(long numBytes) throws IOException {
                        if (numBytes < 0L) {
                            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
                        }
                        while (numBytes > (long)bytes.length) {
                            numBytes -= (long)bytes.length;
                            this.fillBuffer();
                        }
                        bytes.offset = (int)((long)bytes.offset + numBytes);
                        bytes.length = (int)((long)bytes.length - numBytes);
                    }
                };
            } else {
                Lucene90CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, totalLength, offset, length, bytes);
                assert (bytes.length == length);
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset, bytes.length);
            }
            return new SerializedDocument(documentInput, length, numStoredFields);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput in, int length, int numStoredFields) {
            this.in = in;
            this.length = length;
            this.numStoredFields = numStoredFields;
        }
    }
}

