/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morph;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;

public abstract class DictionaryEntryWriter {
    protected ByteBuffer buffer;
    protected final List<String> posDict;

    protected DictionaryEntryWriter(int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.posDict = new ArrayList<String>();
    }

    protected abstract int putEntry(String[] var1);

    protected abstract void writePosDict(OutputStream var1, DataOutput var2) throws IOException;

    void writePosDict(Path path, String posDictCodecHeader, int dictCodecVersion) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput(bos);
            CodecUtil.writeHeader(out, posDictCodecHeader, dictCodecVersion);
            this.writePosDict(bos, out);
        }
    }

    void writeDictionary(Path path, String dictCodecHeader, int dictCodecVersion) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput(bos);
            CodecUtil.writeHeader(out, dictCodecHeader, dictCodecVersion);
            out.writeVInt(this.buffer.position());
            WritableByteChannel channel = Channels.newChannel(bos);
            this.buffer.flip();
            channel.write(this.buffer);
            assert ((long)this.buffer.remaining() == 0L);
        }
    }

    public int currentPosition() {
        return this.buffer.position();
    }
}

