/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.util;

public class BooleanCircularQueue {
    private static final int INITCAP = 64;
    private int head = 0;
    private int tail = 0;
    private int size = 0;
    private int minLen;
    private boolean[] data;

    public BooleanCircularQueue(int capacity) {
        this.data = new boolean[capacity];
        this.minLen = Math.max(64, capacity);
    }

    public BooleanCircularQueue() {
        this(64);
    }

    public void push(boolean value) {
        if (this.isFull()) {
            this.resize(this.data.length * 2);
        }
        this.data[this.tail] = value;
        this.tail = (this.tail + 1) % this.data.length;
        ++this.size;
    }

    public boolean pop() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Error: Queue is Empty!");
        }
        boolean ret = this.data[this.head];
        this.head = (this.head + 1) % this.data.length;
        --this.size;
        if (this.size < this.data.length / 4 && this.data.length / 2 >= this.minLen) {
            this.resize(this.data.length / 2);
        }
        return ret;
    }

    public boolean getHead() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Error: Queue is Empty!");
        }
        return this.data[this.head];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private boolean isFull() {
        return this.size == this.data.length;
    }

    private void resize(int newLength) {
        boolean[] newData = new boolean[newLength];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[(this.head + i) % this.data.length];
        }
        this.data = newData;
        this.head = 0;
        this.tail = this.size;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[(this.head + index) % this.data.length];
    }

    public int getSize() {
        return this.size;
    }
}

