/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.util.DriverUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class SqlStatValue {
    private static CompositeType THROWABLE_COMPOSITE_TYPE = null;
    private static final String[] THROWABLE_COMPOSITE_INDEX_NAMES = new String[]{"message", "class", "stackTrace"};
    private static final String[] THROWABLE_COMPOSITE_INDEX_DESCRIPTIONS = new String[]{"message", "class", "stackTrace"};
    private static final OpenType[] THROWABLE_COMPOSITE_INDEX_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    protected String id;
    protected String sql;
    private long sqlHash;
    protected String dataSource;
    protected String dataSourceId;
    protected long executeLastStartTime;
    protected long executeBatchSizeTotal;
    protected int executeBatchSizeMax;
    protected long executeSuccessCount;
    protected long executeSpanNanoTotal;
    protected long executeSpanNanoMax;
    protected int runningCount;
    protected int concurrentMax;
    protected long resultSetHoldTimeNano;
    protected long executeAndResultSetHoldTime;
    protected String name;
    protected String file;
    protected String dbType;
    protected long executeNanoSpanMaxOccurTime;
    protected long executeErrorCount;
    protected Throwable executeErrorLast;
    protected String executeErrorLastMessage;
    protected String executeErrorLastClass;
    protected String executeErrorLastStackTrace;
    protected long executeErrorLastTime;
    protected long updateCount;
    protected long updateCountMax;
    protected long fetchRowCount;
    protected long fetchRowCountMax;
    protected long inTransactionCount;
    protected String lastSlowParameters;
    protected long clobOpenCount;
    protected long blobOpenCount;
    protected long readStringLength;
    protected long readBytesLength;
    protected long inputStreamOpenCount;
    protected long readerOpenCount;
    protected long histogram_0_1;
    protected long histogram_1_10;
    protected int histogram_10_100;
    protected int histogram_100_1000;
    protected int histogram_1000_10000;
    protected int histogram_10000_100000;
    protected int histogram_100000_1000000;
    protected int histogram_1000000_more;
    protected long executeAndResultHoldTime_0_1;
    protected long executeAndResultHoldTime_1_10;
    protected int executeAndResultHoldTime_10_100;
    protected int executeAndResultHoldTime_100_1000;
    protected int executeAndResultHoldTime_1000_10000;
    protected int executeAndResultHoldTime_10000_100000;
    protected int executeAndResultHoldTime_100000_1000000;
    protected int executeAndResultHoldTime_1000000_more;
    protected long fetchRowCount_0_1;
    protected long fetchRowCount_1_10;
    protected long fetchRowCount_10_100;
    protected int fetchRowCount_100_1000;
    protected int fetchRowCount_1000_10000;
    protected int fetchRowCount_10000_more;
    protected long updateCount_0_1;
    protected long updateCount_1_10;
    protected long updateCount_10_100;
    protected int updateCount_100_1000;
    protected int updateCount_1000_10000;
    protected int updateCount_10000_more;

    public long[] getExecuteHistogram() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long[] getExecuteAndResultHoldHistogram() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long[] getFetchRowHistogram() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateHistogram() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long getExecuteCount() {
        return this.executeErrorCount + this.executeSuccessCount;
    }

    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax / 1000000L;
    }

    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal / 1000000L;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    public long getSqlHash() {
        return this.sqlHash;
    }

    public void setSqlHash(long l2) {
        this.sqlHash = l2;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String string) {
        this.dataSourceId = string;
    }

    public long getExecuteLastStartTimeMillis() {
        return this.executeLastStartTime;
    }

    public Date getExecuteLastStartTime() {
        if (this.executeLastStartTime <= 0L) {
            return null;
        }
        return new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long l2) {
        this.executeLastStartTime = l2;
    }

    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal;
    }

    public void setExecuteBatchSizeTotal(long l2) {
        this.executeBatchSizeTotal = l2;
    }

    public int getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax;
    }

    public void setExecuteBatchSizeMax(int n2) {
        this.executeBatchSizeMax = n2;
    }

    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public void setExecuteSuccessCount(long l2) {
        this.executeSuccessCount = l2;
    }

    public long getExecuteSpanNanoTotal() {
        return this.executeSpanNanoTotal;
    }

    public void setExecuteSpanNanoTotal(long l2) {
        this.executeSpanNanoTotal = l2;
    }

    public long getExecuteSpanNanoMax() {
        return this.executeSpanNanoMax;
    }

    public void setExecuteSpanNanoMax(long l2) {
        this.executeSpanNanoMax = l2;
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(int n2) {
        this.runningCount = n2;
    }

    public int getConcurrentMax() {
        return this.concurrentMax;
    }

    public void setConcurrentMax(int n2) {
        this.concurrentMax = n2;
    }

    public long getResultSetHoldTimeNano() {
        return this.resultSetHoldTimeNano;
    }

    public void setResultSetHoldTimeNano(long l2) {
        this.resultSetHoldTimeNano = l2;
    }

    public long getExecuteAndResultSetHoldTimeNano() {
        return this.executeAndResultSetHoldTime;
    }

    public void setExecuteAndResultSetHoldTime(long l2) {
        this.executeAndResultSetHoldTime = l2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String string) {
        this.dbType = string;
    }

    public long getExecuteNanoSpanMaxOccurTimeMillis() {
        return this.executeNanoSpanMaxOccurTime;
    }

    public Date getExecuteNanoSpanMaxOccurTime() {
        if (this.executeNanoSpanMaxOccurTime <= 0L) {
            return null;
        }
        return new Date(this.executeNanoSpanMaxOccurTime);
    }

    public Date getExecuteErrorLastTime() {
        if (this.executeErrorLastTime <= 0L) {
            return null;
        }
        return new Date(this.executeErrorLastTime);
    }

    public void setExecuteNanoSpanMaxOccurTime(long l2) {
        this.executeNanoSpanMaxOccurTime = l2;
    }

    public long getExecuteErrorCount() {
        return this.executeErrorCount;
    }

    public void setExecuteErrorCount(long l2) {
        this.executeErrorCount = l2;
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void setExecuteErrorLast(Throwable throwable) {
        this.executeErrorLast = throwable;
        if (throwable != null) {
            this.executeErrorLastMessage = throwable.getMessage();
            this.executeErrorLastClass = throwable.getClass().getName();
            this.executeErrorLastStackTrace = SqlStatValue.toString(throwable.getStackTrace());
        }
    }

    public String getExecuteErrorLastMessage() {
        return this.executeErrorLastMessage;
    }

    public String getExecuteErrorLastClass() {
        return this.executeErrorLastClass;
    }

    public String getExecuteErrorLastStackTrace() {
        return this.executeErrorLastStackTrace;
    }

    public long getExecuteErrorLastTimeMillis() {
        return this.executeErrorLastTime;
    }

    public void setExecuteErrorLastTime(long l2) {
        this.executeErrorLastTime = l2;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(long l2) {
        this.updateCount = l2;
    }

    public long getUpdateCountMax() {
        return this.updateCountMax;
    }

    public void setUpdateCountMax(long l2) {
        this.updateCountMax = l2;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public void setFetchRowCount(long l2) {
        this.fetchRowCount = l2;
    }

    public long getFetchRowCountMax() {
        return this.fetchRowCountMax;
    }

    public void setFetchRowCountMax(long l2) {
        this.fetchRowCountMax = l2;
    }

    public long getInTransactionCount() {
        return this.inTransactionCount;
    }

    public void setInTransactionCount(long l2) {
        this.inTransactionCount = l2;
    }

    public String getLastSlowParameters() {
        return this.lastSlowParameters;
    }

    public void setLastSlowParameters(String string) {
        this.lastSlowParameters = string;
    }

    public long getClobOpenCount() {
        return this.clobOpenCount;
    }

    public void setClobOpenCount(long l2) {
        this.clobOpenCount = l2;
    }

    public long getBlobOpenCount() {
        return this.blobOpenCount;
    }

    public void setBlobOpenCount(long l2) {
        this.blobOpenCount = l2;
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void setReadStringLength(long l2) {
        this.readStringLength = l2;
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void setReadBytesLength(long l2) {
        this.readBytesLength = l2;
    }

    public long getInputStreamOpenCount() {
        return this.inputStreamOpenCount;
    }

    public void setInputStreamOpenCount(long l2) {
        this.inputStreamOpenCount = l2;
    }

    public long getReaderOpenCount() {
        return this.readerOpenCount;
    }

    public void setReaderOpenCount(long l2) {
        this.readerOpenCount = l2;
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long[] getFetchRowCountHistogramValues() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateCountHistogramValues() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long[] getExecuteAndResultHoldTimeHistogramValues() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long getResultSetHoldTimeMilis() {
        return this.getResultSetHoldTimeNano() / 1000000L;
    }

    public long getExecuteAndResultSetHoldTimeMilis() {
        return this.getExecuteAndResultSetHoldTimeNano() / 1000000L;
    }

    public Map getData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ID", this.id);
        hashMap.put("DataSource", this.dataSource);
        hashMap.put("DataSourceId", this.dataSourceId);
        hashMap.put("SQL", this.sql);
        hashMap.put("ExecuteCount", this.getExecuteCount());
        hashMap.put("ErrorCount", this.getExecuteErrorCount());
        hashMap.put("TotalTime", this.getExecuteMillisTotal());
        hashMap.put("LastTime", this.getExecuteLastStartTime());
        hashMap.put("MaxTimespan", this.getExecuteMillisMax());
        hashMap.put("LastError", SqlStatValue.getErrorCompositeData(this.getExecuteErrorLast()));
        hashMap.put("EffectedRowCount", this.getUpdateCount());
        hashMap.put("FetchRowCount", this.getFetchRowCount());
        hashMap.put("MaxTimespanOccurTime", this.getExecuteNanoSpanMaxOccurTime());
        hashMap.put("BatchSizeMax", Long.valueOf(this.getExecuteBatchSizeMax()));
        hashMap.put("BatchSizeTotal", this.getExecuteBatchSizeTotal());
        hashMap.put("ConcurrentMax", Long.valueOf(this.getConcurrentMax()));
        hashMap.put("RunningCount", Long.valueOf(this.getRunningCount()));
        hashMap.put("Name", this.getName());
        hashMap.put("File", this.getFile());
        if (this.executeErrorLastMessage != null) {
            hashMap.put("LastErrorMessage", this.executeErrorLastMessage);
            hashMap.put("LastErrorClass", this.executeErrorLastClass);
            hashMap.put("LastErrorStackTrace", this.executeErrorLastStackTrace);
            hashMap.put("LastErrorTime", new Date(this.executeErrorLastTime));
        } else {
            hashMap.put("LastErrorMessage", null);
            hashMap.put("LastErrorClass", null);
            hashMap.put("LastErrorStackTrace", null);
            hashMap.put("LastErrorTime", null);
        }
        hashMap.put("DbType", this.dbType);
        hashMap.put("URL", null);
        hashMap.put("InTransactionCount", this.getInTransactionCount());
        hashMap.put("Histogram", this.getHistogramValues());
        hashMap.put("LastSlowParameters", this.lastSlowParameters);
        hashMap.put("ResultSetHoldTime", this.getResultSetHoldTimeMilis());
        hashMap.put("ExecuteAndResultSetHoldTime", this.getExecuteAndResultSetHoldTimeMilis());
        hashMap.put("FetchRowCountHistogram", this.getFetchRowCountHistogramValues());
        hashMap.put("EffectedRowCountHistogram", this.getUpdateCountHistogramValues());
        hashMap.put("ExecuteAndResultHoldTimeHistogram", this.getExecuteAndResultHoldTimeHistogramValues());
        hashMap.put("EffectedRowCountMax", this.getUpdateCountMax());
        hashMap.put("FetchRowCountMax", this.getFetchRowCountMax());
        hashMap.put("ClobOpenCount", this.getClobOpenCount());
        hashMap.put("BlobOpenCount", this.getBlobOpenCount());
        hashMap.put("ReadStringLength", this.getReadStringLength());
        hashMap.put("ReadBytesLength", this.getReadBytesLength());
        hashMap.put("InputStreamOpenCount", this.getInputStreamOpenCount());
        hashMap.put("ReaderOpenCount", this.getReaderOpenCount());
        hashMap.put("HASH", this.getSqlHash());
        hashMap.put("ExecuteHoldTimeHistogram", this.getExecuteHistogram());
        return hashMap;
    }

    public long getHistogram_0_1() {
        return this.histogram_0_1;
    }

    public void setHistogram_0_1(long l2) {
        this.histogram_0_1 = l2;
    }

    public long getHistogram_1_10() {
        return this.histogram_1_10;
    }

    public void setHistogram_1_10(long l2) {
        this.histogram_1_10 = l2;
    }

    public int getHistogram_10_100() {
        return this.histogram_10_100;
    }

    public void setHistogram_10_100(int n2) {
        this.histogram_10_100 = n2;
    }

    public int getHistogram_100_1000() {
        return this.histogram_100_1000;
    }

    public void setHistogram_100_1000(int n2) {
        this.histogram_100_1000 = n2;
    }

    public int getHistogram_1000_10000() {
        return this.histogram_1000_10000;
    }

    public void setHistogram_1000_10000(int n2) {
        this.histogram_1000_10000 = n2;
    }

    public int getHistogram_10000_100000() {
        return this.histogram_10000_100000;
    }

    public void setHistogram_10000_100000(int n2) {
        this.histogram_10000_100000 = n2;
    }

    public int getHistogram_100000_1000000() {
        return this.histogram_100000_1000000;
    }

    public void setHistogram_100000_1000000(int n2) {
        this.histogram_100000_1000000 = n2;
    }

    public int getHistogram_1000000_more() {
        return this.histogram_1000000_more;
    }

    public void setHistogram_1000000_more(int n2) {
        this.histogram_1000000_more = n2;
    }

    public static CompositeType getThrowableCompositeType() {
        if (THROWABLE_COMPOSITE_TYPE == null) {
            THROWABLE_COMPOSITE_TYPE = new CompositeType("Throwable", "Throwable", THROWABLE_COMPOSITE_INDEX_NAMES, THROWABLE_COMPOSITE_INDEX_DESCRIPTIONS, THROWABLE_COMPOSITE_INDEX_TYPES);
        }
        return THROWABLE_COMPOSITE_TYPE;
    }

    public static String toString(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        int n2 = stackTraceElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[n3];
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static CompositeData getErrorCompositeData(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("class", throwable.getClass().getName());
        hashMap.put("message", throwable.getMessage());
        hashMap.put("stackTrace", DriverUtil.getStackTrace(throwable));
        return new CompositeDataSupport(SqlStatValue.getThrowableCompositeType(), hashMap);
    }
}

