/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.dto.TencentCloudExternAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TencentExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(TencentExternAlertService.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        TencentCloudExternAlert report = (TencentCloudExternAlert)JsonUtil.fromJson((String)content, TencentCloudExternAlert.class);
        if (report == null) {
            log.warn("parse extern alert content failed! content: {}", (Object)content);
            return;
        }
        SingleAlert alert = new TencentCloudAlertConverter().convert(report);
        this.alarmCommonReduce.reduceAndSendAlarm(alert);
    }

    @Override
    public String supportSource() {
        return "tencent";
    }

    public static class TencentCloudAlertConverter {
        private final String metricTemplate = "Tencent Cloud Metric Alert: {metricShowName} {calcType} {calcValue}{calcUnit}, Current: {currentValue}{unit}";
        private final String eventTemplate = "Tencent Cloud Event Alert: {productShowName} - {eventShowName}";

        public SingleAlert convert(TencentCloudExternAlert tencentAlert) {
            SingleAlert.SingleAlertBuilder builder = SingleAlert.builder().status(this.convertStatus(tencentAlert.getAlarmStatus())).startAt(this.parseTime(tencentAlert.getFirstOccurTime())).activeAt(this.parseTime(tencentAlert.getFirstOccurTime())).triggerTimes(Integer.valueOf(1));
            if ("0".equals(tencentAlert.getAlarmStatus())) {
                builder.endAt(this.parseTime(tencentAlert.getRecoverTime()));
            }
            HashMap<String, String> labels = new HashMap<String, String>();
            this.buildLabels(labels, tencentAlert);
            HashMap<String, String> annotations = new HashMap<String, String>();
            this.buildAnnotations(annotations, tencentAlert);
            String content = this.generateContent(tencentAlert);
            return builder.labels(labels).annotations(annotations).content(content).build();
        }

        private void buildLabels(Map<String, String> labels, TencentCloudExternAlert alert) {
            labels.put("__source__", "tencent_cloud");
            labels.put("alert_type", alert.getAlarmType());
            if ("metric".equals(alert.getAlarmType())) {
                labels.put("metric_name", alert.getAlarmPolicyInfo().getConditions().getMetricName());
                labels.put("namespace", alert.getAlarmObjInfo().getNamespace());
            } else {
                labels.put("event_name", alert.getAlarmPolicyInfo().getConditions().getEventName());
                labels.put("product_name", alert.getAlarmPolicyInfo().getConditions().getProductName());
            }
        }

        private void buildAnnotations(Map<String, String> annotations, TencentCloudExternAlert alert) {
            TencentCloudExternAlert.AlarmPolicyInfo alarmPolicyInfo = alert.getAlarmPolicyInfo();
            TencentCloudExternAlert.AlarmObjInfo alarmObjInfo = alert.getAlarmObjInfo();
            TencentCloudExternAlert.Dimensions dimensions = alert.getAlarmObjInfo().getDimensions();
            this.putIfNotNull(annotations, "policy_id", alarmPolicyInfo.getPolicyId());
            this.putIfNotNull(annotations, "policy_type", alarmPolicyInfo.getPolicyType());
            this.putIfNotNull(annotations, "policy_name", alarmPolicyInfo.getPolicyName());
            this.putIfNotNull(annotations, "policy_type_cname", alarmPolicyInfo.getPolicyTypeCname());
            this.putIfNotNull(annotations, "namespace", alarmObjInfo.getNamespace());
            this.putIfNotNull(annotations, "region", alarmObjInfo.getRegion());
            this.putIfNotNull(annotations, "app_id", alarmObjInfo.getAppId());
            this.putIfNotNull(annotations, "uin", alarmObjInfo.getUin());
            this.putIfNotNull(annotations, "instance_id", dimensions.getUnInstanceId());
            this.putIfNotNull(annotations, "obj_id", dimensions.getObjId());
        }

        private String generateContent(TencentCloudExternAlert alert) {
            if ("metric".equals(alert.getAlarmType())) {
                return this.generateMetricContent(alert);
            }
            return this.generateEventContent(alert);
        }

        private String generateMetricContent(TencentCloudExternAlert alert) {
            TencentCloudExternAlert.Conditions conditions = alert.getAlarmPolicyInfo().getConditions();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("metricShowName", conditions.getMetricShowName());
            if (StringUtils.isNotEmpty((CharSequence)conditions.getCalcType()) && StringUtils.isNotEmpty((CharSequence)conditions.getCalcValue())) {
                params.put("calcType", conditions.getCalcType());
                params.put("calcValue", conditions.getCalcValue());
                params.put("calcUnit", Objects.toString(conditions.getCalcUnit(), ""));
            } else {
                params.put("calcType", "");
                params.put("calcValue", "N/A");
                params.put("calcUnit", "");
            }
            if (StringUtils.isNotEmpty((CharSequence)conditions.getCurrentValue())) {
                params.put("currentValue", conditions.getCurrentValue());
                params.put("unit", Objects.toString(conditions.getUnit(), ""));
            } else {
                params.put("currentValue", "N/A");
                params.put("unit", "");
            }
            return this.replacePlaceholders("Tencent Cloud Metric Alert: {metricShowName} {calcType} {calcValue}{calcUnit}, Current: {currentValue}{unit}", params);
        }

        private String generateEventContent(TencentCloudExternAlert alert) {
            TencentCloudExternAlert.Conditions conditions = alert.getAlarmPolicyInfo().getConditions();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("productShowName", conditions.getProductShowName());
            params.put("eventShowName", conditions.getEventShowName());
            return this.replacePlaceholders("Tencent Cloud Event Alert: {productShowName} - {eventShowName}", params);
        }

        private String replacePlaceholders(String template, Map<String, String> params) {
            String result = template;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                result = result.replace("{" + entry.getKey() + "}", Objects.toString(entry.getValue(), "NULL"));
            }
            return result;
        }

        private String convertStatus(String alarmStatus) {
            return "1".equals(alarmStatus) ? "firing" : "resolved";
        }

        private Long parseTime(String timeStr) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.parse(timeStr).getTime();
            }
            catch (ParseException e) {
                log.error("Failed to parse time: {}", (Object)timeStr);
                throw new IllegalArgumentException("Failed to parse time: " + timeStr, e);
            }
        }

        private void putIfNotNull(Map<String, String> map, String key, String value) {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                map.put(key, value);
            }
        }
    }
}

