/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import java.util.HashMap;
import java.util.ResourceBundle;
import org.apache.hertzbeat.alert.calculate.AlarmCacheManager;
import org.apache.hertzbeat.alert.dao.AlertCollectorDao;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.util.AlertUtil;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.support.event.SystemConfigChangeEvent;
import org.apache.hertzbeat.common.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class CollectorAlertHandler {
    private static final Logger log = LoggerFactory.getLogger(CollectorAlertHandler.class);
    private static final String KEY_COLLECTOR_NAME = "collectorName";
    private static final String KEY_COLLECTOR_VERSION = "collectorVersion";
    private static final String KEY_COLLECTOR_HOST = "collectorHost";
    private final AlertCollectorDao alertCollectorDao;
    private final AlarmCommonReduce alarmCommonReduce;
    private final AlarmCacheManager alarmCacheManager;
    private ResourceBundle bundle;

    public CollectorAlertHandler(AlarmCommonReduce alarmCommonReduce, AlertCollectorDao alertCollectorDao, AlarmCacheManager alarmCacheManager) {
        this.alarmCommonReduce = alarmCommonReduce;
        this.alertCollectorDao = alertCollectorDao;
        this.alarmCacheManager = alarmCacheManager;
        this.bundle = ResourceBundleUtil.getBundle((String)"alerter");
    }

    public void online(String identity) {
        Collector collector = this.alertCollectorDao.findCollectorByName(identity);
        if (collector == null) {
            return;
        }
        HashMap<String, String> fingerPrints = new HashMap<String, String>(8);
        fingerPrints.put(KEY_COLLECTOR_NAME, collector.getName());
        fingerPrints.put(KEY_COLLECTOR_VERSION, collector.getVersion());
        fingerPrints.put(KEY_COLLECTOR_HOST, collector.getIp());
        String fingerprint = AlertUtil.calculateFingerprint(fingerPrints);
        SingleAlert firingAlert = this.alarmCacheManager.getFiring(fingerprint);
        if (firingAlert != null) {
            firingAlert.setTriggerTimes(Integer.valueOf(1));
            firingAlert.setEndAt(Long.valueOf(System.currentTimeMillis()));
            firingAlert.setStatus("resolved");
            this.alarmCommonReduce.reduceAndSendAlarm(firingAlert.clone());
        }
    }

    public void offline(String identity) {
        Collector collector = this.alertCollectorDao.findCollectorByName(identity);
        if (collector == null) {
            return;
        }
        long currentTimeMill = System.currentTimeMillis();
        HashMap<String, String> fingerPrints = new HashMap<String, String>(8);
        fingerPrints.put(KEY_COLLECTOR_NAME, collector.getName());
        fingerPrints.put(KEY_COLLECTOR_VERSION, collector.getVersion());
        fingerPrints.put(KEY_COLLECTOR_HOST, collector.getIp());
        String fingerprint = AlertUtil.calculateFingerprint(fingerPrints);
        SingleAlert existingAlert = this.alarmCacheManager.getFiring(fingerprint);
        if (existingAlert == null) {
            SingleAlert newAlert = SingleAlert.builder().labels(fingerPrints).annotations(fingerPrints).content(this.bundle.getString("alerter.availability.collector.offline")).status("firing").triggerTimes(Integer.valueOf(1)).startAt(Long.valueOf(currentTimeMill)).activeAt(Long.valueOf(currentTimeMill)).build();
            this.alarmCacheManager.putFiring(fingerprint, newAlert);
            this.alarmCommonReduce.reduceAndSendAlarm(newAlert.clone());
        }
    }

    @EventListener(value={SystemConfigChangeEvent.class})
    public void onSystemConfigChangeEvent(SystemConfigChangeEvent event) {
        log.info("calculate alarm receive system config change event: {}.", event.getSource());
        this.bundle = ResourceBundleUtil.getBundle((String)"alerter");
    }
}

