/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogLimitsFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordLimitsAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordProcessorFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LoggerProviderAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LoggerProviderModel;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import java.io.Closeable;
import java.util.List;

final class LoggerProviderFactory
implements Factory<LoggerProviderAndAttributeLimits, SdkLoggerProviderBuilder> {
    private static final LoggerProviderFactory INSTANCE = new LoggerProviderFactory();

    private LoggerProviderFactory() {
    }

    static LoggerProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkLoggerProviderBuilder create(LoggerProviderAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        SdkLoggerProviderBuilder builder = SdkLoggerProvider.builder();
        LoggerProviderModel loggerProviderModel = model.getLoggerProvider();
        if (loggerProviderModel == null) {
            return builder;
        }
        LogLimits logLimits = LogLimitsFactory.getInstance().create(LogRecordLimitsAndAttributeLimits.create(model.getAttributeLimits(), loggerProviderModel.getLimits()), spiHelper, closeables);
        builder.setLogLimits(() -> logLimits);
        List<LogRecordProcessorModel> processors = loggerProviderModel.getProcessors();
        if (processors != null) {
            processors.forEach(processor -> builder.addLogRecordProcessor(LogRecordProcessorFactory.getInstance().create((LogRecordProcessorModel)processor, spiHelper, closeables)));
        }
        return builder;
    }
}

