/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseSimpleResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.config.ClickHouseConfigChangeListener;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseResultSet;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.jdbc.parser.StatementType;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClickHouseStatementImpl
extends JdbcWrapper
implements ClickHouseConfigChangeListener<ClickHouseRequest<?>>,
ClickHouseStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStatementImpl.class);
    private final ClickHouseConnection connection;
    private final ClickHouseRequest<?> request;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final List<ClickHouseSqlStatement> batchStmts;
    private boolean closed;
    private boolean closeOnCompletion;
    private String cursorName;
    private boolean escapeScan;
    private int fetchSize;
    private int maxFieldSize;
    private long maxRows;
    private OutputStream mirroredOutput;
    private int nullAsDefault;
    private boolean poolable;
    private volatile String queryId;
    private int queryTimeout;
    private ClickHouseResultSet currentResult;
    private long currentUpdateCount;
    private ClickHouseDataProcessor processor;
    protected final JdbcTypeMapping mapper;
    protected ClickHouseSqlStatement[] parsedStmts;

    private ClickHouseResponse getLastResponse(Map<ClickHouseOption, Serializable> options, List<ClickHouseExternalTable> tables, Map<String, String> settings) throws SQLException {
        boolean autoTx;
        boolean bl = autoTx = this.connection.getAutoCommit() && this.connection.isTransactionSupported();
        if (this.parsedStmts.length > 1 && !this.request.getSessionId().isPresent()) {
            this.request.session(this.request.getManager().createSessionId());
        }
        ClickHouseResponse response = null;
        int len = this.parsedStmts.length;
        for (int i = 0; i < len; ++i) {
            ClickHouseSqlStatement stmt = this.parsedStmts[i];
            response = this.processSqlStatement(stmt);
            if (response != null) {
                this.updateResult(stmt, response);
                continue;
            }
            if (stmt.hasFormat()) {
                this.request.format(ClickHouseFormat.valueOf(stmt.getFormat()));
            }
            this.queryId = this.connection.newQueryId();
            this.request.query(stmt.getSQL(), this.queryId);
            try {
                response = autoTx ? this.request.executeWithinTransaction(this.connection.isImplicitTransactionSupported()) : ((ClickHouseRequest)this.request.transaction(this.connection.getTransaction())).executeAndWait();
                continue;
            }
            catch (Exception e) {
                throw SqlExceptionUtils.handle(e, new Throwable[0]);
            }
            finally {
                if (response != null) {
                    if (i + 1 < len) {
                        response.close();
                        response = null;
                    } else {
                        this.updateResult(stmt, response);
                    }
                }
            }
        }
        return response;
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SqlExceptionUtils.clientError("Cannot operate on a closed statement");
        }
    }

    protected ClickHouseFile getFile(ClickHouseFile f, ClickHouseSqlStatement stmt) {
        ClickHouseFormat format;
        ClickHouseFormat clickHouseFormat = stmt.hasFormat() ? ClickHouseFormat.valueOf(stmt.getFormat()) : (format = f.isRecognized() ? f.getFormat() : (ClickHouseFormat)((Object)ClickHouseDefaults.FORMAT.getDefaultValue()));
        ClickHouseCompression compressAlgorithm = stmt.hasCompressAlgorithm() ? ClickHouseCompression.fromEncoding(ClickHouseUtils.unescape(stmt.getCompressAlgorithm())) : (f.isRecognized() ? f.getCompressionAlgorithm() : ClickHouseCompression.NONE);
        int compressLevel = stmt.hasCompressLevel() ? Integer.parseInt(stmt.getCompressLevel()) : -1;
        return ClickHouseFile.of(f.getFile(), compressAlgorithm, compressLevel, format);
    }

    protected ClickHouseResponse processSqlStatement(ClickHouseSqlStatement stmt) throws SQLException {
        if (stmt.getStatementType() == StatementType.USE) {
            String dbName = this.connection.getCurrentDatabase();
            String newDb = stmt.getDatabaseOrDefault(dbName);
            boolean hasSession = this.request.getSessionId().isPresent();
            if (!hasSession) {
                this.request.session(this.request.getManager().createSessionId());
            }
            try (ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)this.request.use(newDb)).query(stmt.getSQL())).executeAndWait();){
                dbName = newDb;
                this.connection.setCurrentDatabase(dbName, false);
            }
            catch (ClickHouseException e) {
                throw SqlExceptionUtils.handle(e);
            }
            finally {
                if (!dbName.equals(newDb)) {
                    this.request.use(dbName);
                }
                if (!hasSession) {
                    this.request.clearSession();
                }
            }
            return ClickHouseResponse.EMPTY;
        }
        if (stmt.isTCL()) {
            if (stmt.containsKeyword("BEGIN")) {
                this.connection.begin();
            } else if (stmt.containsKeyword("COMMIT")) {
                this.connection.commit();
            } else if (stmt.containsKeyword("ROLLBACK")) {
                this.connection.rollback();
            } else {
                throw new SQLFeatureNotSupportedException("Unsupported TCL: " + stmt.getSQL());
            }
            return ClickHouseResponse.EMPTY;
        }
        if (this.connection.getJdbcConfig().useLocalFile() && stmt.hasFile()) {
            boolean suffix;
            String file = ClickHouseUtils.unescape(stmt.getFile());
            boolean bl = suffix = file.lastIndexOf(33) == file.length() - 1;
            if (suffix) {
                file = file.substring(0, file.length() - 1);
            }
            if (stmt.getStatementType() == StatementType.SELECT) {
                ClickHouseFile f = ClickHouseFile.of(ClickHouseUtils.getFile(file));
                if (!suffix && f.getFile().exists()) {
                    throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Output file [%s] already exists!", f.getFile()));
                }
                f = this.getFile(f, stmt);
                ClickHouseResponseSummary summary = new ClickHouseResponseSummary(null, null);
                try (ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)this.request.query(stmt.getSQL())).output(f)).executeAndWait();){
                    summary.add(response.getSummary());
                }
                catch (ClickHouseException e) {
                    throw SqlExceptionUtils.handle(e);
                }
                return ClickHouseSimpleResponse.of(this.getConfig(), Arrays.asList(ClickHouseColumn.of("file", ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of("format", ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of("compression", ClickHouseDataType.String, false, new ClickHouseColumn[0]), ClickHouseColumn.of("level", ClickHouseDataType.Int32, false, new ClickHouseColumn[0]), ClickHouseColumn.of("bytes", ClickHouseDataType.UInt64, false, new ClickHouseColumn[0])), new Object[][]{{file, f.getFormat().name(), f.hasCompression() ? f.getCompressionAlgorithm().encoding() : "none", f.getCompressionLevel(), f.getFile().length()}}, summary);
            }
            if (stmt.getStatementType() == StatementType.INSERT) {
                ClickHouseRequest.Mutation m = (ClickHouseRequest.Mutation)this.request.write().query(stmt.getSQL());
                ClickHouseResponseSummary summary = new ClickHouseResponseSummary(null, null);
                try {
                    for (Path p : ClickHouseUtils.findFiles(file, new String[0])) {
                        ClickHouseFile f = ClickHouseFile.of(p.toFile());
                        if (!f.getFile().exists()) {
                            if (suffix) {
                                throw SqlExceptionUtils.clientError(ClickHouseUtils.format("File [%s] does not exist!", f.getFile()));
                            }
                            log.warn((Object)"Skip [%s] as it does not exist - perhaps it was just deleted somehow?", f);
                            continue;
                        }
                        try {
                            ClickHouseResponse response = m.data(this.getFile(f, stmt)).executeAndWait();
                            try {
                                summary.add(response.getSummary());
                                log.debug((Object)"Loaded %d rows from [%s]", response.getSummary().getWrittenRows(), f.getFile().getAbsolutePath());
                            }
                            finally {
                                if (response == null) continue;
                                response.close();
                            }
                        }
                        catch (ClickHouseException e) {
                            throw SqlExceptionUtils.handle(e);
                        }
                    }
                    if (suffix && summary.getUpdateCount() == 0) {
                        throw SqlExceptionUtils.clientError("No file imported: " + file);
                    }
                    summary.seal();
                }
                catch (IOException e) {
                    throw SqlExceptionUtils.handle(e, new Throwable[0]);
                }
                return ClickHouseSimpleResponse.of(null, null, new Object[0][], summary);
            }
        }
        return null;
    }

    protected ClickHouseResponse executeStatement(String stmt, Map<ClickHouseOption, Serializable> options, List<ClickHouseExternalTable> tables, Map<String, String> settings) throws SQLException {
        boolean autoTx = this.connection.getAutoCommit() && this.connection.isTransactionSupported();
        try {
            if (options != null) {
                this.request.options(options);
            }
            if (settings != null && !settings.isEmpty()) {
                if (!this.request.getSessionId().isPresent()) {
                    this.request.session(this.request.getManager().createSessionId());
                }
                for (Map.Entry<String, String> e : settings.entrySet()) {
                    this.request.set(e.getKey(), e.getValue());
                }
            }
            if (tables != null && !tables.isEmpty()) {
                ArrayList<ClickHouseExternalTable> list = new ArrayList<ClickHouseExternalTable>(tables.size());
                char quote = '`';
                for (ClickHouseExternalTable t : tables) {
                    if (t.isTempTable()) {
                        if (!this.request.getSessionId().isPresent()) {
                            this.request.session(this.request.getManager().createSessionId());
                        }
                        String tableName = quote + ClickHouseUtils.escape(t.getName(), quote) + quote;
                        ClickHouseResponse dropResp = ((ClickHouseRequest)this.request.query("DROP TEMPORARY TABLE IF EXISTS ".concat(tableName))).executeAndWait();
                        try {
                            ClickHouseResponse createResp = ((ClickHouseRequest)this.request.query("CREATE TEMPORARY TABLE " + tableName + "(" + t.getStructure() + ")")).executeAndWait();
                            try {
                                ClickHouseResponse writeResp = ((ClickHouseRequest.Mutation)this.request.write().table(tableName)).data(t.getContent()).executeAndWait();
                                if (writeResp == null) continue;
                                writeResp.close();
                                continue;
                            }
                            finally {
                                if (createResp != null) {
                                    createResp.close();
                                }
                                continue;
                            }
                        }
                        finally {
                            if (dropResp == null) continue;
                            dropResp.close();
                            continue;
                        }
                    }
                    list.add(t);
                }
                this.request.external(list);
            }
            this.queryId = this.connection.newQueryId();
            this.request.query(stmt, this.queryId);
            return autoTx ? this.request.executeWithinTransaction(this.connection.isImplicitTransactionSupported()) : ((ClickHouseRequest)this.request.transaction(this.connection.getTransaction())).executeAndWait();
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
    }

    protected ClickHouseResponse executeStatement(ClickHouseSqlStatement stmt, Map<ClickHouseOption, Serializable> options, List<ClickHouseExternalTable> tables, Map<String, String> settings) throws SQLException {
        ClickHouseResponse resp = this.processSqlStatement(stmt);
        if (resp != null) {
            return resp;
        }
        return this.executeStatement(stmt.getSQL(), options, tables, settings);
    }

    protected int executeInsert(String sql, InputStream input) throws SQLException {
        boolean autoTx = this.connection.getAutoCommit() && this.connection.isTransactionSupported();
        this.queryId = this.connection.newQueryId();
        ClickHouseRequest.Mutation req = ((ClickHouseRequest.Mutation)this.request.write().query(sql, this.queryId)).data(input);
        try (ClickHouseResponse resp = autoTx ? req.executeWithinTransaction(this.connection.isImplicitTransactionSupported()) : ((ClickHouseRequest.Mutation)req.transaction(this.connection.getTransaction())).executeAndWait();){
            ResultSet rs = this.updateResult(new ClickHouseSqlStatement(sql, StatementType.INSERT), resp);
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
        return (int)this.currentUpdateCount;
    }

    protected ClickHouseDataProcessor getDataProcessor(ClickHouseInputStream input, Map<String, Serializable> settings, ClickHouseColumn[] columns) throws SQLException {
        if (this.processor == null) {
            try {
                this.processor = ClickHouseDataStreamFactory.getInstance().getProcessor(this.getConfig(), input, null, settings, Arrays.asList(columns));
            }
            catch (IOException e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        return this.processor;
    }

    protected ClickHouseDataProcessor getDataProcessor(ClickHouseOutputStream output, Map<String, Serializable> settings, ClickHouseColumn[] columns) throws SQLException {
        if (this.processor == null) {
            try {
                this.processor = ClickHouseDataStreamFactory.getInstance().getProcessor(this.getConfig(), null, output, settings, Arrays.asList(columns));
            }
            catch (IOException e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        return this.processor;
    }

    protected void resetDataProcessor() {
        this.processor = null;
    }

    protected ClickHouseSqlStatement getLastStatement() {
        ClickHouseSqlStatement stmt = null;
        if (this.parsedStmts != null && this.parsedStmts.length > 0) {
            stmt = this.parsedStmts[this.parsedStmts.length - 1];
        }
        return ClickHouseChecker.nonNull(stmt, "ParsedStatement");
    }

    protected void setLastStatement(ClickHouseSqlStatement stmt) {
        if (this.parsedStmts != null && this.parsedStmts.length > 0) {
            this.parsedStmts[this.parsedStmts.length - 1] = ClickHouseChecker.nonNull(stmt, "ParsedStatement");
        }
    }

    protected ClickHouseSqlStatement parseSqlStatements(String sql) {
        this.parsedStmts = this.connection.parse(sql, this.getConfig(), this.request.getSettings());
        if (this.parsedStmts == null || this.parsedStmts.length == 0) {
            throw new IllegalArgumentException("Failed to parse given SQL: " + sql);
        }
        return this.getLastStatement();
    }

    protected ClickHouseResultSet newEmptyResultSet() throws SQLException {
        return new ClickHouseResultSet("", "", this, ClickHouseResponse.EMPTY);
    }

    protected ResultSet updateResult(ClickHouseSqlStatement stmt, ClickHouseResponse response) throws SQLException {
        if (stmt.isQuery() || !response.getColumns().isEmpty()) {
            this.currentUpdateCount = -1L;
            this.currentResult = new ClickHouseResultSet(stmt.getDatabaseOrDefault(this.getConnection().getCurrentDatabase()), stmt.getTable(), this, response);
        } else {
            response.close();
            this.currentUpdateCount = stmt.isDDL() || stmt.isTCL() ? 0L : (response.getSummary().isEmpty() ? 1L : response.getSummary().getWrittenRows());
            this.currentResult = null;
        }
        return this.currentResult;
    }

    protected ClickHouseStatementImpl(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (connection == null || request == null) {
            throw SqlExceptionUtils.clientError("Non-null connection and request are required");
        }
        this.connection = connection;
        this.request = request.setChangeListener(this);
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.resultSetHoldability = 2;
        this.closed = false;
        this.closeOnCompletion = true;
        this.fetchSize = connection.getJdbcConfig().getFetchSize();
        this.maxFieldSize = 0;
        this.maxRows = 0L;
        this.nullAsDefault = connection.getJdbcConfig().getNullAsDefault();
        this.poolable = false;
        this.queryId = null;
        this.queryTimeout = 0;
        this.currentResult = null;
        this.currentUpdateCount = -1L;
        this.mapper = connection.getJdbcTypeMapping();
        this.batchStmts = new LinkedList<ClickHouseSqlStatement>();
        ClickHouseConfig c = request.getConfig();
        this.setLargeMaxRows(c.getMaxResultRows());
        this.setQueryTimeout(c.getMaxExecutionTime());
        this.optionChanged(this.request, (ClickHouseOption)ClickHouseClientOption.FORMAT, (Serializable)null, (Serializable)null);
    }

    @Override
    public void optionChanged(ClickHouseRequest<?> source, ClickHouseOption option, Serializable oldValue, Serializable newValue) {
        if (source != this.request) {
            return;
        }
        if (option == ClickHouseClientOption.FORMAT) {
            this.processor = null;
        }
    }

    @Override
    public void settingChanged(ClickHouseRequest<?> source, String setting, Serializable oldValue, Serializable newValue) {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return this.currentResult != null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.ensureOpen();
        if (!this.batchStmts.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        this.parseSqlStatements(sql);
        this.getLastResponse(null, null, null);
        return this.currentResult != null ? this.currentResult : this.newEmptyResultSet();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        if (!this.batchStmts.isEmpty()) {
            throw SqlExceptionUtils.undeterminedExecutionError();
        }
        this.parseSqlStatements(sql);
        ClickHouseResponse response = this.getLastResponse(null, null, null);
        try {
            long l = this.currentUpdateCount;
            if (response != null) {
                response.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw SqlExceptionUtils.handle(e, new Throwable[0]);
            }
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw SqlExceptionUtils.clientError("Max field size cannot be set to negative number");
        }
        this.ensureOpen();
        this.maxFieldSize = max;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.ensureOpen();
        return this.maxRows;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            throw SqlExceptionUtils.clientError("Max rows cannot be set to negative number");
        }
        this.ensureOpen();
        if (this.maxRows != max) {
            if (max == 0L || !this.connection.allowCustomSetting()) {
                this.request.removeSetting(ClickHouseClientOption.MAX_RESULT_ROWS.getKey());
                this.request.removeSetting("result_overflow_mode");
            } else {
                this.request.set(ClickHouseClientOption.MAX_RESULT_ROWS.getKey(), Long.valueOf(max));
                this.request.set("result_overflow_mode", "break");
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureOpen();
        this.escapeScan = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw SqlExceptionUtils.clientError("Query timeout cannot be set to negative seconds");
        }
        this.ensureOpen();
        if (this.queryTimeout != seconds) {
            if (seconds == 0) {
                this.request.removeSetting("max_execution_time");
            } else {
                this.request.set("max_execution_time", Integer.valueOf(seconds));
            }
            this.queryTimeout = seconds;
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        String qid = this.queryId;
        if (qid != null) {
            String sessionIdKey = ClickHouseClientOption.SESSION_ID.getKey();
            ClickHouseNode server = this.request.getServer();
            if (server.getOptions().containsKey(sessionIdKey)) {
                server = ClickHouseNode.builder(this.request.getServer()).removeOption(sessionIdKey).removeOption(ClickHouseClientOption.SESSION_CHECK.getKey()).removeOption(ClickHouseClientOption.SESSION_TIMEOUT.getKey()).build();
            }
            try {
                List<ClickHouseResponseSummary> summaries = ClickHouseClient.send(server, String.format("KILL QUERY WHERE query_id='%s'", qid), new String[0]).get(this.request.getConfig().getConnectionTimeout(), TimeUnit.MILLISECONDS);
                log.info((Object)"Killed query [%s]: %s", qid, summaries.get(0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn((Object)"Cancellation of query [%s] was interrupted", qid);
            }
            catch (TimeoutException e) {
                log.warn((Object)"Timed out after waiting %d ms for killing query [%s]", this.request.getConfig().getConnectionTimeout(), qid);
            }
            catch (Exception e) {
                throw SqlExceptionUtils.handle(e.getCause(), new Throwable[0]);
            }
        }
        if (this.request.getTransaction() != null) {
            this.request.getTransaction().abort();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureOpen();
        this.cursorName = name;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureOpen();
        return this.currentResult;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.ensureOpen();
        return this.currentUpdateCount;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpen();
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        this.currentUpdateCount = -1L;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000) {
            throw SqlExceptionUtils.unsupportedError("only FETCH_FORWARD is supported in setFetchDirection");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            log.warn((Object)"Negative fetch size is treated as 0.", new Object[0]);
            rows = 0;
        }
        this.ensureOpen();
        if (this.fetchSize != rows) {
            this.fetchSize = rows;
            if (rows == 0) {
                this.request.removeOption(ClickHouseClientOption.READ_BUFFER_SIZE);
            } else {
                this.request.option(ClickHouseClientOption.READ_BUFFER_SIZE, Integer.valueOf(rows * 1024));
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        for (ClickHouseSqlStatement s : this.connection.parse(sql, this.getConfig(), this.request.getSettings())) {
            this.batchStmts.add(s);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batchStmts.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long[] largeUpdateCounts = this.executeLargeBatch();
        int len = largeUpdateCounts.length;
        int[] results = new int[len];
        for (int i = 0; i < len; ++i) {
            results[i] = (int)largeUpdateCounts[i];
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.ensureOpen();
        if (this.batchStmts.isEmpty()) {
            return ClickHouseValues.EMPTY_LONG_ARRAY;
        }
        boolean continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        long[] results = new long[this.batchStmts.size()];
        try {
            int i = 0;
            for (ClickHouseSqlStatement s : this.batchStmts) {
                try {
                    ClickHouseResponse r = this.executeStatement(s, null, null, null);
                    try {
                        ResultSet rs = this.updateResult(s, r);
                        try {
                            if (rs != null && s.isQuery()) {
                                throw SqlExceptionUtils.queryInBatchError(results);
                            }
                            results[i] = this.currentUpdateCount <= 0L ? 0L : this.currentUpdateCount;
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                    }
                }
                catch (Exception e) {
                    results[i] = -3L;
                    if (!continueOnError) {
                        throw SqlExceptionUtils.batchUpdateError(e, results);
                    }
                    log.error((Object)"Faled to execute task %d of %d", i + 1, this.batchStmts.size(), e);
                }
                finally {
                    ++i;
                }
            }
        }
        finally {
            this.clearBatch();
        }
        return results;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.ensureOpen();
        switch (current) {
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                if (this.currentResult == null) break;
                this.currentResult.close();
                break;
            }
            default: {
                throw SqlExceptionUtils.clientError("Unknown statement constants: " + current);
            }
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureOpen();
        return new ClickHouseResultSet(this.request.getConfig().getDatabase(), "unknown", this, ClickHouseResponse.EMPTY);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureOpen();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureOpen();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.closeOnCompletion;
    }

    @Override
    public ClickHouseConnection getConnection() throws SQLException {
        this.ensureOpen();
        return this.connection;
    }

    @Override
    public ClickHouseConfig getConfig() {
        return this.request.getConfig();
    }

    @Override
    public OutputStream getMirroredOutput() {
        return this.mirroredOutput;
    }

    @Override
    public void setMirroredOutput(OutputStream out) {
        if (this.mirroredOutput != null) {
            try {
                this.mirroredOutput.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mirroredOutput = out;
    }

    @Override
    public int getNullAsDefault() {
        return this.nullAsDefault;
    }

    @Override
    public void setNullAsDefault(int level) {
        this.nullAsDefault = level;
    }

    @Override
    public ClickHouseRequest<?> getRequest() {
        return this.request;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ClickHouseRequest.class || super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface == ClickHouseRequest.class ? iface.cast(this.request) : super.unwrap(iface);
    }
}

