/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.internal.Preconditions;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import java.util.concurrent.TimeUnit;

public final class AIMDLimit
extends AbstractLimit {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private final double backoffRatio;
    private final long timeout;
    private final int minLimit;
    private final int maxLimit;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AIMDLimit(Builder builder) {
        super(builder.initialLimit);
        this.backoffRatio = builder.backoffRatio;
        this.timeout = builder.timeout;
        this.maxLimit = builder.maxLimit;
        this.minLimit = builder.minLimit;
    }

    @Override
    protected int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        int currentLimit = this.getLimit();
        if (didDrop || rtt > this.timeout) {
            currentLimit = (int)((double)currentLimit * this.backoffRatio);
        } else if (inflight * 2 >= currentLimit) {
            ++currentLimit;
        }
        if (currentLimit >= this.maxLimit) {
            currentLimit /= 2;
        }
        return Math.min(this.maxLimit, Math.max(this.minLimit, currentLimit));
    }

    public String toString() {
        return "AIMDLimit [limit=" + this.getLimit() + "]";
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_TIMEOUT;
    }

    public static class Builder {
        private int minLimit = 20;
        private int initialLimit = 20;
        private int maxLimit = 200;
        private double backoffRatio = 0.9;
        private long timeout = AIMDLimit.access$000();

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder minLimit(int minLimit) {
            this.minLimit = minLimit;
            return this;
        }

        public Builder maxLimit(int maxLimit) {
            this.maxLimit = maxLimit;
            return this;
        }

        public Builder backoffRatio(double backoffRatio) {
            Preconditions.checkArgument(backoffRatio < 1.0 && backoffRatio >= 0.5, "Backoff ratio must be in the range [0.5, 1.0)");
            this.backoffRatio = backoffRatio;
            return this;
        }

        public Builder timeout(long timeout, TimeUnit units) {
            Preconditions.checkArgument(timeout > 0L, "Timeout must be positive");
            this.timeout = units.toNanos(timeout);
            return this;
        }

        public AIMDLimit build() {
            return new AIMDLimit(this);
        }
    }
}

