/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.bifromq.basecrdt.core.api.CCounterOperation;
import org.apache.bifromq.basecrdt.core.internal.CoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.DotFunc;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotFunc;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.core.internal.VarLong;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.Replacement;

class CCounterCoalesceOperation
extends CoalesceOperation<IDotMap, CCounterOperation> {
    private final Set<ByteString> zeroOutReplicaIds = Sets.newHashSet();
    private long inc;
    private boolean preset;

    CCounterCoalesceOperation(ByteString replicaId, CCounterOperation op) {
        super(replicaId);
        this.coalesce(op);
    }

    @Override
    public void coalesce(CCounterOperation op) {
        switch (op.type) {
            case Add: {
                this.inc += op.c;
                break;
            }
            case Preset: {
                if (op.replicaId == null) {
                    this.preset = true;
                    this.inc = op.c;
                    break;
                }
                this.zeroOutReplicaIds.add(op.replicaId);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ccounter operation type: " + String.valueOf((Object)op.type));
            }
        }
    }

    @Override
    public Iterable<Replacement> delta(IDotMap current, ICoalesceOperation.IEventGenerator eventGenerator) {
        long now;
        long l = now = this.preset ? this.inc : this.getPartialCount(current.subDotFunc(this.replicaId).orElse(DotFunc.BOTTOM)) + this.inc;
        if (this.preset && this.inc == 0L) {
            return this.zeroOut(eventGenerator.nextEvent(), current, (Set<ByteString>)Sets.union(this.zeroOutReplicaIds, (Set)Sets.newHashSet((Object[])new ByteString[]{this.replicaId})));
        }
        long ver = eventGenerator.nextEvent();
        if (this.zeroOutReplicaIds.isEmpty()) {
            return ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, ver, ProtoUtils.singleMap(this.replicaId, ProtoUtils.singleValue(this.replicaId, ver, VarLong.encode(now)))), current.subDotFunc(this.replicaId).orElse(DotFunc.BOTTOM));
        }
        return Iterables.concat(ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, ver, ProtoUtils.singleMap(this.replicaId, ProtoUtils.singleValue(this.replicaId, ver, VarLong.encode(now)))), current.subDotFunc(this.replicaId).orElse(DotFunc.BOTTOM)), this.zeroOut(eventGenerator.nextEvent(), current, this.zeroOutReplicaIds));
    }

    private Iterable<Replacement> zeroOut(long ver, IDotMap current, Set<ByteString> replicaIds) {
        return ProtoUtils.replacements(ProtoUtils.dot(this.replicaId, ver), Iterables.concat((Iterable)replicaIds.stream().map(r -> current.subDotFunc((ByteString)r).orElse(DotFunc.BOTTOM)).collect(Collectors.toSet())));
    }

    private long getPartialCount(IDotFunc df) {
        long maxVer = -1L;
        long val = 0L;
        for (Dot dot : df) {
            if (dot.getVer() <= maxVer) continue;
            maxVer = dot.getVer();
            val = VarLong.decode(df.value(dot).get());
        }
        return val;
    }
}

