/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.UnsubReply;
import org.apache.bifromq.inbox.rpc.proto.UnsubRequest;
import org.apache.bifromq.inbox.storage.proto.BatchUnsubReply;
import org.apache.bifromq.inbox.storage.proto.BatchUnsubRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchUnsubCall
extends BatchMutationCall<UnsubRequest, UnsubReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchUnsubCall.class);

    protected BatchUnsubCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<UnsubRequest, UnsubReply> newBatch(long ver) {
        return new BatchUnsubCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<UnsubRequest, UnsubReply, MutationCallBatcherKey>> callTasks) {
        BatchUnsubRequest.Builder reqBuilder = BatchUnsubRequest.newBuilder();
        callTasks.forEach(call -> {
            UnsubRequest request = (UnsubRequest)call.call();
            reqBuilder.addParams(BatchUnsubRequest.Params.newBuilder().setTenantId(request.getTenantId()).setInboxId(request.getInboxId()).setVersion(request.getVersion()).setTopicFilter(request.getTopicFilter()).setNow(request.getNow()).build());
        });
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchUnsub(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<UnsubRequest, UnsubReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<UnsubRequest, UnsubReply, MutationCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchUnsub().getResultCount());
        int i = 0;
        block6: while ((task = batchedTasks.poll()) != null) {
            UnsubReply.Builder replyBuilder = UnsubReply.newBuilder().setReqId(((UnsubRequest)task.call()).getReqId());
            BatchUnsubReply.Result result = output.getInboxService().getBatchUnsub().getResult(i++);
            switch (result.getCode()) {
                case OK: {
                    task.resultPromise().complete(replyBuilder.setCode(UnsubReply.Code.OK).setOption(result.getOption()).build());
                    continue block6;
                }
                case NO_INBOX: {
                    task.resultPromise().complete(replyBuilder.setCode(UnsubReply.Code.NO_INBOX).build());
                    continue block6;
                }
                case NO_SUB: {
                    task.resultPromise().complete(replyBuilder.setCode(UnsubReply.Code.NO_SUB).build());
                    continue block6;
                }
                case CONFLICT: {
                    task.resultPromise().complete(replyBuilder.setCode(UnsubReply.Code.CONFLICT).build());
                    continue block6;
                }
            }
            log.error("Unknown error code: {}", (Object)result.getCode());
            task.resultPromise().complete(replyBuilder.setCode(UnsubReply.Code.ERROR).build());
        }
    }

    protected void handleException(ICallTask<UnsubRequest, UnsubReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(UnsubReply.newBuilder().setReqId(((UnsubRequest)callTask.call()).getReqId()).setCode(UnsubReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(UnsubReply.newBuilder().setReqId(((UnsubRequest)callTask.call()).getReqId()).setCode(UnsubReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(UnsubReply.newBuilder().setReqId(((UnsubRequest)callTask.call()).getReqId()).setCode(UnsubReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchUnsubCallTask
    extends BatchMutationCall.MutationCallTaskBatch<UnsubRequest, UnsubReply> {
        private final Map<String, Set<InboxVersion>> inboxes = new HashMap<String, Set<InboxVersion>>();

        private BatchUnsubCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<UnsubRequest, UnsubReply, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.computeIfAbsent(((UnsubRequest)callTask.call()).getTenantId(), k -> new HashSet()).add(((UnsubRequest)callTask.call()).getVersion());
        }

        protected boolean isBatchable(ICallTask<UnsubRequest, UnsubReply, MutationCallBatcherKey> callTask) {
            return !this.inboxes.getOrDefault(((UnsubRequest)callTask.call()).getTenantId(), Collections.emptySet()).contains(((UnsubRequest)callTask.call()).getVersion());
        }
    }
}

