/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basekv.store.range.IKVRangeMetricManager;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;

class KVRangeMetricManager
implements IKVRangeMetricManager {
    private final DistributionSummary dumpBytesSummary;
    private final DistributionSummary restoreBytesSummary;
    private final Gauge stateGauge;
    private final Gauge verGauge;
    private final Gauge lastAppliedIndexGauge;
    private final Gauge dataSizeGauge;
    private final Gauge walSizeGauge;
    private final Timer configChangeTimer;
    private final Timer transferLeaderTimer;
    private final Timer splitTimer;
    private final Timer mergeTimer;
    private final Timer putTimer;
    private final Timer deleteTimer;
    private final Timer mutateCoProcTimer;
    private final Timer existTimer;
    private final Timer getTimer;
    private final Timer queryCoProcTimer;
    private final Timer linearizerTimer;
    private final Timer compactionTimer;
    private final Timer applyLogTimer;
    private final Timer installSnapshotTimer;
    private final AtomicReference<KVRangeDescriptor> currentDesc = new AtomicReference();
    private final AtomicLong currentLastAppliedIndex = new AtomicLong(-1L);

    KVRangeMetricManager(String clusterId, String storeId, KVRangeId rangeId) {
        Tags tags = Tags.of((String)"clusterId", (String)clusterId).and("storeId", storeId).and("rangeId", KVRangeIdUtil.toString((KVRangeId)rangeId));
        this.dumpBytesSummary = Metrics.summary((String)"basekv.snap.dump", (Iterable)tags);
        this.restoreBytesSummary = Metrics.summary((String)"basekv.snap.restore", (Iterable)tags);
        this.stateGauge = Gauge.builder((String)"basekv.meta.state", () -> {
            KVRangeDescriptor desc = this.currentDesc.get();
            if (desc != null) {
                return desc.getState().ordinal();
            }
            return State.StateType.NoUse.ordinal();
        }).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.verGauge = Gauge.builder((String)"basekv.meta.ver", () -> {
            KVRangeDescriptor desc = this.currentDesc.get();
            if (desc != null) {
                return desc.getVer();
            }
            return -1;
        }).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.lastAppliedIndexGauge = Gauge.builder((String)"basekv.meta.appidx", this.currentLastAppliedIndex::get).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.dataSizeGauge = Gauge.builder((String)"basekv.meta.size", () -> {
            KVRangeDescriptor desc = this.currentDesc.get();
            if (desc != null) {
                return desc.getStatisticsMap().getOrDefault("dataSize", 0.0).longValue();
            }
            return 0;
        }).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.walSizeGauge = Gauge.builder((String)"basekv.meta.walsize", () -> {
            KVRangeDescriptor desc = this.currentDesc.get();
            if (desc != null) {
                return desc.getStatisticsMap().getOrDefault("walSize", 0.0).longValue();
            }
            return 0;
        }).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.configChangeTimer = Timer.builder((String)"basekv.cmd.configchange").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.transferLeaderTimer = Timer.builder((String)"basekv.cmd.transferleader").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.splitTimer = Timer.builder((String)"basekv.cmd.split").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.mergeTimer = Timer.builder((String)"basekv.cmd.merge").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.putTimer = Timer.builder((String)"basekv.cmd.put").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.deleteTimer = Timer.builder((String)"basekv.cmd.delete").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.mutateCoProcTimer = Timer.builder((String)"basekv.cmd.mutatecoproc").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.existTimer = Timer.builder((String)"basekv.cmd.exist").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.getTimer = Timer.builder((String)"basekv.cmd.get").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.queryCoProcTimer = Timer.builder((String)"basekv.cmd.querycoproc").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.linearizerTimer = Timer.builder((String)"basekv.cmd.linear").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.compactionTimer = Timer.builder((String)"basekv.cmd.compact").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.applyLogTimer = Timer.builder((String)"basekv.applylog").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.installSnapshotTimer = Timer.builder((String)"basekv.installsnapshot").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    @Override
    public void report(KVRangeDescriptor descriptor) {
        this.currentDesc.set(descriptor);
    }

    @Override
    public void reportDump(int bytes) {
        this.dumpBytesSummary.record((double)bytes);
    }

    @Override
    public void reportRestore(int bytes) {
        this.restoreBytesSummary.record((double)bytes);
    }

    @Override
    public void reportLastAppliedIndex(long index) {
        this.currentLastAppliedIndex.set(index);
    }

    @Override
    public <T> CompletableFuture<T> recordDuration(Supplier<CompletableFuture<T>> supplier, Timer timer) {
        Timer.Sample sample = Timer.start();
        CompletableFuture<T> f = supplier.get();
        f.whenComplete((v, e) -> sample.stop(timer));
        return f;
    }

    @Override
    public CompletableFuture<Void> recordConfigChange(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.configChangeTimer);
    }

    @Override
    public CompletableFuture<Void> recordTransferLeader(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.transferLeaderTimer);
    }

    @Override
    public CompletableFuture<Void> recordSplit(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.splitTimer);
    }

    @Override
    public CompletableFuture<Void> recordMerge(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.mergeTimer);
    }

    @Override
    public CompletableFuture<ByteString> recordPut(Supplier<CompletableFuture<ByteString>> supplier) {
        return this.recordDuration(supplier, this.putTimer);
    }

    @Override
    public CompletableFuture<ByteString> recordDelete(Supplier<CompletableFuture<ByteString>> supplier) {
        return this.recordDuration(supplier, this.deleteTimer);
    }

    @Override
    public CompletableFuture<RWCoProcOutput> recordMutateCoProc(Supplier<CompletableFuture<RWCoProcOutput>> supplier) {
        return this.recordDuration(supplier, this.mutateCoProcTimer);
    }

    @Override
    public CompletableFuture<Boolean> recordExist(Supplier<CompletableFuture<Boolean>> supplier) {
        return this.recordDuration(supplier, this.existTimer);
    }

    @Override
    public CompletableFuture<Optional<ByteString>> recordGet(Supplier<CompletableFuture<Optional<ByteString>>> supplier) {
        return this.recordDuration(supplier, this.getTimer);
    }

    @Override
    public CompletableFuture<ROCoProcOutput> recordQueryCoProc(Supplier<CompletableFuture<ROCoProcOutput>> supplier) {
        return this.recordDuration(supplier, this.queryCoProcTimer);
    }

    @Override
    public CompletableFuture<Void> recordLinearization(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.linearizerTimer);
    }

    @Override
    public CompletableFuture<Void> recordCompact(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.compactionTimer);
    }

    @Override
    public CompletableFuture<Void> recordLogApply(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.applyLogTimer);
    }

    @Override
    public CompletableFuture<Void> recordSnapshotInstall(Supplier<CompletableFuture<Void>> supplier) {
        return this.recordDuration(supplier, this.installSnapshotTimer);
    }

    void close() {
        Metrics.globalRegistry.removeByPreFilterId(this.dumpBytesSummary.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.restoreBytesSummary.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.stateGauge.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.lastAppliedIndexGauge.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.verGauge.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.dataSizeGauge.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.walSizeGauge.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.configChangeTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.transferLeaderTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.splitTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.mergeTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.putTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.deleteTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.mutateCoProcTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.existTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.getTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.queryCoProcTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.linearizerTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.compactionTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.applyLogTimer.getId());
        Metrics.globalRegistry.removeByPreFilterId(this.installSnapshotTimer.getId());
    }
}

