/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.client.scheduler;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.dist.client.scheduler.PubCallBatcherKey;
import org.apache.bifromq.dist.client.scheduler.PubRequest;
import org.apache.bifromq.dist.rpc.proto.DistReply;
import org.apache.bifromq.dist.rpc.proto.DistRequest;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.PublisherMessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchPubCall
implements IBatchCall<PubRequest, PubResult, PubCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchPubCall.class);
    private final IRPCClient.IRequestPipeline<DistRequest, DistReply> ppln;
    private Queue<ICallTask<PubRequest, PubResult, PubCallBatcherKey>> tasks = new ArrayDeque<ICallTask<PubRequest, PubResult, PubCallBatcherKey>>(64);
    private Map<ClientInfo, Map<String, PublisherMessagePack.TopicPack.Builder>> clientMsgPack = new HashMap<ClientInfo, Map<String, PublisherMessagePack.TopicPack.Builder>>(128);

    BatchPubCall(IRPCClient.IRequestPipeline<DistRequest, DistReply> ppln) {
        this.ppln = ppln;
    }

    public void reset(boolean abort) {
        if (abort) {
            this.tasks = new ArrayDeque<ICallTask<PubRequest, PubResult, PubCallBatcherKey>>(64);
            this.clientMsgPack = new HashMap<ClientInfo, Map<String, PublisherMessagePack.TopicPack.Builder>>(128);
        }
    }

    public void add(ICallTask<PubRequest, PubResult, PubCallBatcherKey> callTask) {
        this.tasks.add(callTask);
        this.clientMsgPack.computeIfAbsent(((PubRequest)callTask.call()).publisher, k -> new HashMap()).computeIfAbsent(((PubRequest)callTask.call()).topic, k -> PublisherMessagePack.TopicPack.newBuilder().setTopic(k)).addMessage(((PubRequest)callTask.call()).message);
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.tasks, this.clientMsgPack);
    }

    private CompletableFuture<Void> execute(Queue<ICallTask<PubRequest, PubResult, PubCallBatcherKey>> tasks, Map<ClientInfo, Map<String, PublisherMessagePack.TopicPack.Builder>> clientMsgPack) {
        DistRequest.Builder requestBuilder = DistRequest.newBuilder().setReqId(System.nanoTime());
        Iterator<Map.Entry<ClientInfo, Map<String, PublisherMessagePack.TopicPack.Builder>>> itr = clientMsgPack.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<ClientInfo, Map<String, PublisherMessagePack.TopicPack.Builder>> entry = itr.next();
            ClientInfo publisher = entry.getKey();
            Map<String, PublisherMessagePack.TopicPack.Builder> topicPackMap = entry.getValue();
            PublisherMessagePack.Builder senderMsgPackBuilder = PublisherMessagePack.newBuilder().setPublisher(publisher);
            for (PublisherMessagePack.TopicPack.Builder packBuilder : topicPackMap.values()) {
                senderMsgPackBuilder.addMessagePack(packBuilder);
            }
            requestBuilder.addMessages(senderMsgPackBuilder.build());
            itr.remove();
        }
        DistRequest request = requestBuilder.build();
        return this.ppln.invoke((Object)request).handle((reply, e) -> {
            if (e != null) {
                ICallTask task;
                while ((task = (ICallTask)tasks.poll()) != null) {
                    task.resultPromise().complete(PubResult.ERROR);
                }
            } else {
                switch (reply.getCode()) {
                    case OK: {
                        try {
                            ICallTask task;
                            HashMap fanoutResultMap = new HashMap();
                            for (int i = 0; i < request.getMessagesCount(); ++i) {
                                PublisherMessagePack pubMsgPack = request.getMessages(i);
                                DistReply.DistResult result = reply.getResults(i);
                                fanoutResultMap.put(pubMsgPack.getPublisher(), result.getTopicMap());
                            }
                            block13: while ((task = (ICallTask)tasks.poll()) != null) {
                                Integer fanOut = (Integer)fanoutResultMap.getOrDefault(((PubRequest)task.call()).publisher, Collections.emptyMap()).get(((PubRequest)task.call()).topic);
                                if (fanOut == null) {
                                    log.warn("Illegal state: no dist result for topic: {}", (Object)((PubRequest)task.call()).topic);
                                    fanOut = 0;
                                }
                                switch (fanOut) {
                                    case -2: {
                                        task.resultPromise().complete(PubResult.ERROR);
                                        continue block13;
                                    }
                                    case -1: {
                                        task.resultPromise().complete(PubResult.TRY_LATER);
                                        continue block13;
                                    }
                                    case 0: {
                                        task.resultPromise().complete(PubResult.NO_MATCH);
                                        continue block13;
                                    }
                                }
                                task.resultPromise().complete(PubResult.OK);
                            }
                            break;
                        }
                        catch (Throwable t) {
                            ICallTask task;
                            log.error("Unexpected exception", t);
                            while ((task = (ICallTask)tasks.poll()) != null) {
                                task.resultPromise().complete(PubResult.ERROR);
                            }
                            break;
                        }
                    }
                    case BACK_PRESSURE_REJECTED: {
                        ICallTask task;
                        while ((task = (ICallTask)tasks.poll()) != null) {
                            task.resultPromise().complete(PubResult.BACK_PRESSURE_REJECTED);
                        }
                        throw new BackPressureException("Batch pub call back-pressured");
                    }
                    default: {
                        ICallTask task;
                        assert (reply.getCode() == DistReply.Code.ERROR);
                        while ((task = (ICallTask)tasks.poll()) != null) {
                            task.resultPromise().complete(PubResult.ERROR);
                        }
                        break;
                    }
                }
            }
            return null;
        });
    }
}

