/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.utils;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.plugin.authprovider.type.ConnAction;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.PubAction;
import org.apache.bifromq.plugin.authprovider.type.SubAction;
import org.apache.bifromq.plugin.authprovider.type.UnsubAction;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.UserProperties;

public class AuthUtil {
    public static MQTT3AuthData buildMQTT3AuthData(Channel channel, MqttConnectMessage msg) {
        InetSocketAddress remoteAddr;
        X509Certificate cert;
        assert (msg.variableHeader().version() != 5);
        MQTT3AuthData.Builder authData = MQTT3AuthData.newBuilder();
        if (msg.variableHeader().version() == 3) {
            authData.setIsMQIsdp(true);
        }
        if ((cert = ChannelAttrs.clientCertificate(channel)) != null) {
            authData.setCert(UnsafeByteOperations.unsafeWrap((byte[])cert.getEncoded()));
        }
        if (msg.variableHeader().hasUserName()) {
            authData.setUsername(msg.payload().userName());
        }
        if (msg.variableHeader().hasPassword()) {
            authData.setPassword(UnsafeByteOperations.unsafeWrap((byte[])msg.payload().passwordInBytes()));
        }
        if (!Strings.isNullOrEmpty((String)msg.payload().clientIdentifier())) {
            authData.setClientId(msg.payload().clientIdentifier());
        }
        if ((remoteAddr = ChannelAttrs.socketAddress(channel)) != null) {
            authData.setRemotePort(remoteAddr.getPort()).setChannelId(channel.id().asLongText());
            InetAddress ip = remoteAddr.getAddress();
            if (remoteAddr.getAddress() != null) {
                authData.setRemoteAddr(ip.getHostAddress());
            }
        }
        return authData.build();
    }

    public static MQTT5AuthData buildMQTT5AuthData(Channel channel, MqttConnectMessage msg) {
        InetSocketAddress remoteAddr;
        assert (msg.variableHeader().version() == 5);
        MQTT5AuthData.Builder authData = MQTT5AuthData.newBuilder();
        X509Certificate cert = ChannelAttrs.clientCertificate(channel);
        if (cert != null) {
            authData.setCert(UnsafeByteOperations.unsafeWrap((byte[])cert.getEncoded()));
        }
        if (msg.variableHeader().hasUserName()) {
            authData.setUsername(msg.payload().userName());
        }
        if (msg.variableHeader().hasPassword()) {
            authData.setPassword(UnsafeByteOperations.unsafeWrap((byte[])msg.payload().passwordInBytes()));
        }
        if (!Strings.isNullOrEmpty((String)msg.payload().clientIdentifier())) {
            authData.setClientId(msg.payload().clientIdentifier());
        }
        if ((remoteAddr = ChannelAttrs.socketAddress(channel)) != null) {
            authData.setRemotePort(remoteAddr.getPort()).setChannelId(channel.id().asLongText());
            InetAddress ip = remoteAddr.getAddress();
            if (remoteAddr.getAddress() != null) {
                authData.setRemoteAddr(ip.getHostAddress());
            }
        }
        authData.setResponseInfo(MQTT5MessageUtils.requestResponseInformation(msg.variableHeader().properties()));
        UserProperties userProperties = MQTT5MessageUtils.toUserProperties(msg.variableHeader().properties());
        return authData.setUserProps(userProperties).build();
    }

    public static MQTT5ExtendedAuthData buildMQTT5ExtendedAuthData(Channel channel, MqttConnectMessage msg) {
        assert (msg.variableHeader().version() == 5);
        MQTT5ExtendedAuthData.Initial.Builder initialBuilder = MQTT5ExtendedAuthData.Initial.newBuilder();
        initialBuilder.setBasic(AuthUtil.buildMQTT5AuthData(channel, msg)).setAuthMethod(MQTT5MessageUtils.authMethod(msg.variableHeader().properties()).get());
        Optional<ByteString> authData = MQTT5MessageUtils.authData(msg.variableHeader().properties());
        authData.ifPresent(arg_0 -> ((MQTT5ExtendedAuthData.Initial.Builder)initialBuilder).setAuthData(arg_0));
        return MQTT5ExtendedAuthData.newBuilder().setInitial(initialBuilder.build()).build();
    }

    public static MQTT5ExtendedAuthData buildMQTT5ExtendedAuthData(MqttMessage authMsg, boolean isReAuth) {
        MQTT5ExtendedAuthData.Auth.Builder authBuilder = MQTT5ExtendedAuthData.Auth.newBuilder().setIsReAuth(isReAuth);
        MqttProperties authProps = ((MqttReasonCodeAndPropertiesVariableHeader)authMsg.variableHeader()).properties();
        MQTT5MessageUtils.authMethod(authProps).ifPresent(arg_0 -> ((MQTT5ExtendedAuthData.Auth.Builder)authBuilder).setAuthMethod(arg_0));
        MQTT5MessageUtils.authData(authProps).ifPresent(arg_0 -> ((MQTT5ExtendedAuthData.Auth.Builder)authBuilder).setAuthData(arg_0));
        authBuilder.setUserProps(MQTT5MessageUtils.toUserProperties(authProps));
        return MQTT5ExtendedAuthData.newBuilder().setAuth(authBuilder.build()).build();
    }

    public static MQTTAction buildConnAction(UserProperties userProps) {
        return MQTTAction.newBuilder().setConn(ConnAction.newBuilder().setUserProps(userProps).build()).build();
    }

    public static MQTTAction buildPubAction(String topic, QoS qos, boolean retained) {
        return MQTTAction.newBuilder().setPub(PubAction.newBuilder().setTopic(topic).setQos(qos).setIsRetained(retained).build()).build();
    }

    public static MQTTAction buildPubAction(String topic, QoS qos, boolean retained, UserProperties userProps) {
        return MQTTAction.newBuilder().setPub(PubAction.newBuilder().setTopic(topic).setQos(qos).setIsRetained(retained).setUserProps(userProps).build()).build();
    }

    public static MQTTAction buildSubAction(String topicFilter, QoS qos) {
        return MQTTAction.newBuilder().setSub(SubAction.newBuilder().setTopicFilter(topicFilter).setQos(qos).build()).build();
    }

    public static MQTTAction buildSubAction(String topicFilter, QoS qos, UserProperties userProps) {
        return MQTTAction.newBuilder().setSub(SubAction.newBuilder().setTopicFilter(topicFilter).setQos(qos).setUserProps(userProps).build()).build();
    }

    public static MQTTAction buildUnsubAction(String topicFilter) {
        return MQTTAction.newBuilder().setUnsub(UnsubAction.newBuilder().setTopicFilter(topicFilter).build()).build();
    }

    public static MQTTAction buildUnsubAction(String topicFilter, UserProperties userProps) {
        return MQTTAction.newBuilder().setUnsub(UnsubAction.newBuilder().setTopicFilter(topicFilter).setUserProps(userProps).build()).build();
    }
}

