/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.job;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.RedirectFilter;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.job.GremlinJob;
import org.apache.hugegraph.job.Job;
import org.apache.hugegraph.job.JobBuilder;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/jobs/gremlin")
@Singleton
@Tag(name="GremlinAPI")
public class GremlinAPI
extends API {
    private static final Logger LOG = Log.logger(GremlinAPI.class);
    private static final int MAX_NAME_LENGTH = 256;
    private static final Histogram GREMLIN_JOB_INPUT_HISTOGRAM = MetricsUtil.registerHistogram(GremlinAPI.class, "gremlin-input");

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=gremlin_execute"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Id> post(@Context GraphManager manager, @PathParam(value="graph") String graph, GremlinRequest request) {
        LOG.debug("Graph [{}] schedule gremlin job: {}", (Object)graph, (Object)request);
        GremlinAPI.checkCreatingBody(request);
        GREMLIN_JOB_INPUT_HISTOGRAM.update(request.gremlin.length());
        HugeGraph g = GremlinAPI.graph(manager, graph);
        request.aliase(graph, "graph");
        JobBuilder builder = JobBuilder.of((HugeGraph)g);
        builder.name(request.name()).input(request.toJson()).job((Job)new GremlinJob());
        return ImmutableMap.of((Object)"task_id", (Object)builder.schedule().id());
    }

    public static class GremlinRequest
    implements Checkable {
        @JsonProperty
        private String gremlin;
        @JsonProperty
        private Map<String, Object> bindings = new HashMap<String, Object>();
        @JsonProperty
        private String language = "gremlin-groovy";
        @JsonProperty
        private Map<String, String> aliases = new HashMap<String, String>();

        public String gremlin() {
            return this.gremlin;
        }

        public void gremlin(String gremlin) {
            this.gremlin = gremlin;
        }

        public Map<String, Object> bindings() {
            return this.bindings;
        }

        public void bindings(Map<String, Object> bindings) {
            this.bindings = bindings;
        }

        public void binding(String name, Object value) {
            this.bindings.put(name, value);
        }

        public String language() {
            return this.language;
        }

        public void language(String language) {
            this.language = language;
        }

        public Map<String, String> aliases() {
            return this.aliases;
        }

        public void aliases(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        public void aliase(String key, String value) {
            this.aliases.put(key, value);
        }

        public String name() {
            Charset charset;
            String firstLine = this.gremlin.split("\r\n|\r|\n", 2)[0];
            byte[] bytes = firstLine.getBytes(charset = Charset.forName("UTF-8"));
            if (bytes.length <= 256) {
                return firstLine;
            }
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.IGNORE);
            decoder.reset();
            ByteBuffer buffer = ByteBuffer.wrap(bytes, 0, 256);
            try {
                return decoder.decode(buffer).toString();
            }
            catch (CharacterCodingException e) {
                throw new HugeException("Failed to decode truncated bytes of gremlin first line", (Throwable)e);
            }
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.gremlin, (String)"The gremlin parameter can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.language, (String)"The language parameter can't be null", (Object[])new Object[0]);
            E.checkArgument((this.aliases == null || this.aliases.isEmpty() ? 1 : 0) != 0, (String)"There is no need to pass gremlin aliases", (Object[])new Object[0]);
        }

        public String toJson() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("gremlin", this.gremlin);
            map.put("bindings", this.bindings);
            map.put("language", this.language);
            map.put("aliases", this.aliases);
            return JsonUtil.toJson(map);
        }

        public static GremlinRequest fromJson(String json) {
            Map map = (Map)JsonUtil.fromJson((String)json, Map.class);
            String gremlin = (String)map.get("gremlin");
            Map bindings = (Map)map.get("bindings");
            String language = (String)map.get("language");
            Map aliases = (Map)map.get("aliases");
            GremlinRequest request = new GremlinRequest();
            request.gremlin(gremlin);
            request.bindings(bindings);
            request.language(language);
            request.aliases(aliases);
            return request;
        }
    }
}

