/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.Nullable;

public class TextReadDocumentContext
implements ReadDocumentContext {
    public static final BytesStore SOD_SEP = BytesStore.from((CharSequence)"---");
    public static final BytesStore EOD_SEP = BytesStore.from((CharSequence)"...");
    @Nullable
    protected AbstractWire wire;
    protected boolean present;
    protected boolean notComplete;
    private boolean metaData;
    private long readPosition;
    private long readLimit;
    private long start = -1L;
    private boolean rollback;

    public TextReadDocumentContext(@Nullable AbstractWire wire) {
        this.wire = wire;
    }

    public static void consumeToEndOfMessage(Bytes<?> bytes) {
        while (bytes.readRemaining() > 0L) {
            while (bytes.readRemaining() > 0L && bytes.readUnsignedByte() >= 32) {
            }
            if (!TextReadDocumentContext.isEndOfMessage(bytes)) continue;
            break;
        }
    }

    public static boolean isEndOfMessage(Bytes<?> bytes) {
        return (bytes.startsWith(SOD_SEP) || bytes.startsWith(EOD_SEP)) && TextReadDocumentContext.isWhiteSpaceAt(bytes);
    }

    protected static boolean isWhiteSpaceAt(Bytes<?> bytes) {
        return bytes.peekUnsignedByte(bytes.readPosition() + 3L) <= 32;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    @Override
    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    @Override
    public void close() {
        long readLimit = this.readLimit;
        long readPosition = this.readPosition;
        AbstractWire wire0 = this.wire;
        wire0.bytes.readLimit(readLimit);
        if (this.rollback) {
            if (this.start > -1L) {
                wire0.bytes.readPosition(this.start);
            }
            this.rollback = false;
        } else {
            wire0.bytes.readPosition(readPosition);
        }
        this.start = -1L;
        this.wire.getValueIn().resetState();
        this.present = false;
    }

    @Override
    public void start() {
        this.wire.getValueIn().resetState();
        Bytes<?> bytes = this.wire.bytes();
        this.present = false;
        this.wire.consumePadding();
        if (bytes.startsWith(EOD_SEP) && TextReadDocumentContext.isWhiteSpaceAt(bytes)) {
            this.skipSep(bytes);
        }
        if (bytes.startsWith(SOD_SEP) && TextReadDocumentContext.isWhiteSpaceAt(bytes)) {
            this.skipSep(bytes);
        }
        if (bytes.readRemaining() < 1L) {
            this.readLimit = this.readPosition = bytes.readLimit();
            this.notComplete = false;
            return;
        }
        this.start = bytes.readPosition();
        TextReadDocumentContext.consumeToEndOfMessage(bytes);
        this.metaData = false;
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition();
        bytes.readLimit(bytes.readPosition());
        bytes.readPosition(this.start);
        this.present = true;
    }

    protected void skipSep(Bytes<?> bytes) {
        bytes.readSkip(3L);
        this.wire.getValueIn().resetState();
        this.wire.consumePadding();
    }

    @Override
    public void rollbackOnClose() {
        this.rollback = true;
    }

    @Override
    public long index() {
        return 0L;
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }

    public String toString() {
        return this.wire.toString();
    }
}

