/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.shaded.ShadedSerializerAdapter;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphSerializer;

public final class StarGraphGryoSerializer
extends ShadedSerializerAdapter<StarGraph> {
    private static final Map<Direction, StarGraphGryoSerializer> CACHE = new HashMap<Direction, StarGraphGryoSerializer>();

    private StarGraphGryoSerializer(Direction edgeDirectionToSerialize, GraphFilter graphFilter) {
        super(new StarGraphSerializer(edgeDirectionToSerialize, graphFilter));
    }

    private StarGraphGryoSerializer(Direction edgeDirectionToSerialize) {
        this(edgeDirectionToSerialize, new GraphFilter());
    }

    public static StarGraphGryoSerializer with(Direction direction) {
        return CACHE.get((Object)direction);
    }

    public static StarGraphGryoSerializer withGraphFilter(GraphFilter graphFilter) {
        StarGraphGryoSerializer serializer = new StarGraphGryoSerializer(Direction.BOTH, graphFilter.clone());
        return serializer;
    }

    static {
        CACHE.put(Direction.BOTH, new StarGraphGryoSerializer(Direction.BOTH));
        CACHE.put(Direction.IN, new StarGraphGryoSerializer(Direction.IN));
        CACHE.put(Direction.OUT, new StarGraphGryoSerializer(Direction.OUT));
        CACHE.put(null, new StarGraphGryoSerializer(null));
    }
}

