/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class TraversalSourceFactory<T extends TraversalSource>
implements Serializable {
    private final TraversalStrategies traversalStrategies;
    private final Class<T> traversalSourceClass;

    public TraversalSourceFactory(T traversalSource) {
        this.traversalSourceClass = traversalSource.getClass();
        this.traversalStrategies = traversalSource.getStrategies();
    }

    public T createTraversalSource(Graph graph) {
        try {
            return (T)((TraversalSource)this.traversalSourceClass.getConstructor(Graph.class, TraversalStrategies.class).newInstance(graph, this.traversalStrategies));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

