/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.finalization.ComputerFinalizationStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization.GraphFilterStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization.MessagePassingReductionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ConnectiveStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization.ProfileStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.AdjacentToIncidentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ByModulatorOptimizationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.CountStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.EarlyLimitStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.FilterRankingStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IncidentToAdjacentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.LazyBarrierStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.MatchPredicateStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.OrderLimitStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathProcessorStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RepeatUnrollStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.StandardVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalStrategies;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.tools.MultiMap;

public interface TraversalStrategies
extends Serializable,
Cloneable,
Iterable<TraversalStrategy<?>> {
    public static final List<Class<? extends TraversalStrategy>> STRATEGY_CATEGORIES = Collections.unmodifiableList(Arrays.asList(TraversalStrategy.DecorationStrategy.class, TraversalStrategy.OptimizationStrategy.class, TraversalStrategy.ProviderOptimizationStrategy.class, TraversalStrategy.FinalizationStrategy.class, TraversalStrategy.VerificationStrategy.class));

    default public List<TraversalStrategy<?>> toList() {
        return Collections.unmodifiableList(IteratorUtils.list(this.iterator()));
    }

    @Override
    public Iterator<TraversalStrategy<?>> iterator();

    default public <T extends TraversalStrategy> Optional<T> getStrategy(Class<T> traversalStrategyClass) {
        return IteratorUtils.stream(this.iterator()).filter(s -> traversalStrategyClass.isAssignableFrom(s.getClass())).findAny();
    }

    public TraversalStrategies addStrategies(TraversalStrategy<?> ... var1);

    public TraversalStrategies removeStrategies(Class<? extends TraversalStrategy> ... var1);

    public TraversalStrategies clone();

    public static Set<TraversalStrategy<?>> sortStrategies(Set<TraversalStrategy<?>> strategies) {
        HashMap<Class<? extends TraversalStrategy>, Set<Class<? extends TraversalStrategy>>> dependencyMap = new HashMap<Class<? extends TraversalStrategy>, Set<Class<? extends TraversalStrategy>>>();
        HashMap strategiesByCategory = new HashMap();
        HashSet strategyClasses = new HashSet(strategies.size());
        strategies.forEach(s -> {
            strategyClasses.add(s.getClass());
            MultiMap.put(strategiesByCategory, s.getTraversalCategory(), s.getClass());
        });
        strategies.forEach(strategy -> {
            strategy.applyPrior().forEach(s -> {
                if (strategyClasses.contains(s)) {
                    MultiMap.put(dependencyMap, strategy.getClass(), s);
                }
            });
            strategy.applyPost().forEach(s -> {
                if (strategyClasses.contains(s)) {
                    MultiMap.put(dependencyMap, s, strategy.getClass());
                }
            });
        });
        ArrayList<Class> strategiesInPreviousCategories = new ArrayList<Class>();
        for (Class<? extends TraversalStrategy> category : STRATEGY_CATEGORIES) {
            Set<Class> strategiesInThisCategory = MultiMap.get(strategiesByCategory, category);
            for (Class strategy2 : strategiesInThisCategory) {
                for (Class previousStrategy : strategiesInPreviousCategories) {
                    MultiMap.put(dependencyMap, strategy2, previousStrategy);
                }
            }
            strategiesInPreviousCategories.addAll(strategiesInThisCategory);
        }
        ArrayList<Class<? extends TraversalStrategy>> unprocessedStrategyClasses = new ArrayList<Class<? extends TraversalStrategy>>(strategies.stream().map(s -> s.getClass()).collect(Collectors.toSet()));
        ArrayList<Class<? extends TraversalStrategy>> sortedStrategyClasses = new ArrayList<Class<? extends TraversalStrategy>>();
        HashSet<Class<? extends TraversalStrategy>> seenStrategyClasses = new HashSet<Class<? extends TraversalStrategy>>();
        while (!unprocessedStrategyClasses.isEmpty()) {
            Class strategy3 = (Class)unprocessedStrategyClasses.get(0);
            TraversalStrategies.visit(dependencyMap, sortedStrategyClasses, seenStrategyClasses, unprocessedStrategyClasses, strategy3);
        }
        LinkedHashSet sortedStrategies = new LinkedHashSet();
        for (Class clazz : sortedStrategyClasses) {
            for (TraversalStrategy<?> strategy4 : strategies) {
                if (!strategy4.getClass().equals(clazz)) continue;
                sortedStrategies.add(strategy4);
            }
        }
        return sortedStrategies;
    }

    public static void visit(Map<Class<? extends TraversalStrategy>, Set<Class<? extends TraversalStrategy>>> dependencyMap, List<Class<? extends TraversalStrategy>> sortedStrategyClasses, Set<Class<? extends TraversalStrategy>> seenStrategyClases, List<Class<? extends TraversalStrategy>> unprocessedStrategyClasses, Class<? extends TraversalStrategy> strategyClass) {
        if (seenStrategyClases.contains(strategyClass)) {
            throw new IllegalStateException("Cyclic dependency between traversal strategies: [" + seenStrategyClases + ']');
        }
        if (unprocessedStrategyClasses.contains(strategyClass)) {
            seenStrategyClases.add(strategyClass);
            for (Class<? extends TraversalStrategy> dependency : MultiMap.get(dependencyMap, strategyClass)) {
                TraversalStrategies.visit(dependencyMap, sortedStrategyClasses, seenStrategyClases, unprocessedStrategyClasses, dependency);
            }
            seenStrategyClases.remove(strategyClass);
            unprocessedStrategyClasses.remove(strategyClass);
            sortedStrategyClasses.add(strategyClass);
        }
    }

    public static final class GlobalCache {
        private static final Set<Class<?>> LOADED = ConcurrentHashMap.newKeySet();
        private static final Map<Class<? extends Graph>, TraversalStrategies> GRAPH_CACHE = new HashMap<Class<? extends Graph>, TraversalStrategies>();
        private static final Map<Class<? extends GraphComputer>, TraversalStrategies> GRAPH_COMPUTER_CACHE = new HashMap<Class<? extends GraphComputer>, TraversalStrategies>();

        public static void registerStrategies(Class graphOrGraphComputerClass, TraversalStrategies traversalStrategies) {
            if (Graph.class.isAssignableFrom(graphOrGraphComputerClass)) {
                GRAPH_CACHE.put(graphOrGraphComputerClass, traversalStrategies);
            } else if (GraphComputer.class.isAssignableFrom(graphOrGraphComputerClass)) {
                GRAPH_COMPUTER_CACHE.put(graphOrGraphComputerClass, traversalStrategies);
            } else {
                throw new IllegalArgumentException("The TraversalStrategies.GlobalCache only supports Graph and GraphComputer strategy caching: " + graphOrGraphComputerClass.getCanonicalName());
            }
        }

        public static TraversalStrategies getStrategies(Class graphOrGraphComputerClass) {
            try {
                if (!LOADED.contains(graphOrGraphComputerClass)) {
                    String graphComputerClassName = null != graphOrGraphComputerClass.getDeclaringClass() ? graphOrGraphComputerClass.getCanonicalName().replace("." + graphOrGraphComputerClass.getSimpleName(), "$" + graphOrGraphComputerClass.getSimpleName()) : graphOrGraphComputerClass.getCanonicalName();
                    Class.forName(graphComputerClassName);
                    LOADED.add(graphOrGraphComputerClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            if (GRAPH_CACHE.containsKey(graphOrGraphComputerClass)) {
                return GRAPH_CACHE.get(graphOrGraphComputerClass);
            }
            if (Graph.class.isAssignableFrom(graphOrGraphComputerClass)) {
                return GRAPH_CACHE.get(Graph.class);
            }
            if (GRAPH_COMPUTER_CACHE.containsKey(graphOrGraphComputerClass)) {
                return GRAPH_COMPUTER_CACHE.get(graphOrGraphComputerClass);
            }
            if (GraphComputer.class.isAssignableFrom(graphOrGraphComputerClass)) {
                return GRAPH_COMPUTER_CACHE.get(GraphComputer.class);
            }
            throw new IllegalArgumentException("The TraversalStrategies.GlobalCache only supports Graph and GraphComputer strategy caching: " + graphOrGraphComputerClass.getCanonicalName());
        }

        static {
            DefaultTraversalStrategies graphStrategies = new DefaultTraversalStrategies();
            graphStrategies.addStrategies(IdentityRemovalStrategy.instance(), ConnectiveStrategy.instance(), EarlyLimitStrategy.instance(), InlineFilterStrategy.instance(), IncidentToAdjacentStrategy.instance(), AdjacentToIncidentStrategy.instance(), ByModulatorOptimizationStrategy.instance(), FilterRankingStrategy.instance(), MatchPredicateStrategy.instance(), RepeatUnrollStrategy.instance(), CountStrategy.instance(), PathRetractionStrategy.instance(), LazyBarrierStrategy.instance(), ProfileStrategy.instance(), StandardVerificationStrategy.instance());
            GRAPH_CACHE.put(Graph.class, graphStrategies);
            GRAPH_CACHE.put(EmptyGraph.class, new DefaultTraversalStrategies());
            DefaultTraversalStrategies graphComputerStrategies = new DefaultTraversalStrategies();
            graphComputerStrategies.addStrategies(GraphFilterStrategy.instance(), MessagePassingReductionStrategy.instance(), OrderLimitStrategy.instance(), PathProcessorStrategy.instance(), ComputerFinalizationStrategy.instance(), ComputerVerificationStrategy.instance());
            GRAPH_COMPUTER_CACHE.put(GraphComputer.class, graphComputerStrategies);
        }
    }
}

