/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.MemoryHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class MapMemory
implements Memory.Admin,
Serializable {
    private long runtime = 0L;
    private int iteration = -1;
    private final Map<String, Object> memoryMap = new HashMap<String, Object>();
    private final Map<String, MemoryComputeKey> memoryComputeKeys = new HashMap<String, MemoryComputeKey>();

    public MapMemory() {
    }

    public MapMemory(Memory otherMemory) {
        otherMemory.keys().forEach(key -> this.memoryMap.put((String)key, otherMemory.get((String)key)));
        this.iteration = otherMemory.getIteration();
    }

    public void addVertexProgramMemoryComputeKeys(VertexProgram<?> vertexProgram) {
        vertexProgram.getMemoryComputeKeys().forEach(key -> this.memoryComputeKeys.put(key.getKey(), (MemoryComputeKey)key));
    }

    public void addMapReduceMemoryKey(MapReduce mapReduce) {
        this.memoryComputeKeys.put(mapReduce.getMemoryKey(), MemoryComputeKey.of(mapReduce.getMemoryKey(), Operator.assign, false, false));
    }

    @Override
    public Set<String> keys() {
        return this.memoryMap.keySet();
    }

    @Override
    public <R> R get(String key) throws IllegalArgumentException {
        Object r = this.memoryMap.get(key);
        if (null == r) {
            throw Memory.Exceptions.memoryDoesNotExist(key);
        }
        return (R)r;
    }

    @Override
    public void set(String key, Object value) {
        this.memoryMap.put(key, value);
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public long getRuntime() {
        return this.runtime;
    }

    @Override
    public void add(String key, Object value) {
        this.checkKeyValue(key, value);
        if (this.memoryMap.containsKey(key)) {
            Object newValue = this.memoryComputeKeys.get(key).getReducer().apply(this.memoryMap.get(key), value);
            this.memoryMap.put(key, newValue);
        } else {
            this.memoryMap.put(key, value);
        }
    }

    public String toString() {
        return StringFactory.memoryString(this);
    }

    @Override
    public void incrIteration() {
        ++this.iteration;
    }

    @Override
    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    @Override
    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    private final void checkKeyValue(String key, Object value) {
        if (!this.memoryComputeKeys.containsKey(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey(key);
        }
        MemoryHelper.validateValue(value);
    }
}

