/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.IOException;
import java.util.LinkedList;
import org.lionsoul.jcseg.IChunk;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.ComplexSeg;
import org.lionsoul.jcseg.segmenter.Entity;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;
import org.lionsoul.jcseg.util.ArrayUtil;
import org.lionsoul.jcseg.util.ByteCharCounter;
import org.lionsoul.jcseg.util.EntityFormat;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.NumericUtil;
import org.lionsoul.jcseg.util.StringUtil;
import org.lionsoul.jcseg.util.TimeUtil;

public class NLPSeg
extends ComplexSeg {
    private static final long serialVersionUID = -8686944894332423915L;
    private final LinkedList<IWord> eWordPool = new LinkedList();
    private final IStringBuffer buffer = new IStringBuffer(64);

    public NLPSeg(SegmenterConfig config, ADictionary dic) {
        super(config, dic);
        config.APPEND_CJK_PINYIN = false;
        config.APPEND_CJK_SYN = false;
        config.MAX_LATIN_LENGTH = 128;
    }

    @Override
    public IWord next() throws IOException {
        IWord dWord;
        IWord dWord2;
        if (this.eWordPool.size() > 0) {
            return this.eWordPool.removeFirst();
        }
        IWord word = super.next();
        if (word == null) {
            return null;
        }
        String[] entity = word.getEntity();
        if (entity == null && word.getValue().charAt(0) == '\u7b2c' && (dWord2 = this.getNextTheWord(word)) != null) {
            dWord2.setPartSpeechForNull(IWord.QUANTIFIER);
            return dWord2;
        }
        if (entity == null) {
            return word;
        }
        int eIdx = 0;
        eIdx = ArrayUtil.startsWith("time.a", entity);
        if ((eIdx > -1 || (eIdx = ArrayUtil.startsWith("datetime.", entity)) > -1) && (dWord = this.getNextTimeMergedWord(word, eIdx)) != null) {
            return dWord;
        }
        eIdx = ArrayUtil.startsWith("datetime.ymd", entity);
        if (eIdx > -1 && (dWord = this.getNextDatetimeWord(word, eIdx)) != null) {
            return dWord;
        }
        return word;
    }

    private IWord _internalNext() throws IOException {
        return this.eWordPool.size() > 0 ? this.eWordPool.removeFirst() : super.next();
    }

    protected IWord getNextTheWord(IWord word) throws IOException {
        String wVal = word.getValue();
        int wLen = word.getValue().length();
        IWord dWord = null;
        if (wLen == 1) {
            return this._nextNumberWord(word);
        }
        if (wLen == 2) {
            if (NumericUtil.isCNNumeric(wVal.charAt(1)) == -1 && !StringUtil.isEnNumeric(wVal.charAt(1))) {
                return null;
            }
            word.addEntity("the_number");
            return this._nextNumberWord(word);
        }
        IWord unit = this.dic.get(10, "" + wVal.charAt(wLen - 1));
        if (unit != null) {
            if (!NumericUtil.isCNNumericString(wVal, 1, wLen - 1) && !StringUtil.isDigit(wVal, 1, wLen - 1)) {
                return null;
            }
            dWord = word;
            dWord.setEntity(unit.getEntity());
            return dWord;
        }
        if (!NumericUtil.isCNNumericString(wVal, 1, wLen) && !StringUtil.isDigit(wVal, 1, wLen)) {
            return null;
        }
        word.addEntity("the_number");
        return this._nextNumberWord(word);
    }

    private IWord _nextNumberWord(IWord word) throws IOException {
        Word dWord = null;
        IWord unit = null;
        IWord dw1 = this._internalNext();
        if (dw1 == null) {
            return null;
        }
        String[] w1Entity = dw1.getEntity();
        int w1Len = dw1.getValue().length();
        if (ArrayUtil.indexOf("numeric.integer", w1Entity) > -1) {
            IWord dw2 = this._internalNext();
            if (dw2 == null) {
                dWord = new Word(word.getValue() + dw1.getValue(), 1);
                dWord.setPosition(word.getPosition());
                dWord.setEntity(Entity.E_THE_NUMBER_A);
                return dWord;
            }
            int w2Len = dw2.getValue().length();
            unit = this.dic.get(10, "" + dw2.getValue().charAt(0));
            if (unit != null) {
                String w2Val = dw2.getValue();
                if (w2Len == 1 || NumericUtil.isCNNumericString(w2Val, 0, w2Len - 1) || StringUtil.isDigit(w2Val, 0, w2Len - 1)) {
                    dWord = new Word(word.getValue() + dw1.getValue() + w2Val, 1);
                    dWord.setPosition(word.getPosition());
                    dWord.setEntity(unit.getEntity());
                    return dWord;
                }
            }
            this.eWordPool.push(dw2);
            dWord = new Word(word.getValue() + dw1.getValue(), 1);
            dWord.setPosition(word.getPosition());
            dWord.setEntity(Entity.E_THE_NUMBER_A);
            return dWord;
        }
        unit = this.dic.get(10, "" + dw1.getValue().charAt(w1Len - 1));
        if (unit != null) {
            String w1Val = dw1.getValue();
            if (w1Len == 1 || NumericUtil.isCNNumericString(w1Val, 0, w1Len - 1) || StringUtil.isDigit(w1Val, 0, w1Len - 1)) {
                dWord = new Word(word.getValue() + w1Val, 1);
                dWord.setPosition(word.getPosition());
                dWord.setEntity(unit.getEntity());
                return dWord;
            }
        }
        this.eWordPool.push(dw1);
        return null;
    }

    protected IWord getNextTimeMergedWord(IWord word, int eIdx) throws IOException {
        int i;
        int pIdx = TimeUtil.getDateTimeIndex(word.getEntity(eIdx));
        if (pIdx == -1) {
            return null;
        }
        IWord[] wMask = TimeUtil.createDateTimePool();
        TimeUtil.fillDateTimePool(wMask, pIdx, word);
        IWord dWord = null;
        int mergedNum = 0;
        while ((dWord = this._internalNext()) != null) {
            String[] entity = dWord.getEntity();
            if (entity == null) {
                this.eWordPool.push(dWord);
                break;
            }
            if (ArrayUtil.startsWith("time.a", entity) > -1) {
                if (-1 == TimeUtil.fillDateTimePool(wMask, dWord)) {
                    this.eWordPool.push(dWord);
                    break;
                }
            } else if (ArrayUtil.startsWith("datetime.hi", entity) > -1) {
                TimeUtil.fillTimeToPool(wMask, dWord.getValue());
            } else if (ArrayUtil.startsWith("datetime.", entity) > -1) {
                int tIdx = TimeUtil.fillDateTimePool(wMask, dWord);
                if (tIdx == -1 || wMask[tIdx] == null) {
                    this.eWordPool.push(dWord);
                    break;
                }
            } else {
                this.eWordPool.push(dWord);
                break;
            }
            ++mergedNum;
        }
        if (mergedNum == 0) {
            return null;
        }
        this.buffer.clear();
        for (i = 0; i < wMask.length; ++i) {
            if (wMask[i] == null) continue;
            if (this.buffer.length() > 0 && i < wMask.length) {
                this.buffer.append(' ');
            }
            this.buffer.append(wMask[i].getValue());
        }
        dWord = new Word(this.buffer.toString(), 5);
        dWord.setPosition(word.getPosition());
        dWord.setPartSpeechForNull(IWord.TIME_POSPEECH);
        this.buffer.clear().append("datetime.");
        for (i = 0; i < wMask.length; ++i) {
            if (wMask[i] == null) continue;
            this.buffer.append(TimeUtil.getTimeKey(wMask[i]));
        }
        dWord.setEntity(new String[]{this.buffer.toString()});
        return dWord;
    }

    protected IWord getNextDatetimeWord(IWord word, int entityIdx) throws IOException {
        IWord dWord = this._internalNext();
        if (dWord == null) {
            return null;
        }
        String[] entity = dWord.getEntity();
        if (entity == null) {
            this.eWordPool.add(dWord);
            return null;
        }
        int eIdx = 0;
        eIdx = ArrayUtil.startsWith("datetime.h", entity);
        if (eIdx <= -1) {
            eIdx = ArrayUtil.startsWith("time.a", entity);
            if (eIdx > -1 || (eIdx = ArrayUtil.startsWith("datetime.", entity)) > -1) {
                IWord mWord = this.getNextTimeMergedWord(dWord, eIdx);
                if (mWord == null) {
                    this.eWordPool.addFirst(dWord);
                    return null;
                }
                String mEntity = mWord.getEntity(0);
                if (!mEntity.contains(".h") && !mEntity.contains(".a")) {
                    this.eWordPool.addFirst(mWord);
                    return null;
                }
                eIdx = 0;
                dWord = mWord;
                entity = dWord.getEntity();
            } else {
                this.eWordPool.add(dWord);
                return null;
            }
        }
        this.buffer.clear().append(word.getValue()).append(' ').append(dWord.getValue());
        dWord = new Word(this.buffer.toString(), 5);
        dWord.setPosition(word.getPosition());
        dWord.setPartSpeechForNull(IWord.TIME_POSPEECH);
        int sIdx = 9;
        this.buffer.clear().append(word.getEntity(0)).append(entity[eIdx].substring(sIdx));
        dWord.addEntity(this.buffer.toString());
        return dWord;
    }

    private IWord getNumericUnitComposedWord(String numeric, IWord unitWord) {
        IStringBuffer sb = new IStringBuffer();
        sb.clear().append(numeric).append(unitWord.getValue());
        Word wd = new Word(sb.toString(), 1);
        String[] entity = unitWord.getEntity();
        int eIdx = ArrayUtil.startsWith("time.", entity);
        if (eIdx > -1) {
            sb.clear().append(entity[eIdx].replace("time.", "datetime."));
        } else {
            sb.clear().append("nuc_").append(unitWord.getEntity(0));
        }
        wd.setEntity(new String[]{sb.toString()});
        wd.setPartSpeechForNull(IWord.QUANTIFIER);
        sb.clear();
        sb = null;
        return wd;
    }

    public IWord getNumericUnitComposedWord(int numeric, IWord unitWord) {
        return this.getNumericUnitComposedWord(String.valueOf(numeric), unitWord);
    }

    @Override
    protected IWord getNextCJKWord(int c, int pos) throws IOException {
        char[] chars = this.nextCJKSentence(c);
        int cjkidx = 0;
        IWord w = null;
        while (cjkidx < chars.length) {
            w = null;
            int numVal = NumericUtil.isCNNumeric(chars[cjkidx]);
            if (numVal > -1) {
                IWord unitWord = null;
                int wordLen = -1;
                String num = this.nextCNNumeric(chars, cjkidx);
                if ((this.ctrlMask & 2) != 0) {
                    if (this.config.CNFRA_TO_ARABIC) {
                        String[] split = num.split("\u5206\u4e4b");
                        w = new Word(NumericUtil.cnNumericToArabic(split[1], true) + "/" + NumericUtil.cnNumericToArabic(split[0], true), 9, Entity.E_NUMERIC_FRACTION_A);
                        w.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                    } else {
                        w = new Word(num, 9, Entity.E_NUMERIC_CN_FRACTION_A);
                        w.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                    }
                } else {
                    String temp = null;
                    IStringBuffer sb = new IStringBuffer();
                    if (numVal <= 10) {
                        int j = num.length();
                        for (int i = 0; cjkidx + j < chars.length && i < this.config.MAX_UNIT_LENGTH; ++i) {
                            sb.append(chars[cjkidx + j]);
                            temp = sb.toString();
                            if (this.dic.match(1, temp)) {
                                unitWord = this.dic.get(1, temp);
                            }
                            ++j;
                        }
                    }
                    IWord mmwd = null;
                    sb.clear().append(num);
                    for (int j = num.length(); cjkidx + j < chars.length && j < this.config.MAX_LENGTH; ++j) {
                        sb.append(chars[cjkidx + j]);
                        temp = sb.toString();
                        if (!this.dic.match(0, temp)) continue;
                        mmwd = this.dic.get(0, temp);
                    }
                    if (mmwd == null) {
                        if (unitWord == null) {
                            if (this.config.CNNUM_TO_ARABIC) {
                                w = new Word(String.valueOf(NumericUtil.cnNumericToArabic(num, true)), 9);
                                w.setEntity(Entity.E_NUMERIC_ARABIC_A);
                                w.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                                wordLen = num.length();
                            } else {
                                w = new Word(num, 9);
                                w.setEntity(Entity.E_NUMERIC_CN_A);
                                w.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                            }
                        } else if (this.config.CNNUM_TO_ARABIC) {
                            w = this.getNumericUnitComposedWord(NumericUtil.cnNumericToArabic(num, true), unitWord);
                            wordLen = num.length() + unitWord.getLength();
                        } else {
                            w = this.getNumericUnitComposedWord(num, unitWord);
                        }
                    } else if (unitWord == null) {
                        w = mmwd.clone();
                    } else if (mmwd.getLength() > num.length() + unitWord.getLength()) {
                        w = mmwd.clone();
                    } else if (this.config.CNNUM_TO_ARABIC) {
                        w = this.getNumericUnitComposedWord(NumericUtil.cnNumericToArabic(num, true), unitWord);
                        wordLen = num.length() + unitWord.getLength();
                    } else {
                        w = this.getNumericUnitComposedWord(num, unitWord);
                    }
                }
                this.wordPool.add(w);
                w.setPosition(pos + cjkidx);
                cjkidx += wordLen > 0 ? wordLen : w.getLength();
                continue;
            }
            IChunk chunk = this.getBestChunk(chars, cjkidx, this.config.MAX_LENGTH);
            w = chunk.getWords()[0];
            int T = -1;
            if (this.config.I_CN_NAME && w.getLength() <= 2 && chunk.getWords().length > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append(w.getValue());
                String str = null;
                if (this.dic.match(2, w.getValue()) && (str = this.findCHName(chars, 0, chunk)) != null) {
                    T = 3;
                    sb.append(str);
                } else if (this.dic.match(6, w.getValue()) && chunk.getWords()[1].getLength() <= 2 && this.dic.match(2, chunk.getWords()[1].getValue())) {
                    T = 4;
                    sb.append(chunk.getWords()[1].getValue());
                }
                if (T != -1) {
                    w = new Word(sb.toString(), T);
                    w.addEntity(T == 4 ? "name.nickname" : "name.cn");
                    w.setPartSpeechForNull(IWord.NAME_POSPEECH);
                }
            }
            if (this.config.CLEAR_STOPWORD && this.dic.match(7, w.getValue())) {
                cjkidx += w.getLength();
                continue;
            }
            IWord ce = null;
            if ((this.ctrlMask & 1) != 0 && chars.length - cjkidx <= this.dic.mixPrefixLength) {
                ce = this.getNextMixedWord(chars, cjkidx);
            }
            if (ce == null) {
                if (T == -1) {
                    w = w.clone();
                }
            } else {
                w = ce.clone();
            }
            w.setPosition(pos + cjkidx);
            this.wordPool.add(w);
            cjkidx += w.getLength();
            if (T != -1) continue;
            this.appendCJKWordFeatures(w);
        }
        if (this.wordPool.size() == 0) {
            return null;
        }
        return (IWord)this.wordPool.remove();
    }

    @Override
    protected boolean enSecondSegFilter(IWord w) {
        return false;
    }

    @Override
    protected IWord nextLatinWord(int c, int pos) throws IOException {
        int j;
        int ch;
        this.isb.clear();
        if (c > 65280) {
            c -= 65248;
        }
        if (c >= 65 && c <= 90) {
            c += 32;
        }
        this.isb.append((char)c);
        boolean _check = false;
        boolean _wspace = false;
        ByteCharCounter counter = new ByteCharCounter();
        int _ctype = 0;
        int tcount = 1;
        int _TYPE = StringUtil.getEnCharType(c);
        while ((ch = this.readNext()) != -1) {
            if (ch > 65280) {
                ch -= 65248;
            }
            if ((_ctype = StringUtil.getEnCharType(ch)) == 3) {
                _wspace = true;
                break;
            }
            if (_ctype == 2) {
                if (!StringUtil.isENKeepPunctuaton((char)ch)) {
                    this.pushBack(ch);
                    break;
                }
                counter.increase((char)ch);
            }
            if (_ctype == -1) {
                this.pushBack(ch);
                if (!StringUtil.isCJKChar(ch)) break;
                _check = true;
                break;
            }
            if (ch >= 65 && ch <= 90) {
                ch += 32;
            }
            if (ch > 0) {
                this.isb.append((char)ch);
            }
            if (_ctype != _TYPE) {
                ++tcount;
                _TYPE = _ctype;
            }
            if (this.isb.length() <= this.config.MAX_LATIN_LENGTH) continue;
        }
        int oLen = this.isb.length();
        for (int i = oLen - 1; i > 0 && StringUtil.isNoTailingPunctuation(this.isb.charAt(i)); --i) {
            this.pushBack(this.isb.charAt(i));
            this.isb.deleteCharAt(i);
            _check = false;
        }
        if (oLen > this.isb.length() && !StringUtil.isEnPunctuation(this.isb.last())) {
            --tcount;
        }
        IWord wd = null;
        String str = this.isb.toString();
        String date = null;
        int colonNum = counter.get(':');
        int pointNum = counter.get('.');
        if (counter.get('@') == 1 && pointNum > 0 && EntityFormat.isMailAddress(str)) {
            wd = new Word(str, 5, Entity.E_EMAIL_A);
            wd.setPartSpeechForNull(IWord.EN_POSPEECH);
            return wd;
        }
        if (tcount == 1 && StringUtil.isEnNumeric(this.isb.first()) && EntityFormat.isMobileNumber(str)) {
            wd = new Word(str, 5, Entity.E_MOBILE_A);
            wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
            return wd;
        }
        if (tcount == 7 && pointNum == 3 && StringUtil.isEnNumeric(this.isb.first()) && EntityFormat.isIpAddress(str)) {
            wd = new Word(str, 5, Entity.E_IP_A);
            wd.setPartSpeechForNull(IWord.EN_POSPEECH);
            return wd;
        }
        if (pointNum > 0 && colonNum == 1 && EntityFormat.isUrlAddress(str, this.dic)) {
            wd = new Word(str, 5, Entity.E_URL_A);
            wd.setPartSpeechForNull(IWord.EN_POSPEECH);
            return wd;
        }
        if (pointNum == 2 && (date = EntityFormat.isDate(str, '.')) != null) {
            wd = new Word(date, 5, Entity.E_DATETIME_YMD_A);
            wd.setPartSpeechForNull(IWord.TIME_POSPEECH);
            return wd;
        }
        if (counter.get('-') >= 1 && (date = EntityFormat.isDate(str, '-')) != null) {
            String[] entity = counter.get('-') == 1 ? Entity.E_DATETIME_YM_A : Entity.E_DATETIME_YMD_A;
            wd = new Word(date, 5, entity);
            wd.setPartSpeechForNull(IWord.TIME_POSPEECH);
            return wd;
        }
        if (counter.get('/') >= 1 && (date = EntityFormat.isDate(str, '/')) != null) {
            String[] entity = counter.get('/') == 1 ? Entity.E_DATETIME_YM_A : Entity.E_DATETIME_YMD_A;
            wd = new Word(date, 5, entity);
            wd.setPartSpeechForNull(IWord.TIME_POSPEECH);
            return wd;
        }
        if ((tcount == 3 || tcount == 5) && colonNum >= 1 && EntityFormat.isTime(str)) {
            String[] entity = colonNum == 1 ? Entity.E_DATETIME_HI_A : Entity.E_DATETIME_HIS_A;
            wd = new Word(str, 5, entity);
            wd.setPartSpeechForNull(IWord.TIME_POSPEECH);
            return wd;
        }
        if (ch == -1 || _wspace) {
            boolean isPercentage = false;
            for (int i = this.isb.length() - 1; i > 0; --i) {
                if (this.isb.charAt(i) == '%') {
                    if (i > 0 && StringUtil.isEnNumeric(this.isb.charAt(i - 1))) {
                        isPercentage = true;
                        break;
                    }
                } else if (!StringUtil.isEnPunctuation(this.isb.charAt(i))) break;
                if (this.dic.match(0, str)) {
                    wd = this.dic.get(0, str).clone();
                    break;
                }
                this.pushBack(this.isb.charAt(i));
                this.isb.deleteCharAt(i);
                str = this.isb.toString();
            }
            if (wd == null) {
                if (isPercentage) {
                    wd = new Word(str, 5, Entity.E_NUMERIC_PERCENTAGE_A);
                    wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                } else if (tcount == 1 && StringUtil.isDigit(str)) {
                    wd = new Word(str, 5, Entity.E_NUMERIC_ARABIC_A);
                    wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                } else if (tcount == 3 && StringUtil.isDecimal(str)) {
                    wd = new Word(str, 5, Entity.E_NUMERIC_DECIMAL_A);
                    wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                } else if (this.dic.match(0, str)) {
                    wd = this.dic.get(0, str).clone();
                } else {
                    wd = this.wordNewOrClone(0, str, 5);
                    wd.setPartSpeechForNull(IWord.EN_POSPEECH);
                }
            }
            if (wd.getPartSpeech() == null) {
                wd.setPartSpeechForNull(IWord.EN_POSPEECH);
            }
            return wd;
        }
        if (!_check) {
            boolean isDigit = StringUtil.isDigit(str);
            if (isDigit || StringUtil.isDecimal(str)) {
                ch = this.readNext();
                String unit = (char)ch + "";
                if (this.dic.match(1, unit)) {
                    wd = this.getNumericUnitComposedWord(str, this.dic.get(1, unit));
                } else {
                    String[] entity = isDigit ? Entity.E_NUMERIC_ARABIC_A : Entity.E_NUMERIC_DECIMAL_A;
                    wd = new Word(str, 5, entity);
                    wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
                    this.pushBack(ch);
                }
            }
            if (wd == null) {
                wd = this.dic.match(0, str) ? this.dic.get(0, str).clone() : new Word(str, 5);
            }
            if (wd.getPartSpeech() == null) {
                wd.setPartSpeechForNull(IWord.EN_POSPEECH);
            }
            return wd;
        }
        int length = this.isb.length();
        if (length > 1 && this.isb.charAt(length - 1) == '%' && StringUtil.isEnNumeric(this.isb.charAt(length - 2))) {
            wd = new Word(str, 5, Entity.E_NUMERIC_PERCENTAGE_A);
            wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
            return wd;
        }
        IStringBuffer ibuffer = new IStringBuffer(str);
        String tstr = null;
        int mc = 0;
        this.ialist.clear();
        for (j = 0; j < this.dic.mixSuffixLength && ibuffer.length() < this.config.MAX_LENGTH && (ch = this.readNext()) != -1; ++j) {
            if (StringUtil.isWhitespace(ch)) {
                this.pushBack(ch);
                break;
            }
            ibuffer.append((char)ch);
            this.ialist.add(ch);
            tstr = ibuffer.toString();
            if (!this.dic.match(0, tstr)) continue;
            wd = this.dic.get(0, tstr);
            mc = j + 1;
        }
        ibuffer.clear();
        ibuffer = null;
        for (int i = j - 1; i >= mc; --i) {
            this.pushBack(this.ialist.get(i));
        }
        if (wd != null) {
            if ((wd = wd.clone()).getPartSpeech() == null) {
                wd.setPartSpeechForNull(IWord.MIX_POSPEECH);
            }
            return wd;
        }
        boolean isDigit = StringUtil.isDigit(str);
        if (isDigit || StringUtil.isDecimal(str)) {
            this.ialist.clear();
            IWord unitWord = null;
            IStringBuffer sb = new IStringBuffer();
            for (j = 0; j < this.config.MAX_UNIT_LENGTH && (ch = this.readNext()) != -1; ++j) {
                if (StringUtil.isWhitespace(ch)) {
                    this.pushBack(ch);
                    break;
                }
                sb.append((char)ch);
                this.ialist.add(ch);
                tstr = sb.toString();
                if (!this.dic.match(1, tstr)) continue;
                unitWord = this.dic.get(1, tstr);
                mc = j + 1;
            }
            if (unitWord == null) {
                String[] entity = isDigit ? Entity.E_NUMERIC_ARABIC_A : Entity.E_NUMERIC_DECIMAL_A;
                wd = new Word(str, 5, entity);
                wd.setPartSpeechForNull(IWord.NUMERIC_POSPEECH);
            } else {
                wd = this.getNumericUnitComposedWord(str, unitWord);
            }
            for (int i = j - 1; i >= mc; --i) {
                this.pushBack(this.ialist.get(i));
            }
        }
        if (wd == null && (wd = this.dic.match(0, str) ? this.dic.get(0, str).clone() : new Word(str, 5)).getPartSpeech() == null) {
            wd.setPartSpeechForNull(IWord.EN_POSPEECH);
        }
        return wd;
    }
}

