/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import com.codahale.metrics.Meter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.define.UpdateStrategy;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.server.RestServer;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.slf4j.Logger;

public class BatchAPI
extends API {
    private static final Logger LOG = Log.logger(BatchAPI.class);
    private static final AtomicInteger BATCH_WRITE_THREADS = new AtomicInteger(0);
    private final Meter batchMeter = MetricsUtil.registerMeter(this.getClass(), "batch-commit");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R commit(HugeConfig config, HugeGraph g, int size, Callable<R> callable) {
        int maxWriteThreads = (Integer)config.get(ServerOptions.MAX_WRITE_THREADS);
        int writingThreads = BATCH_WRITE_THREADS.incrementAndGet();
        if (writingThreads > maxWriteThreads) {
            BATCH_WRITE_THREADS.decrementAndGet();
            throw new HugeException("The rest server is too busy to write");
        }
        LOG.debug("The batch writing threads is {}", (Object)BATCH_WRITE_THREADS);
        try {
            R result = BatchAPI.commit(g, callable);
            this.batchMeter.mark((long)size);
            R r = result;
            return r;
        }
        finally {
            BATCH_WRITE_THREADS.decrementAndGet();
        }
    }

    protected void updateExistElement(JsonElement oldElement, JsonElement newElement, Map<String, UpdateStrategy> strategies) {
        if (oldElement == null) {
            return;
        }
        E.checkArgument((newElement != null ? 1 : 0) != 0, (String)"The json element can't be null", (Object[])new Object[0]);
        for (Map.Entry<String, UpdateStrategy> kv : strategies.entrySet()) {
            String key = kv.getKey();
            UpdateStrategy updateStrategy = kv.getValue();
            if (oldElement.properties.get(key) != null && newElement.properties.get(key) != null) {
                Object value = updateStrategy.checkAndUpdateProperty(oldElement.properties.get(key), newElement.properties.get(key));
                newElement.properties.put(key, value);
                continue;
            }
            if (oldElement.properties.get(key) == null || newElement.properties.get(key) != null) continue;
            newElement.properties.put(key, oldElement.properties.get(key));
        }
    }

    protected void updateExistElement(HugeGraph g, Element oldElement, JsonElement newElement, Map<String, UpdateStrategy> strategies) {
        if (oldElement == null) {
            return;
        }
        E.checkArgument((newElement != null ? 1 : 0) != 0, (String)"The json element can't be null", (Object[])new Object[0]);
        for (Map.Entry<String, UpdateStrategy> kv : strategies.entrySet()) {
            String key = kv.getKey();
            UpdateStrategy updateStrategy = kv.getValue();
            if (oldElement.property(key).isPresent() && newElement.properties.get(key) != null) {
                Object value = updateStrategy.checkAndUpdateProperty(oldElement.property(key).value(), newElement.properties.get(key));
                value = g.propertyKey(key).validValueOrThrow(value);
                newElement.properties.put(key, value);
                continue;
            }
            if (!oldElement.property(key).isPresent() || newElement.properties.get(key) != null) continue;
            newElement.properties.put(key, oldElement.value(key));
        }
    }

    protected static void updateProperties(HugeElement element, JsonElement jsonElement, boolean append) {
        for (Map.Entry<String, Object> e : jsonElement.properties.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (append) {
                element.property(key, value);
                continue;
            }
            element.property(key).remove();
        }
    }

    static {
        MetricsUtil.registerGauge(RestServer.class, "batch-write-threads", () -> BATCH_WRITE_THREADS.intValue());
    }

    @JsonIgnoreProperties(value={"type"})
    protected static abstract class JsonElement
    implements Checkable {
        @JsonProperty(value="id")
        public Object id;
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;
        @JsonProperty(value="type")
        public String type;

        protected JsonElement() {
        }

        @Override
        public abstract void checkCreate(boolean var1);

        @Override
        public abstract void checkUpdate();

        protected abstract Object[] properties();
    }
}

