/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.codec;

import com.alipay.remoting.Connection;
import com.alipay.remoting.Protocol;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.ProtocolManager;
import com.alipay.remoting.codec.AbstractBatchDecoder;
import com.alipay.remoting.exception.CodecException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;

public class ProtocolCodeBasedDecoder
extends AbstractBatchDecoder {
    public static final int DEFAULT_PROTOCOL_VERSION_LENGTH = 1;
    public static final int DEFAULT_ILLEGAL_PROTOCOL_VERSION_LENGTH = -1;
    protected int protocolCodeLength;

    public ProtocolCodeBasedDecoder(int protocolCodeLength) {
        this.protocolCodeLength = protocolCodeLength;
    }

    protected ProtocolCode decodeProtocolCode(ByteBuf in) {
        if (in.readableBytes() >= this.protocolCodeLength) {
            byte[] protocolCodeBytes = new byte[this.protocolCodeLength];
            in.readBytes(protocolCodeBytes);
            return ProtocolCode.fromBytes(protocolCodeBytes);
        }
        return null;
    }

    protected byte decodeProtocolVersion(ByteBuf in) {
        if (in.readableBytes() >= 1) {
            return in.readByte();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Protocol protocol;
        ProtocolCode protocolCode;
        in.markReaderIndex();
        try {
            protocolCode = this.decodeProtocolCode(in);
            if (protocolCode == null) {
                return;
            }
            byte protocolVersion = this.decodeProtocolVersion(in);
            if (ctx.channel().attr(Connection.PROTOCOL).get() == null) {
                ctx.channel().attr(Connection.PROTOCOL).set((Object)protocolCode);
                if (-1 != protocolVersion) {
                    ctx.channel().attr(Connection.VERSION).set((Object)protocolVersion);
                }
            }
            protocol = ProtocolManager.getProtocol(protocolCode);
        }
        finally {
            in.resetReaderIndex();
        }
        if (protocol == null) {
            throw new CodecException("Unknown protocol code: [" + protocolCode + "] while decode in ProtocolDecoder.");
        }
        protocol.getDecoder().decode(ctx, in, out);
    }
}

