/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.tx.SchemaTransaction;
import org.apache.hugegraph.exception.ExistedException;
import org.apache.hugegraph.exception.NotAllowException;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.schema.builder.AbstractBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;

public class VertexLabelBuilder
extends AbstractBuilder
implements VertexLabel.Builder {
    private Id id;
    private String name;
    private IdStrategy idStrategy;
    private Set<String> properties;
    private List<String> primaryKeys;
    private Set<String> nullableKeys;
    private long ttl;
    private String ttlStartTime;
    private Boolean enableLabelIndex;
    private Userdata userdata;
    private boolean checkExist;

    public VertexLabelBuilder(SchemaTransaction transaction, HugeGraph graph, String name) {
        super(transaction, graph);
        E.checkNotNull((Object)name, (String)"name");
        this.id = null;
        this.name = name;
        this.idStrategy = IdStrategy.DEFAULT;
        this.properties = new HashSet<String>();
        this.primaryKeys = new ArrayList<String>();
        this.nullableKeys = new HashSet<String>();
        this.ttl = 0L;
        this.ttlStartTime = null;
        this.enableLabelIndex = null;
        this.userdata = new Userdata();
        this.checkExist = true;
    }

    public VertexLabelBuilder(SchemaTransaction transaction, HugeGraph graph, VertexLabel copy) {
        super(transaction, graph);
        E.checkNotNull((Object)copy, (String)"copy");
        HugeGraph origin = copy.graph();
        this.id = null;
        this.name = copy.name();
        this.idStrategy = copy.idStrategy();
        this.properties = VertexLabelBuilder.mapPkId2Name(origin, copy.properties());
        this.primaryKeys = VertexLabelBuilder.mapPkId2Name(origin, copy.primaryKeys());
        this.nullableKeys = VertexLabelBuilder.mapPkId2Name(origin, copy.nullableKeys());
        this.ttl = copy.ttl();
        this.ttlStartTime = copy.ttlStartTimeName();
        this.enableLabelIndex = copy.enableLabelIndex();
        this.userdata = new Userdata(copy.userdata());
        this.checkExist = false;
    }

    @Override
    public VertexLabel build() {
        PropertyKey propertyKey;
        Id id = this.validOrGenerateId(HugeType.VERTEX_LABEL, this.id, this.name);
        VertexLabel vertexLabel = new VertexLabel(this.graph(), id, this.name);
        vertexLabel.idStrategy(this.idStrategy);
        vertexLabel.enableLabelIndex(this.enableLabelIndex == null || this.enableLabelIndex != false);
        vertexLabel.ttl(this.ttl);
        if (this.ttlStartTime != null) {
            vertexLabel.ttlStartTime(this.graph().propertyKey(this.ttlStartTime).id());
        }
        for (String key : this.properties) {
            propertyKey = this.graph().propertyKey(key);
            vertexLabel.property(propertyKey.id());
        }
        for (String key : this.primaryKeys) {
            propertyKey = this.graph().propertyKey(key);
            vertexLabel.primaryKey(propertyKey.id());
        }
        for (String key : this.nullableKeys) {
            propertyKey = this.graph().propertyKey(key);
            vertexLabel.nullableKey(propertyKey.id());
        }
        vertexLabel.userdata(this.userdata);
        return vertexLabel;
    }

    @Override
    public VertexLabel create() {
        HugeType type = HugeType.VERTEX_LABEL;
        this.checkSchemaName(this.name);
        return this.lockCheckAndCreateSchema(type, this.name, name -> {
            VertexLabel vertexLabel = this.vertexLabelOrNull((String)name);
            if (vertexLabel != null) {
                if (this.checkExist || !this.hasSameProperties(vertexLabel)) {
                    throw new ExistedException(type, name);
                }
                return vertexLabel;
            }
            this.checkSchemaIdIfRestoringMode(type, this.id);
            this.checkProperties(Action.INSERT);
            this.checkIdStrategy();
            this.checkNullableKeys(Action.INSERT);
            Userdata.check(this.userdata, Action.INSERT);
            this.checkTtl();
            this.checkUserdata(Action.INSERT);
            vertexLabel = this.build();
            assert (vertexLabel.name().equals(name));
            this.graph().addVertexLabel(vertexLabel);
            return vertexLabel;
        });
    }

    private boolean hasSameProperties(VertexLabel existedVertexLabel) {
        HugeGraph graph = this.graph();
        Set<Id> existedProperties = existedVertexLabel.properties();
        if (this.properties.size() != existedProperties.size()) {
            return false;
        }
        for (String string : this.properties) {
            PropertyKey propertyKey = graph.propertyKey(string);
            if (existedProperties.contains(propertyKey.id())) continue;
            return false;
        }
        List<Id> existedPrimaryKeys = existedVertexLabel.primaryKeys();
        if (this.primaryKeys.size() != existedPrimaryKeys.size()) {
            return false;
        }
        for (String primaryKeyName : this.primaryKeys) {
            PropertyKey primaryKey = graph.propertyKey(primaryKeyName);
            if (existedPrimaryKeys.contains(primaryKey.id())) continue;
            return false;
        }
        Set<Id> set = existedVertexLabel.nullableKeys();
        if (this.nullableKeys.size() != set.size()) {
            return false;
        }
        for (String nullableKeyName : this.nullableKeys) {
            PropertyKey nullableKey = graph.propertyKey(nullableKeyName);
            if (set.contains(nullableKey.id())) continue;
            return false;
        }
        if (this.enableLabelIndex == null || this.enableLabelIndex.booleanValue()) {
            return existedVertexLabel.enableLabelIndex();
        }
        return !existedVertexLabel.enableLabelIndex();
    }

    @Override
    public VertexLabel append() {
        PropertyKey propertyKey;
        VertexLabel vertexLabel = this.vertexLabelOrNull(this.name);
        if (vertexLabel == null) {
            throw new NotFoundException("Can't update vertex label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.APPEND);
        this.checkNullableKeys(Action.APPEND);
        Userdata.check(this.userdata, Action.APPEND);
        for (String key : this.properties) {
            propertyKey = this.graph().propertyKey(key);
            vertexLabel.property(propertyKey.id());
        }
        for (String key : this.nullableKeys) {
            propertyKey = this.graph().propertyKey(key);
            vertexLabel.nullableKey(propertyKey.id());
        }
        vertexLabel.userdata(this.userdata);
        this.graph().updateVertexLabel(vertexLabel);
        return vertexLabel;
    }

    @Override
    public VertexLabel eliminate() {
        VertexLabel vertexLabel = this.vertexLabelOrNull(this.name);
        if (vertexLabel == null) {
            throw new NotFoundException("Can't update vertex label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.ELIMINATE);
        this.checkNullableKeys(Action.ELIMINATE);
        Userdata.check(this.userdata, Action.ELIMINATE);
        vertexLabel.removeUserdata(this.userdata);
        this.graph().updateVertexLabel(vertexLabel);
        return vertexLabel;
    }

    @Override
    public Id remove() {
        VertexLabel vertexLabel = this.vertexLabelOrNull(this.name);
        if (vertexLabel == null) {
            return null;
        }
        return this.graph().removeVertexLabel(vertexLabel.id());
    }

    @Override
    public Id rebuildIndex() {
        VertexLabel vertexLabel = this.vertexLabelOrNull(this.name);
        if (vertexLabel == null) {
            return null;
        }
        return this.graph().rebuildIndex(vertexLabel);
    }

    public VertexLabelBuilder id(long id) {
        E.checkArgument((id != 0L ? 1 : 0) != 0, (String)"Not allowed to assign 0 as vertex label id", (Object[])new Object[0]);
        this.id = IdGenerator.of(id);
        return this;
    }

    @Override
    public VertexLabelBuilder idStrategy(IdStrategy idStrategy) {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == idStrategy ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = idStrategy;
        return this;
    }

    @Override
    public VertexLabelBuilder useAutomaticId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.AUTOMATIC ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.AUTOMATIC;
        return this;
    }

    @Override
    public VertexLabelBuilder usePrimaryKeyId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.PRIMARY_KEY;
        return this;
    }

    @Override
    public VertexLabelBuilder useCustomizeStringId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.CUSTOMIZE_STRING ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.CUSTOMIZE_STRING;
        return this;
    }

    @Override
    public VertexLabelBuilder useCustomizeNumberId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.CUSTOMIZE_NUMBER ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.CUSTOMIZE_NUMBER;
        return this;
    }

    @Override
    public VertexLabelBuilder useCustomizeUuidId() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.CUSTOMIZE_UUID ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.name});
        this.idStrategy = IdStrategy.CUSTOMIZE_UUID;
        return this;
    }

    @Override
    public VertexLabelBuilder properties(String ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    @Override
    public VertexLabelBuilder primaryKeys(String ... keys) {
        if (keys.length == 0) {
            return this;
        }
        E.checkArgument((boolean)this.primaryKeys.isEmpty(), (String)"Not allowed to assign primary keys multitimes", (Object[])new Object[0]);
        List<String> primaryKeys = Arrays.asList(keys);
        E.checkArgument((boolean)CollectionUtil.allUnique(primaryKeys), (String)"Invalid primary keys %s, which contains some duplicate properties", (Object[])new Object[]{primaryKeys});
        this.primaryKeys.addAll(primaryKeys);
        return this;
    }

    @Override
    public VertexLabelBuilder nullableKeys(String ... keys) {
        this.nullableKeys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public VertexLabel.Builder ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public VertexLabel.Builder ttlStartTime(String ttlStartTime) {
        this.ttlStartTime = ttlStartTime;
        return this;
    }

    @Override
    public VertexLabelBuilder enableLabelIndex(boolean enable) {
        this.enableLabelIndex = enable;
        return this;
    }

    @Override
    public VertexLabelBuilder userdata(String key, Object value) {
        this.userdata.put(key, value);
        return this;
    }

    @Override
    public VertexLabelBuilder userdata(Map<String, Object> userdata) {
        this.userdata.putAll(userdata);
        return this;
    }

    public VertexLabelBuilder ifNotExist() {
        this.checkExist = false;
        return this;
    }

    public VertexLabelBuilder checkExist(boolean checkExist) {
        this.checkExist = checkExist;
        return this;
    }

    private void checkProperties(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (String key : this.properties) {
                    this.graph().propertyKey(key);
                }
                break;
            }
            case ELIMINATE: {
                if (this.properties.isEmpty()) break;
                throw new NotAllowException("Not support to eliminate properties for vertex label currently");
            }
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", action));
            }
        }
    }

    private void checkNullableKeys(Action action) {
        if (action == Action.ELIMINATE) {
            if (!this.nullableKeys.isEmpty()) {
                throw new NotAllowException("Not support to eliminate nullableKeys for vertex label currently");
            }
            return;
        }
        VertexLabel vertexLabel = this.vertexLabelOrNull(this.name);
        ImmutableList originProps = vertexLabel == null ? ImmutableList.of() : this.graph().mapPkId2Name(vertexLabel.properties());
        Set<String> appendProps = this.properties;
        E.checkArgument((boolean)CollectionUtil.union((Collection)originProps, appendProps).containsAll(this.nullableKeys), (String)"The nullableKeys: %s to be created or appended must belong to the origin/new properties: %s/%s", (Object[])new Object[]{this.nullableKeys, originProps, appendProps});
        List<String> primaryKeys = vertexLabel == null ? this.primaryKeys : this.graph().mapPkId2Name(vertexLabel.primaryKeys());
        E.checkArgument((!CollectionUtil.hasIntersection(primaryKeys, this.nullableKeys) ? 1 : 0) != 0, (String)"The nullableKeys: %s are not allowed to belong to primaryKeys: %s of vertex label '%s'", (Object[])new Object[]{this.nullableKeys, primaryKeys, this.name});
        if (action == Action.APPEND) {
            Collection newAddedProps = CollectionUtils.subtract(appendProps, (Collection)originProps);
            E.checkArgument((boolean)this.nullableKeys.containsAll(newAddedProps), (String)"The new added properties: %s must be nullable", (Object[])new Object[]{newAddedProps});
        }
    }

    private void checkIdStrategy() {
        IdStrategy strategy = this.idStrategy;
        boolean hasPrimaryKey = this.primaryKeys.size() > 0;
        switch (strategy) {
            case DEFAULT: {
                if (hasPrimaryKey) {
                    this.idStrategy = IdStrategy.PRIMARY_KEY;
                    break;
                }
                this.idStrategy = IdStrategy.AUTOMATIC;
                break;
            }
            case AUTOMATIC: 
            case CUSTOMIZE_STRING: 
            case CUSTOMIZE_NUMBER: 
            case CUSTOMIZE_UUID: {
                E.checkArgument((!hasPrimaryKey ? 1 : 0) != 0, (String)"Not allowed to assign primary keys when using '%s' id strategy", (Object[])new Object[]{strategy});
                break;
            }
            case PRIMARY_KEY: {
                E.checkArgument((boolean)hasPrimaryKey, (String)"Must assign some primary keys when using '%s' id strategy", (Object[])new Object[]{strategy});
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown id strategy '%s'", strategy));
            }
        }
        if (this.idStrategy == IdStrategy.PRIMARY_KEY) {
            this.checkPrimaryKeys();
        }
    }

    private void checkPrimaryKeys() {
        E.checkArgument((this.idStrategy == IdStrategy.DEFAULT || this.idStrategy == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"Not allowed to use id strategy '%s' and assign primary keys at the same time for vertex label '%s'", (Object[])new Object[]{this.idStrategy, this.name});
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties of vertex label '%s' can't be empty when id strategy is '%s'", (Object[])new Object[]{this.name, IdStrategy.PRIMARY_KEY});
        E.checkNotEmpty(this.primaryKeys, (String)"primary keys", (String)this.name);
        for (String key : this.primaryKeys) {
            E.checkArgument((boolean)this.properties.contains(key), (String)"The primary key '%s' of vertex label '%s' must be contained in properties: %s", (Object[])new Object[]{key, this.name, this.properties});
        }
    }

    private void checkStableVars() {
        if (!this.primaryKeys.isEmpty()) {
            throw new NotAllowException("Not allowed to update primary keys for vertex label '%s'", this.name);
        }
        if (this.idStrategy != IdStrategy.DEFAULT) {
            throw new NotAllowException("Not allowed to update id strategy for vertex label '%s'", this.name);
        }
        if (this.enableLabelIndex != null) {
            throw new NotAllowException("Not allowed to update enable_label_index for vertex label '%s'", this.name);
        }
    }

    private void checkTtl() {
        E.checkArgument((this.ttl >= 0L ? 1 : 0) != 0, (String)"The ttl must be >= 0, but got: %s", (Object[])new Object[]{this.ttl});
        if (this.ttl == 0L) {
            E.checkArgument((this.ttlStartTime == null ? 1 : 0) != 0, (String)"Can't set ttl start time if ttl is not set", (Object[])new Object[0]);
            return;
        }
        if (this.ttlStartTime == null) {
            return;
        }
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties can't be empty when exist ttl start time for edge label '%s'", (Object[])new Object[]{this.name});
        E.checkArgument((boolean)this.properties.contains(this.ttlStartTime), (String)"The ttl start time '%s' must be contained in properties '%s' for vertex label '%s'", (Object[])new Object[]{this.ttlStartTime, this.name, this.properties});
        PropertyKey pkey = this.graph().propertyKey(this.ttlStartTime);
        E.checkArgument((boolean)pkey.dataType().isDate(), (String)"The ttl start time property must be date type,but got '%s(%s)'", (Object[])new Object[]{this.ttlStartTime, pkey.dataType()});
    }

    private void checkUserdata(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (Map.Entry e : this.userdata.entrySet()) {
                    if (e.getValue() != null) continue;
                    throw new NotAllowException("Not allowed pass null userdata value when create or append edge label");
                }
                break;
            }
            case ELIMINATE: 
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", action));
            }
        }
    }

    private static Set<String> mapPkId2Name(HugeGraph graph, Set<Id> ids) {
        return new HashSet<String>(graph.mapPkId2Name(ids));
    }

    private static List<String> mapPkId2Name(HugeGraph graph, List<Id> ids) {
        return graph.mapPkId2Name(ids);
    }
}

