/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.IdHolder;
import org.apache.hugegraph.backend.page.IdHolderList;
import org.apache.hugegraph.backend.page.PageEntryIterator;
import org.apache.hugegraph.backend.page.PageIds;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;

public final class QueryList<R> {
    private final Query parent;
    private final QueryResults.Fetcher<R> fetcher;
    private final List<FlattenQuery<R>> queries;

    public QueryList(Query parent, QueryResults.Fetcher<R> fetcher) {
        this.parent = parent;
        this.fetcher = fetcher;
        this.queries = new ArrayList<FlattenQuery<R>>();
    }

    protected Query parent() {
        return this.parent;
    }

    private QueryResults.Fetcher<R> fetcher() {
        return this.fetcher;
    }

    public void add(IdHolderList holders, long indexBatchSize) {
        this.queries.add(new IndexQuery(holders, indexBatchSize));
    }

    public void add(Query query) {
        this.queries.add(new OptimizedQuery(query));
    }

    public int total() {
        int total = 0;
        for (FlattenQuery<R> q : this.queries) {
            total += q.total();
        }
        return total;
    }

    public boolean empty() {
        return this.queries.isEmpty();
    }

    public String toString() {
        return String.format("Query{root:%s,queries:%s}", this.parent, this.queries);
    }

    public QueryResults<R> fetch(int pageSize) {
        assert (!this.queries.isEmpty());
        if (this.parent.paging()) {
            PageEntryIterator iter = new PageEntryIterator(this, pageSize);
            return iter.results();
        }
        return QueryResults.flatMap(this.queries.iterator(), FlattenQuery::iterator);
    }

    protected PageResults<R> fetchNext(PageInfo pageInfo, long pageSize) {
        FlattenQuery<R> query = null;
        int offset = pageInfo.offset();
        int visited = 0;
        for (FlattenQuery<R> q : this.queries) {
            if (visited + q.total() > offset) {
                query = q;
                break;
            }
            visited += q.total();
        }
        E.checkNotNull(query, (String)"query");
        assert (offset >= visited);
        return query.iterator(offset - visited, pageInfo.page(), pageSize);
    }

    public static class PageResults<R> {
        public static final PageResults<?> EMPTY = new PageResults(QueryResults.empty(), PageState.EMPTY);
        private final QueryResults<R> results;
        private final PageState pageState;

        public PageResults(QueryResults<R> results, PageState pageState) {
            this.results = results;
            this.pageState = pageState;
        }

        public Iterator<R> get() {
            return this.results.iterator();
        }

        public boolean hasNextPage() {
            return !Bytes.equals((byte[])this.pageState.position(), (byte[])PageState.EMPTY_BYTES);
        }

        public Query query() {
            List<Query> queries = this.results.queries();
            E.checkState((queries.size() == 1 ? 1 : 0) != 0, (String)"Expect query size 1, but got: %s", (Object[])new Object[]{queries});
            return queries.get(0);
        }

        public String page() {
            return this.pageState.toString();
        }

        public long total() {
            return this.pageState.total();
        }

        public static <R> PageResults<R> emptyIterator() {
            return EMPTY;
        }
    }

    private class IndexQuery
    implements FlattenQuery<R> {
        private final IdHolderList holders;
        private final long batchSize;

        public IndexQuery(IdHolderList holders, long batchSize) {
            this.holders = holders;
            this.batchSize = batchSize;
        }

        @Override
        public QueryResults<R> iterator() {
            if (this.holders.size() == 1) {
                return this.each((IdHolder)this.holders.get(0));
            }
            return QueryResults.flatMap(this.holders.iterator(), this::each);
        }

        private QueryResults<R> each(IdHolder holder) {
            assert (!holder.paging());
            Query bindQuery = holder.query();
            this.updateResultsFilter(bindQuery);
            this.updateOffsetIfNeeded(bindQuery);
            if (holder instanceof IdHolder.FixedIdHolder) {
                Set<Id> ids = holder.all();
                if ((ids = bindQuery.skipOffsetIfNeeded(ids)).isEmpty()) {
                    return null;
                }
                return this.queryByIndexIds(ids, holder.keepOrder());
            }
            assert (holder instanceof IdHolder.BatchIdHolder);
            return QueryResults.flatMap((IdHolder.BatchIdHolder)holder, h -> {
                assert (((IdHolder.BatchIdHolder)holder).hasNext());
                long remaining = bindQuery.remaining();
                assert (remaining >= 0L || remaining == Long.MAX_VALUE);
                if (remaining > this.batchSize || remaining == Long.MAX_VALUE) {
                    remaining = this.batchSize;
                }
                Set<Id> ids = h.fetchNext(null, remaining).ids();
                if ((ids = bindQuery.skipOffsetIfNeeded(ids)).isEmpty()) {
                    return null;
                }
                return this.queryByIndexIds(ids);
            });
        }

        @Override
        public PageResults<R> iterator(int index, String page, long pageSize) {
            E.checkArgument((0 <= index && index <= this.holders.size() ? 1 : 0) != 0, (String)"Invalid page index %s", (Object[])new Object[]{index});
            IdHolder holder = (IdHolder)this.holders.get(index);
            Query bindQuery = holder.query();
            this.updateResultsFilter(bindQuery);
            PageIds pageIds = holder.fetchNext(page, pageSize);
            if (pageIds.empty()) {
                return PageResults.emptyIterator();
            }
            QueryResults results = this.queryByIndexIds(pageIds.ids());
            return new PageResults(results, pageIds.pageState());
        }

        @Override
        public int total() {
            return this.holders.size();
        }

        public String toString() {
            return String.format("IndexQuery{%s}", this.holders);
        }

        private void updateOffsetIfNeeded(Query query) {
            Query parent = QueryList.this.parent();
            assert (parent instanceof ConditionQuery);
            ConditionQuery.OptimizedType optimized = ((ConditionQuery)parent).optimized();
            if (optimized == ConditionQuery.OptimizedType.INDEX_FILTER) {
                return;
            }
            query.copyOffset(parent);
        }

        private void updateResultsFilter(Query query) {
            while (query != null) {
                if (query instanceof ConditionQuery) {
                    ((ConditionQuery)query).updateResultsFilter();
                    return;
                }
                query = query.originQuery();
            }
        }

        private QueryResults<R> queryByIndexIds(Set<Id> ids) {
            return this.queryByIndexIds(ids, false);
        }

        private QueryResults<R> queryByIndexIds(Set<Id> ids, boolean inOrder) {
            IdQuery query = new IdQuery(QueryList.this.parent(), ids);
            query.mustSortByInput(inOrder);
            return (QueryResults)QueryList.this.fetcher().apply(query);
        }
    }

    private class OptimizedQuery
    implements FlattenQuery<R> {
        private final Query query;

        public OptimizedQuery(Query query) {
            this.query = query;
        }

        @Override
        public QueryResults<R> iterator() {
            return (QueryResults)QueryList.this.fetcher().apply(this.query);
        }

        @Override
        public PageResults<R> iterator(int index, String page, long pageSize) {
            assert (index == 0);
            Query query = this.query.copy();
            query.page(page);
            if (this.query.noLimit()) {
                query.limit(pageSize);
            }
            QueryResults results = (QueryResults)QueryList.this.fetcher().apply(query);
            QueryResults fetched = results.toList();
            PageState pageState = PageInfo.pageState(results.iterator());
            return new PageResults(fetched, pageState);
        }

        @Override
        public int total() {
            return 1;
        }

        public String toString() {
            return String.format("OptimizedQuery{%s}", this.query);
        }
    }

    private static interface FlattenQuery<R> {
        public QueryResults<R> iterator();

        public PageResults<R> iterator(int var1, String var2, long var3);

        public int total();
    }
}

