/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.metrics.micrometer;

import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.Event;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.event.ServerStoppedEvent;
import com.alipay.sofa.rpc.event.Subscriber;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class SofaRpcMetrics
extends Subscriber
implements MeterBinder,
AutoCloseable {
    private final AtomicReference<MeterRegistry> initialed = new AtomicReference();
    private final Function<Tags, Timer> clientTotal = tags -> Timer.builder((String)"sofa.client.total").tags((Iterable)tags).register(this.initialed.get());
    private final Function<Tags, Timer> clientFail = tags -> Timer.builder((String)"sofa.client.fail").tags((Iterable)tags).register(this.initialed.get());
    private final Function<Tags, Timer> serverTotal = tags -> Timer.builder((String)"sofa.server.total").tags((Iterable)tags).register(this.initialed.get());
    private final Function<Tags, Timer> serverFail = tags -> Timer.builder((String)"sofa.server.fail").tags((Iterable)tags).register(this.initialed.get());
    private final Function<Tags, DistributionSummary> requestSize = tags -> DistributionSummary.builder((String)"sofa.request.size").tags((Iterable)tags).baseUnit("bytes").register(this.initialed.get());
    private final Function<Tags, DistributionSummary> responseSize = tags -> DistributionSummary.builder((String)"sofa.response.size").tags((Iterable)tags).baseUnit("bytes").register(this.initialed.get());
    private Counter provider;
    private Counter consumer;
    private final Tags common;
    private final AtomicReference<ServerConfig> serverConfig = new AtomicReference();
    private final AtomicReference<ThreadPoolExecutor> executor = new AtomicReference();

    public SofaRpcMetrics() {
        this(Collections.emptyList());
    }

    public SofaRpcMetrics(Iterable<Tag> common) {
        this.common = Tags.of(common);
        this.register();
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"sofa.threadpool.config.core", () -> Optional.of(this.serverConfig).map(AtomicReference::get).map(ServerConfig::getCoreThreads).orElse(0)).tags((Iterable)this.common).baseUnit("threads").register(registry);
        Gauge.builder((String)"sofa.threadpool.config.max", () -> Optional.of(this.serverConfig).map(AtomicReference::get).map(ServerConfig::getMaxThreads).orElse(0)).tags((Iterable)this.common).baseUnit("threads").register(registry);
        Gauge.builder((String)"sofa.threadpool.config.queue", () -> Optional.of(this.serverConfig).map(AtomicReference::get).map(ServerConfig::getQueues).orElse(0)).tags((Iterable)this.common).baseUnit("tasks").register(registry);
        Gauge.builder((String)"sofa.threadpool.active", () -> Optional.of(this.executor).map(AtomicReference::get).map(ThreadPoolExecutor::getActiveCount).orElse(0)).tags((Iterable)this.common).baseUnit("threads").register(registry);
        Gauge.builder((String)"sofa.threadpool.idle", () -> Optional.of(this.executor).map(AtomicReference::get).map(e -> e.getPoolSize() - e.getActiveCount()).orElse(0)).tags((Iterable)this.common).baseUnit("threads").register(registry);
        Gauge.builder((String)"sofa.threadpool.queue.size", () -> Optional.of(this.executor).map(AtomicReference::get).map(ThreadPoolExecutor::getQueue).map(Collection::size).orElse(0)).tags((Iterable)this.common).baseUnit("tasks").register(registry);
        this.provider = Counter.builder((String)"sofa.provider").tags((Iterable)this.common).register(registry);
        this.consumer = Counter.builder((String)"sofa.consumer").tags((Iterable)this.common).register(registry);
        this.initialed.set(registry);
    }

    private void register() {
        EventBus.register(ClientEndInvokeEvent.class, this);
        EventBus.register(ServerSendEvent.class, this);
        EventBus.register(ServerStartedEvent.class, this);
        EventBus.register(ServerStoppedEvent.class, this);
        EventBus.register(ProviderPubEvent.class, this);
        EventBus.register(ConsumerSubEvent.class, this);
    }

    @Override
    public void onEvent(Event event) {
        if (this.initialed.get() != null) {
            if (event instanceof ClientEndInvokeEvent) {
                this.onEvent((ClientEndInvokeEvent)event);
            } else if (event instanceof ServerSendEvent) {
                this.onEvent((ServerSendEvent)event);
            } else if (event instanceof ServerStartedEvent) {
                this.onEvent((ServerStartedEvent)event);
            } else if (event instanceof ServerStoppedEvent) {
                this.onEvent((ServerStoppedEvent)event);
            } else if (event instanceof ProviderPubEvent) {
                this.onEvent((ProviderPubEvent)event);
            } else if (event instanceof ConsumerSubEvent) {
                this.onEvent((ConsumerSubEvent)event);
            } else {
                throw new IllegalArgumentException("unexpected event: " + event);
            }
        }
    }

    private void onEvent(ClientEndInvokeEvent event) {
        InvokeMeta meta = new InvokeMeta(event.getRequest(), event.getResponse(), SofaRpcMetrics.getLongAvoidNull(RpcInternalContext.getContext().getAttachment("_client_elapse")));
        RpcInternalContext context = RpcInternalContext.getContext();
        Duration elapsed = meta.elapsed();
        Tags tags = meta.tags((Iterable<Tag>)this.common);
        this.clientTotal.apply(tags).record(elapsed);
        if (!meta.success()) {
            this.clientFail.apply(tags).record(elapsed);
        }
        this.requestSize.apply(tags).record((double)SofaRpcMetrics.getLongAvoidNull(context.getAttachment("_req_size")).longValue());
        this.responseSize.apply(tags).record((double)SofaRpcMetrics.getLongAvoidNull(context.getAttachment("_resp_size")).longValue());
    }

    private void onEvent(ServerSendEvent event) {
        InvokeMeta meta = new InvokeMeta(event.getRequest(), event.getResponse(), SofaRpcMetrics.getLongAvoidNull(RpcInternalContext.getContext().getAttachment("_impl_elapse")));
        Duration elapsed = meta.elapsed();
        Tags tags = meta.tags((Iterable<Tag>)this.common);
        this.serverTotal.apply(tags).record(elapsed);
        if (!meta.success()) {
            this.serverFail.apply(tags).record(elapsed);
        }
    }

    private void onEvent(ServerStartedEvent event) {
        this.serverConfig.set(event.getServerConfig());
        this.executor.set(event.getThreadPoolExecutor());
    }

    private void onEvent(ServerStoppedEvent event) {
        this.serverConfig.set(null);
        this.executor.set(null);
    }

    private void onEvent(ProviderPubEvent event) {
        this.provider.increment();
    }

    private void onEvent(ConsumerSubEvent event) {
        this.consumer.increment();
    }

    private static Long getLongAvoidNull(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return Long.parseLong(object.toString());
        }
        return (Long)object;
    }

    private static String getStringAvoidNull(Object object) {
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    @Override
    public void close() {
        EventBus.unRegister(ClientEndInvokeEvent.class, this);
        EventBus.unRegister(ServerSendEvent.class, this);
        EventBus.unRegister(ServerStartedEvent.class, this);
        EventBus.unRegister(ServerStoppedEvent.class, this);
        EventBus.unRegister(ProviderPubEvent.class, this);
        EventBus.unRegister(ConsumerSubEvent.class, this);
    }

    private static class InvokeMeta {
        private final SofaRequest request;
        private final SofaResponse response;
        private final Duration elapsed;

        private InvokeMeta(SofaRequest request, SofaResponse response, long elapsed) {
            this.request = request;
            this.response = response;
            this.elapsed = Duration.ofMillis(elapsed);
        }

        public String app() {
            return Optional.ofNullable(this.request.getTargetAppName()).orElse("");
        }

        public String callerApp() {
            return Optional.ofNullable(SofaRpcMetrics.getStringAvoidNull(this.request.getRequestProp("app"))).orElse("");
        }

        public String service() {
            return Optional.ofNullable(this.request.getTargetServiceUniqueName()).orElse("");
        }

        public String method() {
            return Optional.ofNullable(this.request.getMethodName()).orElse("");
        }

        public String protocol() {
            return Optional.ofNullable(SofaRpcMetrics.getStringAvoidNull(this.request.getRequestProp("protocol"))).orElse("");
        }

        public String invokeType() {
            return Optional.ofNullable(this.request.getInvokeType()).orElse("");
        }

        public Duration elapsed() {
            return this.elapsed;
        }

        public boolean success() {
            return this.response != null && !this.response.isError() && this.response.getErrorMsg() == null && !(this.response.getAppResponse() instanceof Throwable);
        }

        public Tags tags(Iterable<Tag> common) {
            return Tags.of(common).and(new Tag[]{Tag.of((String)"app", (String)this.app()), Tag.of((String)"service", (String)this.service()), Tag.of((String)"method", (String)this.method()), Tag.of((String)"protocol", (String)this.protocol()), Tag.of((String)"invoke_type", (String)this.invokeType()), Tag.of((String)"caller_app", (String)this.callerApp())});
        }
    }
}

