/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class RootProcedureState<TEnvironment> {
    private static final Logger LOG = LoggerFactory.getLogger(RootProcedureState.class);
    private Set<Procedure<TEnvironment>> subprocs = null;
    private ArrayList<Procedure<TEnvironment>> subprocStack = null;
    private State state = State.RUNNING;
    private int running = 0;

    RootProcedureState() {
    }

    public synchronized boolean isFailed() {
        switch (this.state) {
            case ROLLINGBACK: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isRollingback() {
        return this.state == State.ROLLINGBACK;
    }

    protected synchronized boolean setRollback() {
        if (this.running == 0 && this.state == State.FAILED) {
            this.state = State.ROLLINGBACK;
            return true;
        }
        return false;
    }

    protected synchronized void unsetRollback() {
        assert (this.state == State.ROLLINGBACK);
        this.state = State.FAILED;
    }

    protected synchronized long[] getSubprocedureIds() {
        if (this.subprocs == null) {
            return null;
        }
        return this.subprocs.stream().mapToLong(Procedure::getProcId).toArray();
    }

    protected synchronized List<Procedure<TEnvironment>> getSubproceduresStack() {
        return this.subprocStack;
    }

    protected synchronized RemoteProcedureException getException() {
        if (this.subprocStack != null) {
            for (Procedure<TEnvironment> proc : this.subprocStack) {
                if (!proc.hasException()) continue;
                return proc.getException();
            }
        }
        return null;
    }

    protected synchronized boolean acquire(Procedure<TEnvironment> proc) {
        if (this.state != State.RUNNING) {
            return false;
        }
        ++this.running;
        return true;
    }

    protected synchronized void release(Procedure<TEnvironment> proc) {
        --this.running;
    }

    protected synchronized void abort() {
        if (this.state == State.RUNNING) {
            this.state = State.FAILED;
        }
    }

    protected synchronized void addRollbackStep(Procedure<TEnvironment> proc) {
        if (proc.isFailed()) {
            this.state = State.FAILED;
        }
        if (this.subprocStack == null) {
            this.subprocStack = new ArrayList();
        }
        proc.addStackIndex(this.subprocStack.size());
        LOG.debug("Add procedure {} as the {}th rollback step", proc, (Object)this.subprocStack.size());
        this.subprocStack.add(proc);
    }

    protected synchronized void addSubProcedure(Procedure<TEnvironment> proc) {
        if (!proc.hasParent()) {
            return;
        }
        if (this.subprocs == null) {
            this.subprocs = new HashSet<Procedure<TEnvironment>>();
        }
        this.subprocs.add(proc);
    }

    protected synchronized void loadStack(Procedure<TEnvironment> proc) {
        this.addSubProcedure(proc);
        int[] stackIndexes = proc.getStackIndexes();
        if (stackIndexes != null) {
            int diff;
            if (this.subprocStack == null) {
                this.subprocStack = new ArrayList();
            }
            if ((diff = 1 + stackIndexes[stackIndexes.length - 1] - this.subprocStack.size()) > 0) {
                this.subprocStack.ensureCapacity(1 + stackIndexes[stackIndexes.length - 1]);
                while (diff-- > 0) {
                    this.subprocStack.add(null);
                }
            }
            for (int i = 0; i < stackIndexes.length; ++i) {
                this.subprocStack.set(stackIndexes[i], proc);
            }
        }
        if (proc.getState() == ProcedureProtos.ProcedureState.ROLLEDBACK) {
            this.state = State.ROLLINGBACK;
        } else if (proc.isFailed()) {
            this.state = State.FAILED;
        }
    }

    protected synchronized boolean isValid() {
        if (this.subprocStack != null) {
            for (Procedure<TEnvironment> proc : this.subprocStack) {
                if (proc != null) continue;
                return false;
            }
        }
        return true;
    }

    private static enum State {
        RUNNING,
        FAILED,
        ROLLINGBACK;

    }
}

