/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.computer.core.util.BytesUtil;
import org.apache.hugegraph.util.E;

public abstract class AbstractBufferedFileInput
extends UnsafeBytesInput {
    private final int bufferCapacity;
    private final long fileLength;
    protected long fileOffset;

    public AbstractBufferedFileInput(int bufferCapacity, long fileLength) {
        super(new byte[bufferCapacity], 0, 0);
        this.bufferCapacity = bufferCapacity;
        this.fileLength = fileLength;
    }

    @Override
    public long position() {
        return this.fileOffset - (long)super.remaining();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        E.checkArgument((bytesToSkip >= 0L ? 1 : 0) != 0, (String)"The parameter bytesToSkip must be >= 0, but got %s", (Object[])new Object[]{bytesToSkip});
        E.checkArgument((this.available() >= bytesToSkip ? 1 : 0) != 0, (String)"Failed to skip '%s' bytes, because don't have enough data", (Object[])new Object[0]);
        long positionBeforeSkip = this.position();
        this.seek(this.position() + bytesToSkip);
        return positionBeforeSkip;
    }

    @Override
    protected void require(int size) throws IOException {
        if (this.remaining() >= size) {
            return;
        }
        if (this.bufferCapacity >= size) {
            this.shiftAndFillBuffer();
        }
        if (size > this.limit()) {
            throw new IOException(String.format("Reading %s bytes from position %s overflows buffer length %s", size, this.position(), this.limit()));
        }
    }

    @Override
    public long available() throws IOException {
        return this.fileLength - this.position();
    }

    protected void shiftAndFillBuffer() throws IOException {
        this.shiftBuffer();
        this.fillBuffer();
    }

    protected abstract void fillBuffer() throws IOException;

    @Override
    public int compare(long offset, long length, RandomAccessInput other, long otherOffset, long otherLength) throws IOException {
        int compareOffset2;
        byte[] bytes2;
        AbstractBufferedFileInput otherInput;
        int compareOffset1;
        byte[] bytes1;
        if (AbstractBufferedFileInput.rangeInBuffer(this, offset, length)) {
            bytes1 = this.buffer();
            compareOffset1 = (int)(offset - AbstractBufferedFileInput.bufferStartPosition(this));
        } else {
            long oldPosition = this.position();
            this.seek(offset);
            bytes1 = this.readBytes((int)length);
            compareOffset1 = 0;
            this.seek(oldPosition);
        }
        if (other instanceof AbstractBufferedFileInput && AbstractBufferedFileInput.rangeInBuffer(otherInput = (AbstractBufferedFileInput)other, otherOffset, otherLength)) {
            bytes2 = otherInput.buffer();
            long otherBufferStart = AbstractBufferedFileInput.bufferStartPosition(otherInput);
            compareOffset2 = (int)(otherOffset - otherBufferStart);
        } else {
            long oldPosition = other.position();
            other.seek(otherOffset);
            bytes2 = other.readBytes((int)otherLength);
            compareOffset2 = 0;
            other.seek(oldPosition);
        }
        return BytesUtil.compare((byte[])bytes1, (int)compareOffset1, (int)((int)length), (byte[])bytes2, (int)compareOffset2, (int)((int)otherLength));
    }

    private static long bufferStartPosition(AbstractBufferedFileInput input) {
        return input.fileOffset - (long)input.limit();
    }

    private static boolean rangeInBuffer(AbstractBufferedFileInput input, long offset, long length) {
        long bufferStart = AbstractBufferedFileInput.bufferStartPosition(input);
        return bufferStart <= offset && offset <= input.fileOffset && (long)input.limit() >= length;
    }

    protected int bufferCapacity() {
        return this.bufferCapacity;
    }

    protected long fileLength() {
        return this.fileLength;
    }
}

