/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.util;

import com.google.common.base.Preconditions;

public class BytesUtil {
    public static byte[] ensureCapacityWithoutCopy(byte[] bytes, int length) {
        if (bytes == null || bytes.length < length) {
            return new byte[length];
        }
        return bytes;
    }

    public static int hashBytes(byte[] bytes, int length) {
        return BytesUtil.hashBytes(bytes, 0, length);
    }

    public static int hashBytes(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static int compare(byte[] bytes1, byte[] bytes2) {
        return BytesUtil.compare(bytes1, bytes1.length, bytes2, bytes2.length);
    }

    public static int compare(byte[] bytes1, int length1, byte[] bytes2, int length2) {
        return BytesUtil.compare(bytes1, 0, length1, bytes2, 0, length2);
    }

    public static int compare(byte[] bytes1, int offset1, int length1, byte[] bytes2, int offset2, int length2) {
        Preconditions.checkNotNull((Object)bytes1);
        Preconditions.checkNotNull((Object)bytes2);
        if (bytes1 == bytes2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        if (length1 != length2) {
            return length1 - length2;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = bytes1[i] & 0xFF;
            int b = bytes2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return 0;
    }
}

