/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.ibatis.annotations.Param;

public class SchemaMetaBaseSQLProvider {
    public String listSchemaPOsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String listSchemaPOsBySchemaIds(@Param(value="schemaIds") List<Long> schemaIds) {
        return "<script>SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE schema_id IN (<foreach collection='schemaIds' item='schemaId' separator=','>#{schemaId}</foreach>) AND deleted_at = 0</script>";
    }

    public String selectSchemaIdByCatalogIdAndName(@Param(value="catalogId") Long catalogId, @Param(value="schemaName") String name) {
        return "SELECT schema_id as schemaId FROM schema_meta WHERE catalog_id = #{catalogId} AND schema_name = #{schemaName} AND deleted_at = 0";
    }

    public String selectSchemaMetaByCatalogIdAndName(@Param(value="catalogId") Long catalogId, @Param(value="schemaName") String name) {
        return "SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE catalog_id = #{catalogId} AND schema_name = #{schemaName} AND deleted_at = 0";
    }

    public String selectSchemaMetaById(@Param(value="schemaId") Long schemaId) {
        return "SELECT schema_id as schemaId, schema_name as schemaName, metalake_id as metalakeId, catalog_id as catalogId, schema_comment as schemaComment, properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM schema_meta WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String insertSchemaMeta(@Param(value="schemaMeta") SchemaPO schemaPO) {
        return "INSERT INTO schema_meta (schema_id, schema_name, metalake_id, catalog_id, schema_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES ( #{schemaMeta.schemaId}, #{schemaMeta.schemaName}, #{schemaMeta.metalakeId}, #{schemaMeta.catalogId}, #{schemaMeta.schemaComment}, #{schemaMeta.properties}, #{schemaMeta.auditInfo}, #{schemaMeta.currentVersion}, #{schemaMeta.lastVersion}, #{schemaMeta.deletedAt} )";
    }

    public String insertSchemaMetaOnDuplicateKeyUpdate(@Param(value="schemaMeta") SchemaPO schemaPO) {
        return "INSERT INTO schema_meta (schema_id, schema_name, metalake_id, catalog_id, schema_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES ( #{schemaMeta.schemaId}, #{schemaMeta.schemaName}, #{schemaMeta.metalakeId}, #{schemaMeta.catalogId}, #{schemaMeta.schemaComment}, #{schemaMeta.properties}, #{schemaMeta.auditInfo}, #{schemaMeta.currentVersion}, #{schemaMeta.lastVersion}, #{schemaMeta.deletedAt} ) ON DUPLICATE KEY UPDATE schema_name = #{schemaMeta.schemaName}, metalake_id = #{schemaMeta.metalakeId}, catalog_id = #{schemaMeta.catalogId}, schema_comment = #{schemaMeta.schemaComment}, properties = #{schemaMeta.properties}, audit_info = #{schemaMeta.auditInfo}, current_version = #{schemaMeta.currentVersion}, last_version = #{schemaMeta.lastVersion}, deleted_at = #{schemaMeta.deletedAt}";
    }

    public String updateSchemaMeta(@Param(value="newSchemaMeta") SchemaPO newSchemaPO, @Param(value="oldSchemaMeta") SchemaPO oldSchemaPO) {
        return "UPDATE schema_meta SET schema_name = #{newSchemaMeta.schemaName}, metalake_id = #{newSchemaMeta.metalakeId}, catalog_id = #{newSchemaMeta.catalogId}, schema_comment = #{newSchemaMeta.schemaComment}, properties = #{newSchemaMeta.properties}, audit_info = #{newSchemaMeta.auditInfo}, current_version = #{newSchemaMeta.currentVersion}, last_version = #{newSchemaMeta.lastVersion}, deleted_at = #{newSchemaMeta.deletedAt} WHERE schema_id = #{oldSchemaMeta.schemaId} AND schema_name = #{oldSchemaMeta.schemaName} AND metalake_id = #{oldSchemaMeta.metalakeId} AND catalog_id = #{oldSchemaMeta.catalogId} AND (schema_comment = #{oldSchemaMeta.schemaComment}   OR (schema_comment IS NULL and #{oldSchemaMeta.schemaComment} IS NULL)) AND properties = #{oldSchemaMeta.properties} AND audit_info = #{oldSchemaMeta.auditInfo} AND current_version = #{oldSchemaMeta.currentVersion} AND last_version = #{oldSchemaMeta.lastVersion} AND deleted_at = 0";
    }

    public String softDeleteSchemaMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE schema_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String softDeleteSchemaMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE schema_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteSchemaMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE schema_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String deleteSchemaMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM schema_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String selectSchemaIdByMetalakeNameAndCatalogNameAndSchemaName(@Param(value="metalakeName") String metalakeName, @Param(value="catalogName") String catalogName, @Param(value="schemaName") String schemaName) {
        return "SELECT metalake_meta.metalake_id as metalakeId, catalog_meta.catalog_id as catalogId, schema_id as schemaId FROM metalake_meta JOIN catalog_meta ON metalake_meta.metalake_id = catalog_meta.metalake_id JOIN schema_meta ON catalog_meta.catalog_id = schema_meta.catalog_id WHERE metalake_name = #{metalakeName} AND catalog_name = #{catalogName} AND schema_name = #{schemaName} AND schema_meta.deleted_at = 0 AND catalog_meta.deleted_at = 0 AND metalake_meta.deleted_at = 0";
    }
}

