/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableShortCharMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableShortCharMap;
import org.eclipse.collections.api.map.primitive.ShortCharMap;
import org.eclipse.collections.impl.factory.primitive.ShortCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortCharSingletonMap;

public class ImmutableShortCharMapFactoryImpl
implements ImmutableShortCharMapFactory {
    public static final ImmutableShortCharMapFactory INSTANCE = new ImmutableShortCharMapFactoryImpl();

    public ImmutableShortCharMap empty() {
        return ImmutableShortCharEmptyMap.INSTANCE;
    }

    public ImmutableShortCharMap of() {
        return this.empty();
    }

    public ImmutableShortCharMap with() {
        return this.empty();
    }

    public ImmutableShortCharMap of(short key, char value) {
        return this.with(key, value);
    }

    public ImmutableShortCharMap with(short key, char value) {
        return new ImmutableShortCharSingletonMap(key, value);
    }

    public ImmutableShortCharMap ofAll(ShortCharMap map) {
        return this.withAll(map);
    }

    public ImmutableShortCharMap withAll(ShortCharMap map) {
        if (map instanceof ImmutableShortCharMap) {
            return (ImmutableShortCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortCharSingletonMap(key, map.get(key));
        }
        return new ImmutableShortCharHashMap(map);
    }

    public <T> ImmutableShortCharMap from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        return ShortCharMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

