/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.HttpComponentsClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.JdkClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.JettyClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ReactorClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ReflectiveComponentsClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.SimpleClientHttpRequestFactoryBuilder;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.http.client.ReactorClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;

@FunctionalInterface
public interface ClientHttpRequestFactoryBuilder<T extends ClientHttpRequestFactory> {
    default public T build() {
        return this.build(null);
    }

    public T build(ClientHttpRequestFactorySettings var1);

    default public ClientHttpRequestFactoryBuilder<T> withCustomizer(Consumer<T> customizer2) {
        return this.withCustomizers(List.of(customizer2));
    }

    default public ClientHttpRequestFactoryBuilder<T> withCustomizers(Collection<Consumer<T>> customizers) {
        Assert.notNull(customizers, "'customizers' must not be null");
        Assert.noNullElements(customizers, "'customizers' must not contain null elements");
        return settings -> {
            Object factory = this.build(settings);
            LambdaSafe.callbacks(Consumer.class, customizers, factory, new Object[0]).invoke(consumer -> consumer.accept(factory));
            return factory;
        };
    }

    public static HttpComponentsClientHttpRequestFactoryBuilder httpComponents() {
        return new HttpComponentsClientHttpRequestFactoryBuilder();
    }

    public static JettyClientHttpRequestFactoryBuilder jetty() {
        return new JettyClientHttpRequestFactoryBuilder();
    }

    public static ReactorClientHttpRequestFactoryBuilder reactor() {
        return new ReactorClientHttpRequestFactoryBuilder();
    }

    public static JdkClientHttpRequestFactoryBuilder jdk() {
        return new JdkClientHttpRequestFactoryBuilder();
    }

    public static SimpleClientHttpRequestFactoryBuilder simple() {
        return new SimpleClientHttpRequestFactoryBuilder();
    }

    public static <T extends ClientHttpRequestFactory> ClientHttpRequestFactoryBuilder<T> of(Class<T> requestFactoryType) {
        Assert.notNull(requestFactoryType, "'requestFactoryType' must not be null");
        Assert.isTrue(requestFactoryType != ClientHttpRequestFactory.class, "'requestFactoryType' must be an implementation of ClientHttpRequestFactory");
        if (requestFactoryType == HttpComponentsClientHttpRequestFactory.class) {
            return ClientHttpRequestFactoryBuilder.httpComponents();
        }
        if (requestFactoryType == JettyClientHttpRequestFactory.class) {
            return ClientHttpRequestFactoryBuilder.jetty();
        }
        if (requestFactoryType == ReactorClientHttpRequestFactory.class) {
            return ClientHttpRequestFactoryBuilder.reactor();
        }
        if (requestFactoryType == JdkClientHttpRequestFactory.class) {
            return ClientHttpRequestFactoryBuilder.jdk();
        }
        if (requestFactoryType == SimpleClientHttpRequestFactory.class) {
            return ClientHttpRequestFactoryBuilder.simple();
        }
        return new ReflectiveComponentsClientHttpRequestFactoryBuilder<T>(requestFactoryType);
    }

    public static <T extends ClientHttpRequestFactory> ClientHttpRequestFactoryBuilder<T> of(Supplier<T> requestFactorySupplier) {
        return new ReflectiveComponentsClientHttpRequestFactoryBuilder<T>(requestFactorySupplier);
    }

    public static ClientHttpRequestFactoryBuilder<? extends ClientHttpRequestFactory> detect() {
        return ClientHttpRequestFactoryBuilder.detect(null);
    }

    public static ClientHttpRequestFactoryBuilder<? extends ClientHttpRequestFactory> detect(ClassLoader classLoader) {
        if (HttpComponentsClientHttpRequestFactoryBuilder.Classes.present(classLoader)) {
            return ClientHttpRequestFactoryBuilder.httpComponents();
        }
        if (JettyClientHttpRequestFactoryBuilder.Classes.present(classLoader)) {
            return ClientHttpRequestFactoryBuilder.jetty();
        }
        if (ReactorClientHttpRequestFactoryBuilder.Classes.present(classLoader)) {
            return ClientHttpRequestFactoryBuilder.reactor();
        }
        if (JdkClientHttpRequestFactoryBuilder.Classes.present(classLoader)) {
            return ClientHttpRequestFactoryBuilder.jdk();
        }
        return ClientHttpRequestFactoryBuilder.simple();
    }
}

