/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.encrypt;

import java.util.regex.Pattern;
import org.springframework.cloud.context.encrypt.KeyFormatException;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptorFactory {
    private static final Pattern NEWLINE_ESCAPE_PATTERN = Pattern.compile("\\r|\\n");
    private String salt = "deadbeef";

    public EncryptorFactory() {
    }

    public EncryptorFactory(String salt) {
        this.salt = salt;
    }

    public TextEncryptor create(String data) {
        TextEncryptor encryptor;
        if (data.contains("RSA PRIVATE KEY")) {
            try {
                String normalizedPemData = this.normalizePem(data);
                encryptor = new RsaSecretEncryptor(NEWLINE_ESCAPE_PATTERN.matcher(normalizedPemData).replaceAll(""));
            }
            catch (IllegalArgumentException e) {
                throw new KeyFormatException(e);
            }
        } else {
            if (data.startsWith("ssh-rsa") || data.contains("RSA PUBLIC KEY")) {
                throw new KeyFormatException();
            }
            encryptor = Encryptors.text((CharSequence)data, (CharSequence)this.salt);
        }
        return encryptor;
    }

    /*
     * Exception decompiling
     */
    private String normalizePem(String data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

