/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

public final class RetryUtils {
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy(3, 1000L);

    public static <T> T retryFunction(@NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return RetryUtils.retryFunction(supplier, DEFAULT_RETRY_POLICY);
    }

    public static <T> T retryFunction(@NonNull Supplier<T> supplier, @NonNull RetryPolicy retryPolicy) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (retryPolicy == null) {
            throw new NullPointerException("retryPolicy is marked non-null but is null");
        }
        int retryCount = 0;
        long retryInterval = retryPolicy.getRetryInterval();
        while (true) {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                if (retryCount == retryPolicy.getMaxRetryTimes()) {
                    throw ex;
                }
                ++retryCount;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("The current thread is interrupted, will stop retry", e);
                }
            }
        }
    }

    @Generated
    private RetryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class RetryPolicy {
        private final int maxRetryTimes;
        private final long retryInterval;

        @Generated
        public RetryPolicy(int maxRetryTimes, long retryInterval) {
            this.maxRetryTimes = maxRetryTimes;
            this.retryInterval = retryInterval;
        }

        @Generated
        public int getMaxRetryTimes() {
            return this.maxRetryTimes;
        }

        @Generated
        public long getRetryInterval() {
            return this.retryInterval;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryPolicy)) {
                return false;
            }
            RetryPolicy other = (RetryPolicy)o;
            if (this.getMaxRetryTimes() != other.getMaxRetryTimes()) {
                return false;
            }
            return this.getRetryInterval() == other.getRetryInterval();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxRetryTimes();
            long $retryInterval = this.getRetryInterval();
            result = result * 59 + (int)($retryInterval >>> 32 ^ $retryInterval);
            return result;
        }

        @Generated
        public String toString() {
            return "RetryUtils.RetryPolicy(maxRetryTimes=" + this.getMaxRetryTimes() + ", retryInterval=" + this.getRetryInterval() + ")";
        }
    }
}

