/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonS3DatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AmazonS3Object")
public final class AmazonS3Dataset
extends Dataset {
    @JsonProperty(value="typeProperties", required=true)
    private AmazonS3DatasetTypeProperties innerTypeProperties = new AmazonS3DatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AmazonS3Dataset.class);

    private AmazonS3DatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AmazonS3Dataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AmazonS3Dataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AmazonS3Dataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AmazonS3Dataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AmazonS3Dataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AmazonS3Dataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AmazonS3Dataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object bucketName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().bucketName();
    }

    public AmazonS3Dataset withBucketName(Object bucketName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withBucketName(bucketName);
        return this;
    }

    public Object key() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().key();
    }

    public AmazonS3Dataset withKey(Object key) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withKey(key);
        return this;
    }

    public Object prefix() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().prefix();
    }

    public AmazonS3Dataset withPrefix(Object prefix) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withPrefix(prefix);
        return this;
    }

    public Object version() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().version();
    }

    public AmazonS3Dataset withVersion(Object version) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withVersion(version);
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeStart();
    }

    public AmazonS3Dataset withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeStart(modifiedDatetimeStart);
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeEnd();
    }

    public AmazonS3Dataset withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeEnd(modifiedDatetimeEnd);
        return this;
    }

    public DatasetStorageFormat format() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().format();
    }

    public AmazonS3Dataset withFormat(DatasetStorageFormat format) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withFormat(format);
        return this;
    }

    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    public AmazonS3Dataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AmazonS3Dataset"));
        }
        this.innerTypeProperties().validate();
    }
}

