/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.datasource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.dolphinscheduler.spi.enums.DbType;

public abstract class BaseDataSourceParamDTO
implements Serializable {
    protected Integer id;
    protected String name;
    protected String note;
    protected String host;
    protected Integer port;
    protected String database;
    protected String userName;
    protected String password;
    protected Map<String, String> other;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setHostAndPortByAddress(String address) {
        int doubleSlashIndex;
        if (address == null) {
            throw new IllegalArgumentException("address is null.");
        }
        int slashIndex = (address = address.trim()).indexOf("/", (doubleSlashIndex = address.indexOf("//")) + 2);
        String hostPortString = slashIndex == -1 ? address.substring(doubleSlashIndex + 2) : address.substring(doubleSlashIndex + 2, slashIndex);
        ArrayList<String> hosts = new ArrayList<String>();
        String portString = null;
        for (String hostPort : hostPortString.split(",")) {
            String[] parts = hostPort.split(":");
            hosts.add(parts[0]);
            if (portString != null || parts.length <= 1) continue;
            portString = parts[1];
        }
        if (hosts.size() == 0 || portString == null) {
            throw new IllegalArgumentException(String.format("host:port '%s' illegal.", hostPortString));
        }
        this.host = String.join((CharSequence)",", hosts);
        this.port = Integer.parseInt(portString);
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getOther() {
        return this.other;
    }

    public void setOther(Map<String, String> other) {
        this.other = other;
    }

    public abstract DbType getType();
}

