/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class InternalHttpAsyncExecRuntime
implements AsyncExecRuntime {
    private final Logger log;
    private final AsyncClientConnectionManager manager;
    private final ConnectionInitiator connectionInitiator;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    @Deprecated
    private final TlsConfig tlsConfig;
    private final AtomicReference<AsyncConnectionEndpoint> endpointRef;
    private final AtomicReference<ReUseData> reuseDataRef;

    InternalHttpAsyncExecRuntime(Logger log, AsyncClientConnectionManager manager, ConnectionInitiator connectionInitiator, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, TlsConfig tlsConfig) {
        this.log = log;
        this.manager = manager;
        this.connectionInitiator = connectionInitiator;
        this.pushHandlerFactory = pushHandlerFactory;
        this.tlsConfig = tlsConfig;
        this.endpointRef = new AtomicReference();
        this.reuseDataRef = new AtomicReference();
    }

    @Override
    public boolean isEndpointAcquired() {
        return this.endpointRef.get() != null;
    }

    @Override
    public Cancellable acquireEndpoint(final String id, HttpRoute route, Object object, HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        if (this.endpointRef.get() == null) {
            RequestConfig requestConfig = context.getRequestConfigOrDefault();
            Timeout connectionRequestTimeout = requestConfig.getConnectionRequestTimeout();
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} acquiring endpoint ({})", (Object)id, (Object)connectionRequestTimeout);
            }
            return Operations.cancellable(this.manager.lease(id, route, object, connectionRequestTimeout, new FutureCallback<AsyncConnectionEndpoint>(){

                public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                    InternalHttpAsyncExecRuntime.this.endpointRef.set(connectionEndpoint);
                    if (InternalHttpAsyncExecRuntime.this.log.isDebugEnabled()) {
                        InternalHttpAsyncExecRuntime.this.log.debug("{} acquired endpoint {}", (Object)id, (Object)ConnPoolSupport.getId(connectionEndpoint));
                    }
                    callback.completed((Object)InternalHttpAsyncExecRuntime.this);
                }

                public void failed(Exception ex) {
                    callback.failed(ex);
                }

                public void cancelled() {
                    callback.cancelled();
                }
            }));
        }
        callback.completed((Object)this);
        return Operations.nonCancellable();
    }

    private void discardEndpoint(AsyncConnectionEndpoint endpoint) {
        try {
            endpoint.close(CloseMode.IMMEDIATE);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} endpoint closed", (Object)ConnPoolSupport.getId(endpoint));
            }
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} discarding endpoint", (Object)ConnPoolSupport.getId(endpoint));
            }
            this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
        }
    }

    @Override
    public void releaseEndpoint() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            ReUseData reUseData = this.reuseDataRef.getAndSet(null);
            if (reUseData != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} releasing valid endpoint", (Object)ConnPoolSupport.getId(endpoint));
                }
                this.manager.release(endpoint, reUseData.state, reUseData.validDuration);
            } else {
                this.discardEndpoint(endpoint);
            }
        }
    }

    @Override
    public void discardEndpoint() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            this.discardEndpoint(endpoint);
        }
    }

    @Override
    public boolean validateConnection() {
        if (this.reuseDataRef != null) {
            AsyncConnectionEndpoint endpoint = this.endpointRef.get();
            return endpoint != null && endpoint.isConnected();
        }
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            this.discardEndpoint(endpoint);
        }
        return false;
    }

    AsyncConnectionEndpoint ensureValid() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public boolean isEndpointConnected() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null && endpoint.isConnected();
    }

    @Override
    public Cancellable connectEndpoint(HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (endpoint.isConnected()) {
            callback.completed((Object)this);
            return Operations.nonCancellable();
        }
        RequestConfig requestConfig = context.getRequestConfigOrDefault();
        Timeout connectTimeout = requestConfig.getConnectTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} connecting endpoint ({})", (Object)ConnPoolSupport.getId(endpoint), (Object)connectTimeout);
        }
        return Operations.cancellable(this.manager.connect(endpoint, this.connectionInitiator, connectTimeout, this.tlsConfig, (HttpContext)context, (FutureCallback<AsyncConnectionEndpoint>)new CallbackContribution<AsyncConnectionEndpoint>(callback){

            public void completed(AsyncConnectionEndpoint endpoint) {
                if (InternalHttpAsyncExecRuntime.this.log.isDebugEnabled()) {
                    InternalHttpAsyncExecRuntime.this.log.debug("{} endpoint connected", (Object)ConnPoolSupport.getId(endpoint));
                }
                if (callback != null) {
                    callback.completed((Object)InternalHttpAsyncExecRuntime.this);
                }
            }
        }));
    }

    @Override
    public void disconnectEndpoint() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint != null) {
            endpoint.close(CloseMode.GRACEFUL);
        }
    }

    @Override
    public void upgradeTls(HttpClientContext context) {
        this.upgradeTls(context, null);
    }

    @Override
    public void upgradeTls(HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} upgrading endpoint", (Object)ConnPoolSupport.getId(endpoint));
        }
        this.manager.upgrade(endpoint, this.tlsConfig, (HttpContext)context, (FutureCallback<AsyncConnectionEndpoint>)new CallbackContribution<AsyncConnectionEndpoint>(callback){

            public void completed(AsyncConnectionEndpoint endpoint) {
                if (callback != null) {
                    callback.completed((Object)InternalHttpAsyncExecRuntime.this);
                }
            }
        });
    }

    @Override
    public EndpointInfo getEndpointInfo() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null ? endpoint.getInfo() : null;
    }

    @Override
    public Cancellable execute(final String id, final AsyncClientExchangeHandler exchangeHandler, final HttpClientContext context) {
        final AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (endpoint.isConnected()) {
            RequestConfig requestConfig;
            Timeout responseTimeout;
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(endpoint), (Object)id);
            }
            if ((responseTimeout = (requestConfig = context.getRequestConfigOrDefault()).getResponseTimeout()) != null) {
                endpoint.setSocketTimeout(responseTimeout);
            }
            endpoint.execute(id, exchangeHandler, this.pushHandlerFactory, (HttpContext)context);
            if (context.getRequestConfigOrDefault().isHardCancellationEnabled()) {
                return () -> {
                    exchangeHandler.cancel();
                    return true;
                };
            }
        } else {
            this.connectEndpoint(context, new FutureCallback<AsyncExecRuntime>(){

                public void completed(AsyncExecRuntime runtime) {
                    if (InternalHttpAsyncExecRuntime.this.log.isDebugEnabled()) {
                        InternalHttpAsyncExecRuntime.this.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(endpoint), (Object)id);
                    }
                    try {
                        endpoint.execute(id, exchangeHandler, (HandlerFactory<AsyncPushConsumer>)InternalHttpAsyncExecRuntime.this.pushHandlerFactory, (HttpContext)context);
                    }
                    catch (RuntimeException ex) {
                        this.failed(ex);
                    }
                }

                public void failed(Exception ex) {
                    exchangeHandler.failed(ex);
                }

                public void cancelled() {
                    exchangeHandler.failed((Exception)new InterruptedIOException());
                }
            });
        }
        return Operations.nonCancellable();
    }

    @Override
    public void markConnectionReusable(Object newState, TimeValue newValidDuration) {
        this.reuseDataRef.set(new ReUseData(newState, newValidDuration));
    }

    @Override
    public void markConnectionNonReusable() {
        this.reuseDataRef.set(null);
    }

    @Override
    public AsyncExecRuntime fork() {
        return new InternalHttpAsyncExecRuntime(this.log, this.manager, this.connectionInitiator, this.pushHandlerFactory, this.tlsConfig);
    }

    static class ReUseData {
        final Object state;
        final TimeValue validDuration;

        ReUseData(Object state, TimeValue validDuration) {
            this.state = state;
            this.validDuration = validDuration;
        }
    }
}

