/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.OutputStreamCreator;

public class FileWriterUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(FileWriterUtil.class);
    private final File target;
    private final OutputStreamCreator osc;

    public FileWriterUtil() throws ToolException {
        this.target = null;
        this.osc = new OutputStreamCreator();
    }

    public FileWriterUtil(String targetDir, OutputStreamCreator osc) throws ToolException {
        this.target = new File(targetDir);
        OutputStreamCreator outputStreamCreator = this.osc = osc == null ? new OutputStreamCreator() : osc;
        if (!this.target.exists() || !this.target.isDirectory()) {
            Message msg = new Message("DIRECTORY_NOT_EXIST", LOG, new Object[]{this.target});
            throw new ToolException(msg);
        }
    }

    public File getFileToWrite(String packageName, String fileName) throws IOException {
        File dir = this.buildDir(packageName);
        File fn = new File(dir, fileName);
        if (fn.exists() && !fn.delete()) {
            throw new IOException(String.valueOf(fn) + ": Can't delete previous version");
        }
        return fn;
    }

    private Writer getWriter(File fn) throws IOException {
        return this.getWriter(fn, StandardCharsets.UTF_8.name());
    }

    public Writer getWriter(File fn, String encoding) throws IOException {
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8.name();
        }
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.osc.createOutputStream(fn)), encoding);
    }

    public Writer getWriter(String packageName, String fileName) throws IOException {
        return this.getWriter(this.getFileToWrite(packageName, fileName));
    }

    public Writer getWriter(String packageName, String fileName, String encoding) throws IOException {
        return this.getWriter(this.getFileToWrite(packageName, fileName), encoding);
    }

    public boolean isCollision(String packageName, String fileName) throws ToolException {
        File dir = this.buildDir(packageName);
        return this.fileExist(dir, fileName);
    }

    public File buildDir(String packageName) {
        File dir = packageName == null ? this.target : new File(this.target, this.toDir(packageName));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private boolean fileExist(File dir, String fileName) {
        return new File(dir, fileName).exists();
    }

    private String toDir(String packageName) {
        return packageName.replace('.', File.separatorChar);
    }
}

