/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IfTest
extends JexlTestCase {
    public IfTest() {
        super("IfTest");
    }

    @Test
    void testBlockElse() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) {1} else {2 ; 3}");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)3, (Object)o, (String)"Result is wrong");
    }

    @Test
    void testBlockIfTrue() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"hello", (Object)o, (String)"Result is wrong");
    }

    @Test
    void testIfElseIfExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) { 10; } else if (x == 2) 20  else 30", new String[]{"x"});
        Object o = e.execute(null, new Object[]{1});
        Assertions.assertEquals((Object)10, (Object)o);
        o = e.execute(null, new Object[]{2});
        Assertions.assertEquals((Object)20, (Object)o);
        o = e.execute(null, new Object[]{4});
        Assertions.assertEquals((Object)30, (Object)o);
    }

    @Test
    void testIfElseIfReturnExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) return 10;  if (x == 2) return 20  else if (x == 3) return 30; else return 40;", new String[]{"x"});
        Object o = e.execute(null, new Object[]{1});
        Assertions.assertEquals((Object)10, (Object)o);
        o = e.execute(null, new Object[]{2});
        Assertions.assertEquals((Object)20, (Object)o);
        o = e.execute(null, new Object[]{3});
        Assertions.assertEquals((Object)30, (Object)o);
        o = e.execute(null, new Object[]{4});
        Assertions.assertEquals((Object)40, (Object)o);
    }

    @Test
    void testIfElseIfReturnExpression0() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) return 10; if (x == 2)  return 20; else if (x == 3) return 30  else { return 40 }", new String[]{"x"});
        Object o = e.execute(null, new Object[]{1});
        Assertions.assertEquals((Object)10, (Object)o);
        o = e.execute(null, new Object[]{2});
        Assertions.assertEquals((Object)20, (Object)o);
        o = e.execute(null, new Object[]{3});
        Assertions.assertEquals((Object)30, (Object)o);
        o = e.execute(null, new Object[]{4});
        Assertions.assertEquals((Object)40, (Object)o);
    }

    @Test
    void testIfWithArithmeticExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if ((x * 2) + 1 == 5) true;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)2);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    @Test
    void testIfWithAssignment() throws Exception {
        JexlScript e = this.JEXL.createScript("if ((x * 2) == 5) {y = 1} else {y = 2;}");
        MapContext jc = new MapContext();
        jc.set("x", (Object)Float.valueOf(2.5f));
        e.execute((JexlContext)jc);
        Object result = jc.get("y");
        Assertions.assertEquals((Object)1, (Object)result, (String)"y has the wrong value");
    }

    @Test
    void testIfWithDecimalArithmeticExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if ((x * 2) == 5) true");
        MapContext jc = new MapContext();
        jc.set("x", (Object)Float.valueOf(2.5f));
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    @Test
    void testIfWithSimpleExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) true;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    @Test
    void testNullCoaelescing() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlExpression xtrue = this.JEXL.createExpression("x??true");
        Object o = xtrue.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)true, (Object)o);
        jc.set("x", false);
        o = xtrue.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)false, (Object)o);
        JexlExpression yone = this.JEXL.createExpression("y??1");
        o = yone.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o);
        jc.set("y", 0);
        o = yone.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)0, (Object)o);
        IfTest.debuggerCheck(this.JEXL);
    }

    @Test
    void testNullCoaelescingScript() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlScript xtrue = this.JEXL.createScript("x??true");
        Object o = xtrue.execute((JexlContext)jc);
        Assertions.assertEquals((Object)true, (Object)o);
        jc.set("x", false);
        o = xtrue.execute((JexlContext)jc);
        Assertions.assertEquals((Object)false, (Object)o);
        JexlScript yone = this.JEXL.createScript("y??1");
        o = yone.execute((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o);
        jc.set("y", 0);
        o = yone.execute((JexlContext)jc);
        Assertions.assertEquals((Object)0, (Object)o);
        IfTest.debuggerCheck(this.JEXL);
    }

    @Test
    void testSimpleElse() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) 1 else 2;");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)2, (Object)o);
    }

    @Test
    void testSimpleIfFalse() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) 1");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o);
    }

    @Test
    void testSimpleIfTrue() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) 1");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o);
    }

    @Test
    void testTernary() throws Exception {
        Object o;
        int l;
        JexlEngine jexl = this.JEXL;
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        JexlExpression e = jexl.createExpression("x.y.z = foo ?'bar':'quux'");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
        }
        jc.set("foo", null);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
        }
        jc.set("foo", Boolean.FALSE);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
        }
        jc.set("foo", Boolean.TRUE);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"bar", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"bar", (Object)o);
        }
        IfTest.debuggerCheck(jexl);
    }

    @Test
    void testTernaryFail() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        JexlExpression e = this.JEXL.createExpression("false ? bar : quux");
        options.setStrict(true);
        options.setSilent(false);
        JexlException xjexl = (JexlException)Assertions.assertThrows(JexlException.class, () -> e.evaluate((JexlContext)jc));
        Assertions.assertTrue((boolean)xjexl.toString().contains("quux"));
    }

    @Test
    void testTernaryShorthand() throws Exception {
        Object o;
        int l;
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        JexlExpression e = this.JEXL.createExpression("x.y.z = foo?:'quux'");
        JexlExpression f = this.JEXL.createExpression("foo??'quux'");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
        }
        jc.set("foo", null);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
        }
        jc.set("foo", Boolean.FALSE);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)false, (Object)o);
        }
        jc.set("foo", Double.NaN);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertTrue((boolean)Double.isNaN((Double)o), (String)"Should be NaN");
        }
        jc.set("foo", "");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"", (Object)o, (String)"Should be empty string");
        }
        jc.set("foo", "false");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"false", (Object)o);
        }
        jc.set("foo", 0.0);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)0.0, (Object)o);
        }
        jc.set("foo", 0);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)0, (Object)o);
        }
        jc.set("foo", "bar");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)"bar", (Object)o);
            o = jc.get("x.y.z");
            Assertions.assertEquals((Object)"bar", (Object)o);
        }
        IfTest.debuggerCheck(this.JEXL);
    }
}

