/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TiffFloatingPointMultivariableTest
extends AbstractTiffTest {
    @TempDir
    Path tempDir;
    int width = 48;
    int height = 23;
    int samplesPerPixel = 2;
    float f0;
    float f1 = 1.0f;
    float[] fSample = new float[this.width * this.height * this.samplesPerPixel];

    public TiffFloatingPointMultivariableTest() {
        for (int iPlane = 0; iPlane < 2; ++iPlane) {
            int pOffset = iPlane * this.width * this.height;
            for (int iRow = 0; iRow < this.height; ++iRow) {
                for (int iCol = 0; iCol < this.width; ++iCol) {
                    int index = pOffset + iRow * this.width + iCol;
                    this.fSample[index] = index;
                }
            }
        }
    }

    private void applyTilePredictor(int nRowsInBlock, int nColsInBlock, byte[] bytes) {
        byte[] b = new byte[bytes.length];
        int bytesInRow = nColsInBlock * 4;
        for (int iPlane = 0; iPlane < this.samplesPerPixel; ++iPlane) {
            int planarByteOffset = iPlane * nRowsInBlock * nColsInBlock * 4;
            for (int i = 0; i < nRowsInBlock; ++i) {
                int j;
                int aOffset = planarByteOffset + i * bytesInRow;
                int bOffset = aOffset + nColsInBlock;
                int cOffset = bOffset + nColsInBlock;
                int dOffset = cOffset + nColsInBlock;
                for (j = 0; j < nColsInBlock; ++j) {
                    b[aOffset + j] = bytes[aOffset + j * 4];
                    b[bOffset + j] = bytes[aOffset + j * 4 + 1];
                    b[cOffset + j] = bytes[aOffset + j * 4 + 2];
                    b[dOffset + j] = bytes[aOffset + j * 4 + 3];
                }
                for (j = bytesInRow - 1; j > 0; --j) {
                    int n = aOffset + j;
                    b[n] = (byte)(b[n] - b[aOffset + j - 1]);
                }
            }
        }
        System.arraycopy(b, 0, bytes, 0, bytes.length);
    }

    private byte[][] getBytesForOutput32(int nRowsInBlock, int nColsInBlock, ByteOrder byteOrder, boolean useTiles, TiffPlanarConfiguration planarConfiguration) {
        int nColsOfBlocks = (this.width + nColsInBlock - 1) / nColsInBlock;
        int nRowsOfBlocks = (this.height + nRowsInBlock + 1) / nRowsInBlock;
        int bytesPerPixel = 4 * this.samplesPerPixel;
        int nBlocks = nRowsOfBlocks * nColsOfBlocks;
        int nBytesInBlock = bytesPerPixel * nRowsInBlock * nColsInBlock;
        byte[][] blocks = new byte[nBlocks][nBytesInBlock];
        if (planarConfiguration == TiffPlanarConfiguration.CHUNKY) {
            for (int i = 0; i < this.height; ++i) {
                int blockRow = i / nRowsInBlock;
                int rowInBlock = i - blockRow * nRowsInBlock;
                for (int j = 0; j < this.width; ++j) {
                    int blockCol = j / nColsInBlock;
                    int colInBlock = j - blockCol * nColsInBlock;
                    byte[] b = blocks[blockRow * nColsOfBlocks + blockCol];
                    for (int k = 0; k < 2; ++k) {
                        float sValue = this.fSample[k * this.width * this.height + i * this.width + j];
                        int sample = Float.floatToRawIntBits(sValue);
                        int offset = (rowInBlock * nColsInBlock + colInBlock) * 8 + k * 4;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            b[offset] = (byte)(sample & 0xFF);
                            b[offset + 1] = (byte)(sample >> 8 & 0xFF);
                            b[offset + 2] = (byte)(sample >> 16 & 0xFF);
                            b[offset + 3] = (byte)(sample >> 24 & 0xFF);
                            continue;
                        }
                        b[offset] = (byte)(sample >> 24 & 0xFF);
                        b[offset + 1] = (byte)(sample >> 16 & 0xFF);
                        b[offset + 2] = (byte)(sample >> 8 & 0xFF);
                        b[offset + 3] = (byte)(sample & 0xFF);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                int blockRow = i / nRowsInBlock;
                int rowInBlock = i - blockRow * nRowsInBlock;
                int blockPlanarOffset = nRowsInBlock * nColsInBlock;
                if (!useTiles && (blockRow + 1) * nRowsInBlock > this.height) {
                    int nRowsAdjusted = this.height - blockRow * nRowsInBlock;
                    blockPlanarOffset = nRowsAdjusted * nColsInBlock;
                }
                for (int j = 0; j < this.width; ++j) {
                    int blockCol = j / nColsInBlock;
                    int colInBlock = j - blockCol * nColsInBlock;
                    byte[] b = blocks[blockRow * nColsOfBlocks + blockCol];
                    for (int k = 0; k < 2; ++k) {
                        float sValue = this.fSample[k * this.width * this.height + i * this.width + j];
                        int sample = Float.floatToRawIntBits(sValue);
                        int offset = (k * blockPlanarOffset + rowInBlock * nColsInBlock + colInBlock) * 4;
                        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                            b[offset] = (byte)(sample & 0xFF);
                            b[offset + 1] = (byte)(sample >> 8 & 0xFF);
                            b[offset + 2] = (byte)(sample >> 16 & 0xFF);
                            b[offset + 3] = (byte)(sample >> 24 & 0xFF);
                            continue;
                        }
                        b[offset] = (byte)(sample >> 24 & 0xFF);
                        b[offset + 1] = (byte)(sample >> 16 & 0xFF);
                        b[offset + 2] = (byte)(sample >> 8 & 0xFF);
                        b[offset + 3] = (byte)(sample & 0xFF);
                    }
                }
            }
        }
        return blocks;
    }

    @Test
    public void test() throws Exception {
        ArrayList<File> testFiles = new ArrayList<File>();
        testFiles.add(this.writeFile(ByteOrder.LITTLE_ENDIAN, false, false, TiffPlanarConfiguration.CHUNKY));
        testFiles.add(this.writeFile(ByteOrder.BIG_ENDIAN, false, false, TiffPlanarConfiguration.CHUNKY));
        testFiles.add(this.writeFile(ByteOrder.LITTLE_ENDIAN, true, false, TiffPlanarConfiguration.CHUNKY));
        testFiles.add(this.writeFile(ByteOrder.BIG_ENDIAN, true, false, TiffPlanarConfiguration.CHUNKY));
        testFiles.add(this.writeFile(ByteOrder.LITTLE_ENDIAN, false, false, TiffPlanarConfiguration.PLANAR));
        testFiles.add(this.writeFile(ByteOrder.BIG_ENDIAN, false, false, TiffPlanarConfiguration.PLANAR));
        testFiles.add(this.writeFile(ByteOrder.LITTLE_ENDIAN, true, false, TiffPlanarConfiguration.PLANAR));
        testFiles.add(this.writeFile(ByteOrder.BIG_ENDIAN, true, false, TiffPlanarConfiguration.PLANAR));
        testFiles.add(this.writeFile(ByteOrder.BIG_ENDIAN, true, true, TiffPlanarConfiguration.PLANAR));
        for (File testFile : testFiles) {
            String name = testFile.getName();
            ByteSource byteSource = ByteSource.file((File)testFile);
            TiffReader tiffReader = new TiffReader(true);
            TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
            TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
            AbstractTiffRasterData raster = directory.getRasterData(new TiffImagingParameters());
            Assertions.assertNotNull((Object)raster, (String)("Failed to get raster from " + name));
            Assertions.assertEquals((int)2, (int)raster.getSamplesPerPixel(), (String)("Invalid samples per pixel in " + name));
            for (int iPlane = 0; iPlane < 2; ++iPlane) {
                int pOffset = iPlane * this.width * this.height;
                for (int iRow = 0; iRow < this.height; ++iRow) {
                    for (int iCol = 0; iCol < this.width; ++iCol) {
                        int index = pOffset + iRow * this.width + iCol;
                        float tValue = this.fSample[index];
                        float rValue = raster.getValue(iCol, iRow, iPlane);
                        Assertions.assertEquals((float)tValue, (float)rValue, (String)("Failed at index x=" + iCol + ", y=" + iRow + ", iPlane=" + iPlane));
                    }
                }
            }
        }
    }

    private File writeFile(ByteOrder byteOrder, boolean useTiles, boolean usePredictorForTiles, TiffPlanarConfiguration planarConfiguration) throws IOException, ImagingException {
        int nColsInBlock;
        int nRowsInBlock;
        String name = String.format("FpMultiVarRoundTrip_%s_%s%s.tiff", planarConfiguration == TiffPlanarConfiguration.CHUNKY ? "Chunky" : "Planar", useTiles ? "Tiles" : "Strips", usePredictorForTiles ? "_Predictor" : "");
        File outputFile = new File(this.tempDir.toFile(), name);
        int bytesPerSample = 4 * this.samplesPerPixel;
        int bitsPerSample = 8 * bytesPerSample;
        if (useTiles) {
            nRowsInBlock = 12;
            nColsInBlock = 20;
        } else {
            nRowsInBlock = 2;
            nColsInBlock = this.width;
        }
        int nBytesInBlock = nRowsInBlock * nColsInBlock * bytesPerSample;
        byte[][] blocks = this.getBytesForOutput32(nRowsInBlock, nColsInBlock, byteOrder, useTiles, planarConfiguration);
        TiffOutputSet outputSet = new TiffOutputSet(byteOrder);
        TiffOutputDirectory outDir = outputSet.addRootDirectory();
        outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, new int[]{this.width});
        outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, new int[]{this.height});
        outDir.add(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, new short[]{3});
        outDir.add(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL, (short)this.samplesPerPixel);
        outDir.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, new short[]{(short)bitsPerSample});
        outDir.add(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_COMPRESSION, (short)1);
        if (useTiles && usePredictorForTiles) {
            outDir.add(TiffTagConstants.TIFF_TAG_PREDICTOR, (short)3);
            for (byte[] block : blocks) {
                this.applyTilePredictor(nRowsInBlock, nColsInBlock, block);
            }
        }
        if (planarConfiguration == TiffPlanarConfiguration.CHUNKY) {
            outDir.add(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION, (short)1);
        } else {
            outDir.add(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION, (short)2);
        }
        if (useTiles) {
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_WIDTH, new int[]{nColsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_LENGTH, new int[]{nRowsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS, new int[]{nBytesInBlock});
        } else {
            outDir.add(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP, new int[]{nRowsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS, new int[]{nBytesInBlock});
        }
        AbstractTiffElement.DataElement[] imageData = new AbstractTiffElement.DataElement[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            imageData[i] = new AbstractTiffImageData.Data(0L, blocks[i].length, blocks[i]);
        }
        Object abstractTiffImageData = useTiles ? new AbstractTiffImageData.Tiles(imageData, nColsInBlock, nRowsInBlock) : new AbstractTiffImageData.Strips(imageData, nRowsInBlock);
        outDir.setTiffImageData((AbstractTiffImageData)abstractTiffImageData);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            TiffImageWriterLossy writer = new TiffImageWriterLossy(byteOrder);
            writer.write((OutputStream)bos, outputSet);
            bos.flush();
        }
        return outputFile;
    }
}

