/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.naming.java.javaURLContextFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestJndi {
    protected static final String JNDI_SUBCONTEXT = "jdbc";
    protected static final String JNDI_PATH = "jdbc/jndiTestDataSource";
    protected Context context;

    protected void bindDataSource(DataSource dataSource) throws Exception {
        this.context.bind(JNDI_PATH, (Object)dataSource);
    }

    protected void checkBind(DataSource dataSource) throws Exception {
        this.bindDataSource(dataSource);
        this.retrieveDataSource();
    }

    protected InitialContext getInitialContext() throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", javaURLContextFactory.class.getName());
        return new InitialContext(environment);
    }

    protected DataSource retrieveDataSource() throws Exception {
        InitialContext ctx = this.getInitialContext();
        DataSource dataSource = (DataSource)ctx.lookup(JNDI_PATH);
        Assertions.assertNotNull((Object)dataSource, (String)"DataSource should not be null");
        return dataSource;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.context = this.getInitialContext();
        this.context.createSubcontext(JNDI_SUBCONTEXT);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.context.unbind(JNDI_PATH);
        this.context.destroySubcontext(JNDI_SUBCONTEXT);
    }

    @Test
    void testBasicDataSourceBind() throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        this.checkBind((DataSource)dataSource);
    }

    @Test
    void testPerUserPoolDataSourceBind() throws Exception {
        PerUserPoolDataSource dataSource = new PerUserPoolDataSource();
        this.checkBind((DataSource)dataSource);
    }

    @Test
    void testSharedPoolDataSourceBind() throws Exception {
        SharedPoolDataSource dataSource = new SharedPoolDataSource();
        this.checkBind((DataSource)dataSource);
    }
}

