/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.NoReplicationTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.ReplicationAwareTokenAllocator;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorBase;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorEvent;
import org.apache.cassandra.diag.DiagnosticEventService;

final class TokenAllocatorDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private TokenAllocatorDiagnostics() {
    }

    static <Unit> void noReplicationTokenAllocatorInstanciated(NoReplicationTokenAllocator<Unit> allocator) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.NO_REPLICATION_AWARE_TOKEN_ALLOCATOR_INSTANCIATED)) {
            service.publish(new TokenAllocatorEvent<Object>(TokenAllocatorEvent.TokenAllocatorEventType.NO_REPLICATION_AWARE_TOKEN_ALLOCATOR_INSTANCIATED, allocator, null, null, null, null, null, null, null));
        }
    }

    static <Unit> void replicationTokenAllocatorInstanciated(ReplicationAwareTokenAllocator<Unit> allocator) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.REPLICATION_AWARE_TOKEN_ALLOCATOR_INSTANCIATED)) {
            service.publish(new TokenAllocatorEvent<Object>(TokenAllocatorEvent.TokenAllocatorEventType.REPLICATION_AWARE_TOKEN_ALLOCATOR_INSTANCIATED, allocator, null, null, null, null, null, null, null));
        }
    }

    static <Unit> void unitedAdded(TokenAllocatorBase<Unit> allocator, int numTokens, Queue<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits, NavigableMap<Token, Unit> sortedTokens, List<Token> tokens, Unit unit) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_ADDED)) {
            service.publish(new TokenAllocatorEvent<Unit>(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_ADDED, allocator, numTokens, (ImmutableList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>>)ImmutableList.copyOf(sortedUnits), null, ImmutableMap.copyOf(sortedTokens), (ImmutableList<Token>)ImmutableList.copyOf(tokens), unit, null));
        }
    }

    static <Unit> void unitedAdded(TokenAllocatorBase<Unit> allocator, int numTokens, Multimap<Unit, Token> unitToTokens, NavigableMap<Token, Unit> sortedTokens, List<Token> tokens, Unit unit) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_ADDED)) {
            service.publish(new TokenAllocatorEvent<Unit>(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_ADDED, allocator, numTokens, null, ImmutableMap.copyOf((Map)unitToTokens.asMap()), ImmutableMap.copyOf(sortedTokens), (ImmutableList<Token>)ImmutableList.copyOf(tokens), unit, null));
        }
    }

    static <Unit> void unitRemoved(TokenAllocatorBase<Unit> allocator, Unit unit, Queue<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits, Map<Token, Unit> sortedTokens) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_REMOVED)) {
            service.publish(new TokenAllocatorEvent<Unit>(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_REMOVED, allocator, null, (ImmutableList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>>)ImmutableList.copyOf(sortedUnits), null, ImmutableMap.copyOf(sortedTokens), null, unit, null));
        }
    }

    static <Unit> void unitRemoved(TokenAllocatorBase<Unit> allocator, Unit unit, Multimap<Unit, Token> unitToTokens, Map<Token, Unit> sortedTokens) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_REMOVED)) {
            service.publish(new TokenAllocatorEvent<Unit>(TokenAllocatorEvent.TokenAllocatorEventType.UNIT_REMOVED, allocator, null, null, ImmutableMap.copyOf((Map)unitToTokens.asMap()), ImmutableMap.copyOf(sortedTokens), null, unit, null));
        }
    }

    static <Unit> void tokenInfosCreated(TokenAllocatorBase<Unit> allocator, Queue<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits, Map<Token, Unit> sortedTokens, TokenAllocatorBase.TokenInfo<Unit> tokenInfo) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.TOKEN_INFOS_CREATED)) {
            service.publish(new TokenAllocatorEvent<Object>(TokenAllocatorEvent.TokenAllocatorEventType.TOKEN_INFOS_CREATED, allocator, null, (ImmutableList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>>)ImmutableList.copyOf(sortedUnits), null, ImmutableMap.copyOf(sortedTokens), null, null, tokenInfo));
        }
    }

    static <Unit> void tokenInfosCreated(TokenAllocatorBase<Unit> allocator, Multimap<Unit, Token> unitToTokens, TokenAllocatorBase.TokenInfo<Unit> tokenInfo) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.TOKEN_INFOS_CREATED)) {
            service.publish(new TokenAllocatorEvent<Object>(TokenAllocatorEvent.TokenAllocatorEventType.TOKEN_INFOS_CREATED, allocator, null, null, ImmutableMap.copyOf((Map)unitToTokens.asMap()), null, null, null, tokenInfo));
        }
    }

    static <Unit> void splitsGenerated(TokenAllocatorBase<Unit> allocator, int numTokens, Queue<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits, NavigableMap<Token, Unit> sortedTokens, Unit newUnit, Collection<Token> tokens) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.RANDOM_TOKENS_GENERATED)) {
            service.publish(new TokenAllocatorEvent<Unit>(TokenAllocatorEvent.TokenAllocatorEventType.RANDOM_TOKENS_GENERATED, allocator, numTokens, (ImmutableList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>>)ImmutableList.copyOf(sortedUnits), null, ImmutableMap.copyOf(sortedTokens), (ImmutableList<Token>)ImmutableList.copyOf(tokens), newUnit, null));
        }
    }

    static <Unit> void splitsGenerated(TokenAllocatorBase<Unit> allocator, int numTokens, Multimap<Unit, Token> unitToTokens, NavigableMap<Token, Unit> sortedTokens, Unit newUnit, Collection<Token> tokens) {
        if (TokenAllocatorDiagnostics.isEnabled(TokenAllocatorEvent.TokenAllocatorEventType.RANDOM_TOKENS_GENERATED)) {
            service.publish(new TokenAllocatorEvent<Unit>(TokenAllocatorEvent.TokenAllocatorEventType.RANDOM_TOKENS_GENERATED, allocator, numTokens, null, ImmutableMap.copyOf((Map)unitToTokens.asMap()), ImmutableMap.copyOf(sortedTokens), (ImmutableList<Token>)ImmutableList.copyOf(tokens), newUnit, null));
        }
    }

    private static boolean isEnabled(TokenAllocatorEvent.TokenAllocatorEventType type) {
        return service.isEnabled(TokenAllocatorEvent.class, type);
    }
}

