/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;

public class AuditLogEntry {
    private final InetAddressAndPort host = FBUtilities.getBroadcastAddressAndPort();
    private final InetAddressAndPort source;
    private final String user;
    private final long timestamp;
    private final AuditLogEntryType type;
    private final UUID batch;
    private final String keyspace;
    private final String scope;
    private final String operation;
    private final QueryOptions options;
    private final QueryState state;

    private AuditLogEntry(AuditLogEntryType type, InetAddressAndPort source, String user, long timestamp, UUID batch, String keyspace, String scope, String operation, QueryOptions options, QueryState state) {
        this.type = type;
        this.source = source;
        this.user = user;
        this.timestamp = timestamp;
        this.batch = batch;
        this.keyspace = keyspace;
        this.scope = scope;
        this.operation = operation;
        this.options = options;
        this.state = state;
    }

    String getLogString() {
        StringBuilder builder = new StringBuilder(100);
        builder.append("user:").append(this.user).append("|host:").append(this.host).append("|source:").append(this.source.address);
        if (this.source.port > 0) {
            builder.append("|port:").append(this.source.port);
        }
        builder.append("|timestamp:").append(this.timestamp).append("|type:").append((Object)this.type).append("|category:").append((Object)this.type.getCategory());
        if (this.batch != null) {
            builder.append("|batch:").append(this.batch);
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyspace)) {
            builder.append("|ks:").append(this.keyspace);
        }
        if (StringUtils.isNotBlank((CharSequence)this.scope)) {
            builder.append("|scope:").append(this.scope);
        }
        if (StringUtils.isNotBlank((CharSequence)this.operation)) {
            builder.append("|operation:").append(this.operation);
        }
        return builder.toString();
    }

    public InetAddressAndPort getHost() {
        return this.host;
    }

    public InetAddressAndPort getSource() {
        return this.source;
    }

    public String getUser() {
        return this.user;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AuditLogEntryType getType() {
        return this.type;
    }

    public UUID getBatch() {
        return this.batch;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getScope() {
        return this.scope;
    }

    public String getOperation() {
        return this.operation;
    }

    public QueryOptions getOptions() {
        return this.options;
    }

    public QueryState getState() {
        return this.state;
    }

    public static class Builder {
        private static final InetAddressAndPort DEFAULT_SOURCE;
        private static final String DEFAULT_OPERATION = "";
        private AuditLogEntryType type;
        private InetAddressAndPort source;
        private String user;
        private long timestamp;
        private UUID batch;
        private String keyspace;
        private String scope;
        private String operation;
        private QueryOptions options;
        private QueryState state;

        public Builder(QueryState queryState) {
            this.state = queryState;
            ClientState clientState = queryState.getClientState();
            if (clientState != null) {
                if (clientState.getRemoteAddress() != null) {
                    InetSocketAddress addr = clientState.getRemoteAddress();
                    this.source = InetAddressAndPort.getByAddressOverrideDefaults(addr.getAddress(), addr.getPort());
                }
                if (clientState.getUser() != null) {
                    this.user = clientState.getUser().getName();
                }
                this.keyspace = clientState.getRawKeyspace();
            } else {
                this.source = DEFAULT_SOURCE;
                this.user = AuthenticatedUser.SYSTEM_USER.getName();
            }
            this.timestamp = System.currentTimeMillis();
        }

        public Builder(AuditLogEntry entry) {
            this.type = entry.type;
            this.source = entry.source;
            this.user = entry.user;
            this.timestamp = entry.timestamp;
            this.batch = entry.batch;
            this.keyspace = entry.keyspace;
            this.scope = entry.scope;
            this.operation = entry.operation;
            this.options = entry.options;
            this.state = entry.state;
        }

        public Builder setType(AuditLogEntryType type) {
            this.type = type;
            return this;
        }

        public Builder(AuditLogEntryType type) {
            this.type = type;
            this.operation = DEFAULT_OPERATION;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setBatch(UUID batch) {
            this.batch = batch;
            return this;
        }

        public Builder setTimestamp(long timestampMillis) {
            this.timestamp = timestampMillis;
            return this;
        }

        public Builder setKeyspace(QueryState queryState, @Nullable CQLStatement statement) {
            this.keyspace = statement != null && statement.getAuditLogContext().keyspace != null ? statement.getAuditLogContext().keyspace : queryState.getClientState().getRawKeyspace();
            return this;
        }

        public Builder setKeyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder setKeyspace(CQLStatement statement) {
            this.keyspace = statement.getAuditLogContext().keyspace;
            return this;
        }

        public Builder setScope(CQLStatement statement) {
            this.scope = statement.getAuditLogContext().scope;
            return this;
        }

        public Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public void appendToOperation(String str) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                this.operation = this.operation.isEmpty() ? str : this.operation.concat("; ").concat(str);
            }
        }

        public Builder setOptions(QueryOptions options) {
            this.options = options;
            return this;
        }

        public AuditLogEntry build() {
            this.timestamp = this.timestamp > 0L ? this.timestamp : System.currentTimeMillis();
            return new AuditLogEntry(this.type, this.source, this.user, this.timestamp, this.batch, this.keyspace, this.scope, this.operation, this.options, this.state);
        }

        static {
            try {
                DEFAULT_SOURCE = InetAddressAndPort.getByNameOverrideDefaults("0.0.0.0", 0);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("failed to create default source address", e);
            }
        }
    }
}

