/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.SettableFeature;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.WriteLimiter;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.util.SimplePermitLimiter;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWriteLimiter {
    static final Logger LOG = LoggerFactory.getLogger(TestWriteLimiter.class);

    SimplePermitLimiter createPermitLimiter(boolean darkmode, int permits) {
        return this.createPermitLimiter(darkmode, permits, (Feature)new SettableFeature("", 0));
    }

    SimplePermitLimiter createPermitLimiter(boolean darkmode, int permits, Feature feature) {
        return new SimplePermitLimiter(darkmode, permits, (StatsLogger)new NullStatsLogger(), false, feature);
    }

    @Test(timeout=60000L)
    public void testGlobalOnly() throws Exception {
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(false, Integer.MAX_VALUE);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(false, 1);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        try {
            limiter.acquire();
            Assert.fail((String)"should have thrown global limit exception");
        }
        catch (OverCapacityException overCapacityException) {
            // empty catch block
        }
        this.assertPermits(streamLimiter, 1, globalLimiter, 1);
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    @Test(timeout=60000L)
    public void testStreamOnly() throws Exception {
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(false, 1);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(false, Integer.MAX_VALUE);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        try {
            limiter.acquire();
            Assert.fail((String)"should have thrown stream limit exception");
        }
        catch (OverCapacityException overCapacityException) {
            // empty catch block
        }
        this.assertPermits(streamLimiter, 1, globalLimiter, 1);
    }

    @Test(timeout=60000L)
    public void testDarkmode() throws Exception {
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(true, Integer.MAX_VALUE);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(true, 1);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
    }

    @Test(timeout=60000L)
    public void testDarkmodeWithDisabledFeature() throws Exception {
        SettableFeature feature = new SettableFeature("test", 10000);
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(true, 1, (Feature)feature);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(true, Integer.MAX_VALUE, (Feature)feature);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
        limiter.release();
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    @Test(timeout=60000L)
    public void testDisabledFeature() throws Exception {
        SettableFeature feature = new SettableFeature("test", 10000);
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(false, 1, (Feature)feature);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(false, Integer.MAX_VALUE, (Feature)feature);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
        limiter.release();
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    @Test(timeout=60000L)
    public void testSetDisableFeatureAfterAcquireAndBeforeRelease() throws Exception {
        SettableFeature feature = new SettableFeature("test", 0);
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(false, 2, (Feature)feature);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(false, Integer.MAX_VALUE, (Feature)feature);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
        feature.set(10000);
        limiter.release();
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    @Test(timeout=60000L)
    public void testUnsetDisableFeatureAfterPermitsExceeded() throws Exception {
        SettableFeature feature = new SettableFeature("test", 10000);
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(false, 1, (Feature)feature);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(false, Integer.MAX_VALUE, (Feature)feature);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 4, globalLimiter, 4);
        feature.set(0);
        limiter.release();
        this.assertPermits(streamLimiter, 3, globalLimiter, 3);
        try {
            limiter.acquire();
            Assert.fail((String)"should have thrown stream limit exception");
        }
        catch (OverCapacityException overCapacityException) {
            // empty catch block
        }
        this.assertPermits(streamLimiter, 3, globalLimiter, 3);
        limiter.release();
        limiter.release();
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    @Test(timeout=60000L)
    public void testUnsetDisableFeatureBeforePermitsExceeded() throws Exception {
        SettableFeature feature = new SettableFeature("test", 0);
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(false, 1, (Feature)feature);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(false, Integer.MAX_VALUE, (Feature)feature);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        try {
            limiter.acquire();
            Assert.fail((String)"should have thrown stream limit exception");
        }
        catch (OverCapacityException overCapacityException) {
            // empty catch block
        }
        this.assertPermits(streamLimiter, 1, globalLimiter, 1);
        feature.set(10000);
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
    }

    @Test(timeout=60000L)
    public void testDarkmodeGlobalUnderStreamOver() throws Exception {
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(true, 1);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(true, 2);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
        limiter.release();
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    @Test(timeout=60000L)
    public void testDarkmodeGlobalOverStreamUnder() throws Exception {
        SimplePermitLimiter streamLimiter = this.createPermitLimiter(true, 2);
        SimplePermitLimiter globalLimiter = this.createPermitLimiter(true, 1);
        WriteLimiter limiter = new WriteLimiter("test", (PermitLimiter)streamLimiter, (PermitLimiter)globalLimiter);
        limiter.acquire();
        limiter.acquire();
        this.assertPermits(streamLimiter, 2, globalLimiter, 2);
        limiter.release();
        this.assertPermits(streamLimiter, 1, globalLimiter, 1);
        limiter.release();
        this.assertPermits(streamLimiter, 0, globalLimiter, 0);
    }

    void assertPermits(SimplePermitLimiter streamLimiter, int streamPermits, SimplePermitLimiter globalLimiter, int globalPermits) {
        Assert.assertEquals((long)streamPermits, (long)streamLimiter.getPermits());
        Assert.assertEquals((long)globalPermits, (long)globalLimiter.getPermits());
    }
}

