/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.databinding.CTypeMapper;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMapperExtension
implements CodeGenExtension {
    private static final String MAPPING_ELEMENT_NAME = "mapping";
    private static final String NAMESPACE_ATTRIBUTE_NAME = "namespace";
    private static final String QNAME_ELEMENT_NAME = "qname";
    private static final String VALUE_ELEMENT_NAME = "value";
    private static final String DB_FRAMEWORK_ATTRIBUTE_NAME = "dbf";

    @Override
    public void engage(CodeGenConfiguration configuration) throws CodeGenerationException {
        if (configuration.getTypeMappingFile() != null) {
            Document mappingDocument;
            Element rootMappingsElement;
            String databindingName;
            TypeMapper mapper = configuration.getTypeMapper();
            if (mapper == null) {
                mapper = configuration.getOutputLanguage() != null && !configuration.getOutputLanguage().trim().equals("") && configuration.getOutputLanguage().toLowerCase().equals("c") ? new CTypeMapper() : new DefaultTypeMapper();
            }
            if (!(databindingName = (rootMappingsElement = (mappingDocument = this.buildDocument(configuration)).getDocumentElement()).getAttribute(DB_FRAMEWORK_ATTRIBUTE_NAME)).equals(configuration.getDatabindingType())) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.databindingMismatch"));
            }
            configuration.setDatabindingType(databindingName);
            NodeList mappingList = rootMappingsElement.getElementsByTagName(MAPPING_ELEMENT_NAME);
            int length = mappingList.getLength();
            for (int i = 0; i < length; ++i) {
                Element mappingNode = (Element)mappingList.item(i);
                Element qNameChild = (Element)mappingNode.getElementsByTagName(QNAME_ELEMENT_NAME).item(0);
                Element valueChild = (Element)mappingNode.getElementsByTagName(VALUE_ELEMENT_NAME).item(0);
                mapper.addTypeMappingName(new QName(qNameChild.getAttribute(NAMESPACE_ATTRIBUTE_NAME), this.getTextFromElement(qNameChild)), this.getTextFromElement(valueChild));
            }
            configuration.setTypeMapper(mapper);
        }
    }

    private Document buildDocument(CodeGenConfiguration configuration) throws CodeGenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(configuration.getTypeMappingFile());
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private String getTextFromElement(Element elt) {
        NodeList children = elt.getChildNodes();
        String returnString = null;
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (3 != node.getNodeType()) continue;
            returnString = (String)(returnString == null ? "" : returnString) + node.getNodeValue();
        }
        return returnString;
    }
}

