/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import java.util.Hashtable;
import java.util.Objects;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

@Mixin
public abstract class DOMNodeMixin
implements DOMNode {
    private Hashtable userData;

    @Override
    public final boolean isSupported(String feature, String version) {
        return this.getDOMNodeFactory().hasFeature(feature, version);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return null;
            }
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() == 0) {
                return null;
            }
            String namespaceURI = context.coreLookupNamespaceURI(prefix, DOMSemantics.INSTANCE);
            return namespaceURI == null || namespaceURI.length() == 0 ? null : namespaceURI;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return null;
            }
            if (namespaceURI == null) {
                return null;
            }
            String prefix = context.coreLookupPrefix(namespaceURI, DOMSemantics.INSTANCE);
            return prefix == null || prefix.length() == 0 ? null : prefix;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return false;
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            return namespaceURI.equals(context.coreLookupNamespaceURI("", DOMSemantics.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node cloneNode(boolean deep) {
        try {
            DOMNode clone = (DOMNode)this.coreClone(deep ? DOMSemantics.DEEP_CLONE : DOMSemantics.SHALLOW_CLONE, null);
            if (!(clone instanceof DOMDocument)) {
                clone.coreSetOwnerDocument(this.coreGetOwnerDocument(true));
            }
            return clone;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public void normalize() {
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)9);
    }

    @Override
    public boolean isSameNode(Node node) {
        return this == node;
    }

    @Override
    public boolean isEqualNode(Node other) {
        NamedNodeMap otherAttributes;
        if (!(this.getNodeType() == other.getNodeType() && Objects.equals(this.getNodeName(), other.getNodeName()) && Objects.equals(this.getLocalName(), other.getLocalName()) && Objects.equals(this.getNamespaceURI(), other.getNamespaceURI()) && Objects.equals(this.getPrefix(), other.getPrefix()) && Objects.equals(this.getNodeValue(), other.getNodeValue()))) {
            return false;
        }
        NamedNodeMap attributes = this.getAttributes();
        if (attributes == null ^ (otherAttributes = other.getAttributes()) == null) {
            return false;
        }
        if (attributes != null) {
            if (attributes.getLength() != otherAttributes.getLength()) {
                return false;
            }
            int itemCount = attributes.getLength();
            for (int a = 0; a < itemCount; ++a) {
                Node attribute = attributes.item(a);
                Node otherAttribute = otherAttributes.getNamedItem(attribute.getNodeName());
                if (otherAttribute != null && attribute.isEqualNode(otherAttribute)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object setUserData(String key, Object value, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        return this.userData.put(key, value);
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    final DOMDocument ownerDocument() {
        return (DOMDocument)this.coreGetOwnerDocument(true);
    }
}

