/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl.jaxws;

import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.util.LogWriter;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class JAXWS2WSDLCodegenEngine {
    private static final Log log = LogFactory.getLog(JAXWS2WSDLCodegenEngine.class);
    private Map<String, Java2WSDLCommandLineOption> optionsMap;
    private String[] originalArgs;
    public static final String WS_GEN_FILE_OUTPUT_DIR = "-d";
    public static final String WS_GEN_CLASSPATH = "-cp";
    public static final String WS_GEN_KEEP_FILE = "-keep";
    public static final String WS_GEN_WSDL = "-wsdl";
    public static final String WS_GEN_EXTENSION = "-extension";
    public static final String WS_GEN_NO_COMPILE = "-Xnocompile";

    public JAXWS2WSDLCodegenEngine(Map<String, Java2WSDLCommandLineOption> optionsMap, String[] originalArgs) {
        this.optionsMap = optionsMap;
        this.originalArgs = originalArgs;
    }

    public void generate() throws Exception {
        WsgenTool genTool = new WsgenTool((OutputStream)new WriterOutputStream((Writer)new LogWriter(log)));
        ArrayList<String> args = new ArrayList<String>();
        this.configurImportToolOptions(args);
        this.mergeOriginalArgs(args);
        boolean success = genTool.run(args.toArray(new String[args.size()]));
        if (success) {
            log.info((Object)"Code generation completed");
        }
    }

    private void configurImportToolOptions(List<String> args) {
        String className;
        String classPath;
        args.add(WS_GEN_EXTENSION);
        args.add(WS_GEN_NO_COMPILE);
        args.add(WS_GEN_KEEP_FILE);
        args.add(WS_GEN_WSDL);
        String location = JAXWS2WSDLCodegenEngine.getOptionValue(this.optionsMap, "o");
        if (location == null) {
            location = JAXWS2WSDLCodegenEngine.getOptionValue(this.optionsMap, "output");
        }
        if (location != null) {
            args.add(WS_GEN_FILE_OUTPUT_DIR);
            args.add(location);
        }
        if ((classPath = JAXWS2WSDLCodegenEngine.getOptionValue(this.optionsMap, "cp")) == null) {
            classPath = JAXWS2WSDLCodegenEngine.getOptionValue(this.optionsMap, "classPath");
        }
        if (classPath != null) {
            args.add(WS_GEN_CLASSPATH);
            args.add(classPath);
        }
        if ((className = JAXWS2WSDLCodegenEngine.getOptionValue(this.optionsMap, "cn")) == null) {
            className = JAXWS2WSDLCodegenEngine.getOptionValue(this.optionsMap, "className");
        }
        if (className != null) {
            args.add(className);
        }
    }

    private void mergeOriginalArgs(List<String> args) {
        ArrayList<String> axisOptionList = new ArrayList<String>();
        ArrayList<String> originalArgsOps = new ArrayList<String>(Arrays.asList(this.originalArgs));
        originalArgsOps.remove("-".concat("jws"));
        originalArgsOps.remove("-".concat("jax_ws_service"));
        Field[] allFields = Java2WSDLConstants.class.getFields();
        Iterator<String> mapItr = this.optionsMap.keySet().iterator();
        for (Field field : allFields) {
            if (!String.class.equals(field.getType())) continue;
            try {
                axisOptionList.add((String)field.get(Java2WSDLConstants.class));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        while (mapItr.hasNext()) {
            Java2WSDLCommandLineOption op = this.optionsMap.get(mapItr.next());
            if (!axisOptionList.contains(op.getOptionType())) continue;
            if (op.getOptionType() != null) {
                originalArgsOps.remove("-".concat(op.getOptionType()));
            }
            if (op.getOptionValue() == null) continue;
            originalArgsOps.remove(op.getOptionValue());
        }
        args.addAll(originalArgsOps);
        log.debug((Object)("Original WSImport options" + Arrays.asList(originalArgsOps)));
        log.debug((Object)("All WSImport options" + Arrays.asList(args)));
    }

    private static String getOptionValue(Map allOptions, String optionName) {
        Java2WSDLCommandLineOption option = (Java2WSDLCommandLineOption)allOptions.get(optionName);
        if (option != null) {
            return option.getOptionValue().toString();
        }
        return null;
    }
}

