/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.generate.ValueCodeGenerator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.aot.AotBeanProcessingException;
import org.springframework.beans.factory.aot.AotServices;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanDefinitionPropertiesCodeGenerator;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.aot.InstanceSupplierCodeGenerator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.SingletonSupplier;

class DefaultBeanRegistrationCodeFragments
implements BeanRegistrationCodeFragments {
    private static final ValueCodeGenerator valueCodeGenerator = ValueCodeGenerator.withDefaults();
    private final BeanRegistrationsCode beanRegistrationsCode;
    private final RegisteredBean registeredBean;
    private final BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory;
    private final Supplier<RegisteredBean.InstantiationDescriptor> instantiationDescriptor;

    DefaultBeanRegistrationCodeFragments(BeanRegistrationsCode beanRegistrationsCode, RegisteredBean registeredBean, BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory) {
        this.beanRegistrationsCode = beanRegistrationsCode;
        this.registeredBean = registeredBean;
        this.beanDefinitionMethodGeneratorFactory = beanDefinitionMethodGeneratorFactory;
        this.instantiationDescriptor = SingletonSupplier.of(registeredBean::resolveInstantiationDescriptor);
    }

    @Override
    public ClassName getTarget(RegisteredBean registeredBean) {
        if (this.hasInstanceSupplier()) {
            throw new AotBeanProcessingException(registeredBean, "instance supplier is not supported");
        }
        Class<?> target = this.extractDeclaringClass(registeredBean, this.instantiationDescriptor.get());
        while (target.getName().startsWith("java.") && registeredBean.isInnerBean()) {
            RegisteredBean parent = registeredBean.getParent();
            Assert.state((parent != null ? 1 : 0) != 0, (String)"No parent available for inner bean");
            target = parent.getBeanClass();
        }
        return target.isArray() ? ClassName.get(target.getComponentType()) : ClassName.get(target);
    }

    private Class<?> extractDeclaringClass(RegisteredBean registeredBean, RegisteredBean.InstantiationDescriptor instantiationDescriptor) {
        Constructor ctor;
        Class declaringClass = ClassUtils.getUserClass(instantiationDescriptor.targetClass());
        Executable executable = instantiationDescriptor.executable();
        if (executable instanceof Constructor && AccessControl.forMember((Member)(ctor = (Constructor)executable)).isPublic() && FactoryBean.class.isAssignableFrom(declaringClass)) {
            return this.extractTargetClassFromFactoryBean(declaringClass, registeredBean.getBeanType());
        }
        return declaringClass;
    }

    private Class<?> extractTargetClassFromFactoryBean(Class<?> factoryBeanType, ResolvableType beanType) {
        ResolvableType target = ResolvableType.forType(factoryBeanType).as(FactoryBean.class).getGeneric(new int[]{0});
        if (target.getType().equals(Class.class)) {
            return target.toClass();
        }
        if (factoryBeanType.isAssignableFrom(beanType.toClass())) {
            return beanType.as(FactoryBean.class).getGeneric(new int[]{0}).toClass();
        }
        return beanType.toClass();
    }

    @Override
    public CodeBlock generateNewBeanDefinitionCode(GenerationContext generationContext, ResolvableType beanType, BeanRegistrationCode beanRegistrationCode) {
        CodeBlock.Builder code = CodeBlock.builder();
        RootBeanDefinition mbd = this.registeredBean.getMergedBeanDefinition();
        Class beanClass = mbd.hasBeanClass() ? ClassUtils.getUserClass(mbd.getBeanClass()) : null;
        CodeBlock beanClassCode = this.generateBeanClassCode(beanRegistrationCode.getClassName().packageName(), beanClass != null ? beanClass : beanType.toClass());
        code.addStatement("$T $L = new $T($L)", new Object[]{RootBeanDefinition.class, "beanDefinition", RootBeanDefinition.class, beanClassCode});
        if (this.targetTypeNecessary(beanType, beanClass)) {
            code.addStatement("$L.setTargetType($L)", new Object[]{"beanDefinition", this.generateBeanTypeCode(beanType)});
        }
        return code.build();
    }

    private CodeBlock generateBeanClassCode(String targetPackage, Class<?> beanClass) {
        if (Modifier.isPublic(beanClass.getModifiers()) || targetPackage.equals(beanClass.getPackageName())) {
            return CodeBlock.of((String)"$T.class", (Object[])new Object[]{beanClass});
        }
        return CodeBlock.of((String)"$S", (Object[])new Object[]{beanClass.getName()});
    }

    private CodeBlock generateBeanTypeCode(ResolvableType beanType) {
        if (!beanType.hasGenerics()) {
            return valueCodeGenerator.generateCode((Object)ClassUtils.getUserClass((Class)beanType.toClass()));
        }
        return valueCodeGenerator.generateCode((Object)beanType);
    }

    private boolean targetTypeNecessary(ResolvableType beanType, @Nullable Class<?> beanClass) {
        if (beanType.hasGenerics()) {
            return true;
        }
        if (beanClass != null && this.registeredBean.getMergedBeanDefinition().getFactoryMethodName() != null) {
            return true;
        }
        return beanClass != null && !beanType.toClass().equals(ClassUtils.getUserClass(beanClass));
    }

    @Override
    public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
        AotServices.Loader loader = AotServices.factories(this.registeredBean.getBeanFactory().getBeanClassLoader());
        List<ValueCodeGenerator.Delegate> additionalDelegates = loader.load(ValueCodeGenerator.Delegate.class).asList();
        return new BeanDefinitionPropertiesCodeGenerator(generationContext.getRuntimeHints(), attributeFilter, beanRegistrationCode.getMethods(), additionalDelegates, (name, value) -> this.generateValueCode(generationContext, (String)name, value)).generateCode(beanDefinition);
    }

    @Nullable
    protected CodeBlock generateValueCode(GenerationContext generationContext, String name, Object value) {
        RegisteredBean innerRegisteredBean = this.getInnerRegisteredBean(value);
        if (innerRegisteredBean != null) {
            BeanDefinitionMethodGenerator methodGenerator = this.beanDefinitionMethodGeneratorFactory.getBeanDefinitionMethodGenerator(innerRegisteredBean, name);
            Assert.state((methodGenerator != null ? 1 : 0) != 0, (String)"Unexpected filtering of inner-bean");
            MethodReference generatedMethod = methodGenerator.generateBeanDefinitionMethod(generationContext, this.beanRegistrationsCode);
            return generatedMethod.toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none());
        }
        return null;
    }

    @Nullable
    private RegisteredBean getInnerRegisteredBean(Object value) {
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder beanDefinitionHolder = (BeanDefinitionHolder)value;
            return RegisteredBean.ofInnerBean(this.registeredBean, beanDefinitionHolder);
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)value;
            return RegisteredBean.ofInnerBean(this.registeredBean, beanDefinition);
        }
        return null;
    }

    @Override
    public CodeBlock generateSetBeanInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, CodeBlock instanceSupplierCode, List<MethodReference> postProcessors) {
        CodeBlock.Builder code = CodeBlock.builder();
        if (postProcessors.isEmpty()) {
            code.addStatement("$L.setInstanceSupplier($L)", new Object[]{"beanDefinition", instanceSupplierCode});
            return code.build();
        }
        code.addStatement("$T $L = $L", new Object[]{ParameterizedTypeName.get(InstanceSupplier.class, (Type[])new Type[]{this.registeredBean.getBeanClass()}), "instanceSupplier", instanceSupplierCode});
        for (MethodReference postProcessor : postProcessors) {
            code.addStatement("$L = $L.andThen($L)", new Object[]{"instanceSupplier", "instanceSupplier", postProcessor.toCodeBlock()});
        }
        code.addStatement("$L.setInstanceSupplier($L)", new Object[]{"beanDefinition", "instanceSupplier"});
        return code.build();
    }

    @Override
    public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, boolean allowDirectSupplierShortcut) {
        if (this.hasInstanceSupplier()) {
            throw new AotBeanProcessingException(this.registeredBean, "instance supplier is not supported");
        }
        return new InstanceSupplierCodeGenerator(generationContext, beanRegistrationCode.getClassName(), beanRegistrationCode.getMethods(), allowDirectSupplierShortcut).generateCode(this.registeredBean, this.instantiationDescriptor.get());
    }

    @Override
    public CodeBlock generateReturnCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("return $L", new Object[]{"beanDefinition"});
        return code.build();
    }

    private boolean hasInstanceSupplier() {
        return this.registeredBean.getMergedBeanDefinition().getInstanceSupplier() != null;
    }
}

