/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentRef;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;

public class ComponentXMLProvider
extends LabelProvider
implements ITreeContentProvider,
ILabelProvider {
    public static final int SHOW_COMPONENT_REFS = 0;
    public static final int SHOW_PLUGINS = 1;
    public static final int SHOW_APIS = 2;
    private int show;

    public ComponentXMLProvider(int show) {
        this.show = show;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Package) {
            return ((Package)element).getTypes().size() > 0;
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Package) {
            Collection types = ((Package)parentElement).getTypes();
            return types.toArray(new Type[0]);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (this.show == 0 && inputElement instanceof ComponentDepends) {
            Collection compRefs = ((ComponentDepends)inputElement).getComponentRefs();
            return compRefs.toArray(new ComponentRef[0]);
        }
        if (this.show == 1 && inputElement instanceof ComponentXML) {
            Collection plugins = ((ComponentXML)inputElement).getPlugins();
            return plugins.toArray(new Plugin[0]);
        }
        if (this.show == 2 && inputElement instanceof ComponentXML) {
            Collection packages = ((ComponentXML)inputElement).getPackages();
            return packages.toArray(new Package[0]);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public String getText(Object element) {
        if (this.show == 0 && element instanceof ComponentRef) {
            return ((ComponentRef)element).getName();
        }
        if (this.show == 1 && element instanceof Plugin) {
            return ((Plugin)element).getId();
        }
        if (this.show == 2) {
            if (element instanceof Package) {
                return ((Package)element).getName();
            }
            if (element instanceof Type) {
                return ((Type)element).getName();
            }
        }
        return element.toString();
    }
}

