/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;

public class JSFLibraryConfigPersistData {
    protected static final String SPTR_TUPLE = ":";
    protected static final String EO_TUPLE = ";";
    private IProject project;
    private JSFLibraryRegistry jsfLibReg;
    private JSFLibraryDecorator selJSFLibImpl = null;
    private List selJSFLibComp = null;

    protected JSFLibraryConfigPersistData(IProject project) {
        this.project = project;
        this.jsfLibReg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
    }

    protected JSFLibraryDecorator getSelectedJSFLibImplementation() {
        try {
            if (this.selJSFLibImpl == null) {
                String strImplLibs = this.project.getPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"));
                this.selJSFLibImpl = this.getSelectedJSFLibImpl(this.getTuples(strImplLibs));
            }
        }
        catch (CoreException e) {
            if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() != null) {
                JSFLibrary jsfLib = JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation();
                if (jsfLib != null) {
                    this.selJSFLibImpl = new JSFLibraryDecorator(jsfLib, true, jsfLib.isDeployed());
                }
            }
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
        return this.selJSFLibImpl;
    }

    protected List getSelectedJSFLibComponent() {
        try {
            if (this.selJSFLibComp == null) {
                this.selJSFLibComp = new ArrayList(Collections.EMPTY_LIST);
                String strCompLibs = this.project.getPersistentProperty(new QualifiedName("", "jsf.component.libraries"));
                this.initJSFCompLibs(this.getTuples(strCompLibs), this.selJSFLibComp);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
        return this.selJSFLibComp;
    }

    protected void saveData(List selJSFLibImpl, List selJSFLibComp) {
        try {
            this.project.setPersistentProperty(new QualifiedName("", "jsf.implementation.libraries"), this.generatePersistString(selJSFLibImpl));
            this.project.setPersistentProperty(new QualifiedName("", "jsf.component.libraries"), this.generatePersistString(selJSFLibComp));
            this.selJSFLibImpl = null;
            this.selJSFLibComp = null;
        }
        catch (CoreException e) {
            JSFCorePlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
    }

    private JSFLibraryDecorator getSelectedJSFLibImpl(List jsfLibTuples) {
        Iterator itTuple = jsfLibTuples.iterator();
        while (itTuple.hasNext()) {
            JSFLibrary jsfLib;
            Tuple tuple = (Tuple)itTuple.next();
            if (this.jsfLibReg == null || (jsfLib = this.jsfLibReg.getJSFLibraryByID(tuple.ID)) == null) continue;
            return new JSFLibraryDecorator(jsfLib, tuple.selected, tuple.deploy);
        }
        return null;
    }

    private void initJSFCompLibs(List jsfLibTuples, List JSFCompLibs) {
        Iterator itTuple = jsfLibTuples.iterator();
        while (itTuple.hasNext()) {
            JSFLibrary jsfLib;
            Tuple tuple = (Tuple)itTuple.next();
            if (this.jsfLibReg == null || (jsfLib = this.jsfLibReg.getJSFLibraryByID(tuple.ID)) == null) continue;
            JSFLibraryDecorator newJSFLibDcrt = new JSFLibraryDecorator(jsfLib, tuple.selected, tuple.deploy);
            JSFCompLibs.add(newJSFLibDcrt);
        }
    }

    private String generatePersistString(List list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            JSFLibraryDecorator jsfLibItem = (JSFLibraryDecorator)list.get(i);
            sb = sb.append(jsfLibItem.generatePersistString());
            sb.append(EO_TUPLE);
            ++i;
        }
        return sb.toString();
    }

    private List getTuples(String strJSFLibs) {
        ArrayList<Tuple> list = new ArrayList<Tuple>(Collections.EMPTY_LIST);
        if (strJSFLibs != null) {
            String patternStr = EO_TUPLE;
            String[] fields = strJSFLibs.split(patternStr);
            if (strJSFLibs.length() > 0) {
                int i = 0;
                while (i < fields.length) {
                    Tuple tuple = new Tuple(fields[i]);
                    list.add(tuple);
                    ++i;
                }
            }
        }
        return list;
    }

    class Tuple {
        private String ID;
        private boolean selected = false;
        private boolean deploy = true;

        Tuple(String ID, boolean selected, boolean deploy) {
            this.ID = ID;
            this.selected = selected;
            this.deploy = deploy;
        }

        Tuple(String tuple) {
            String[] fields = tuple.split(JSFLibraryConfigPersistData.SPTR_TUPLE);
            this.ID = fields[0];
            this.selected = Boolean.valueOf(fields[1]);
            this.deploy = Boolean.valueOf(fields[2]);
        }

        String getID() {
            return this.ID;
        }

        boolean isSelected() {
            return this.selected;
        }

        boolean needDeploy() {
            return this.deploy;
        }
    }
}

